/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SETUPWINDOW
#define SETUPWINDOW

#include "config.h"
#include "global.h"


namespace demo
{
	class setupwindow {
	public:
		setupwindow(int argc, char **argv, config *cfg);
		void show();

	private:	
		// Callback casts
		static void cb_sound(void *lparam) {
			((setupwindow*)lparam)->set_soundstatus();
		}
		static void cb_window(void *lparam) {
			((setupwindow*)lparam)->set_windowstatus();
		}
		static void cb_res_640(void *lparam) {
			((setupwindow*)lparam)->set_res640();
		}
#ifdef DEBUG
		static void cb_scene_0(void *lparam) {
			((setupwindow*)lparam)->set_scene_0();
		}		
		static void cb_scene_1(void *lparam) {
			((setupwindow*)lparam)->set_scene_1();
		}
		static void cb_scene_2(void *lparam) {
			((setupwindow*)lparam)->set_scene_2();
		}		
		static void cb_scene_3(void *lparam) {
			((setupwindow*)lparam)->set_scene_3();
		}				
		static void cb_scene_all(void *lparam) {
			((setupwindow*)lparam)->set_scene_all();
		}				
		void set_scene_all();
		void set_scene_0();
		void set_scene_1();
		void set_scene_2();
		void set_scene_3();
#endif

		/*static void cb_res_320(void *lparam) {
			((setupwindow*)lparam)->set_res320();
		}*/	
		
		void set_soundstatus();
		void set_windowstatus();
		void set_res640();
		//void set_res320();		

	};
}

#endif
