/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "music.h"
#include "support.h"
#include "config.h"

#include <iostream>
#include <cstdlib>
#include <cstring>
#include <fstream>

#ifdef unix
#include <SDL_mixer.h>
#endif

#ifdef WIN32
#include <SDL/SDL_mixer.h>
#include <windows.h>
#endif

using namespace demo;
using namespace std;

music::music(demo::config *c)
{
	cfg = c;
	
	// Open 44.1KHz, signed 16bit, system byte order, stereo audio,
	// using 1024 byte chunks 
	if(Mix_OpenAudio(c->get_samplerate(), MIX_DEFAULT_FORMAT, 2, 1024) == -1)
	{
		string warn = "Mix_OpenAudio: ";
		warn += Mix_GetError();
		warning(warn.c_str());
	}
}

void music::play(const char *file)
{
	Mix_Music *sound;
	FILE *fp = fopen(file, "r");
	if(fp)
	{
		Mix_VolumeMusic(MIX_MAX_VOLUME);
		cfg->set_vol(MIX_MAX_VOLUME);
		
		sound = Mix_LoadMUS(file);

		if(!sound)
		{
			// This might be a critical error...
			string warn = "Mix_LoadMUS(";
			warn += file;
			warn += "): ";
			warn += Mix_GetError();
			warning(warn.c_str());
		}

		/* Start playing in an infinite loop */
		if(-1 == Mix_PlayMusic(sound, -1))
		{
			string warn = "Mix_PlayMusic: ";
			warn += Mix_GetError();
			warning(warn.c_str());
		}
	}
	else
	{
		string warn = "Could not open ";
		warn += file;
		warn += ", sound disabled.";
		warning(warn.c_str());
	}
}

void music::set_vol(int vol)
{
	Mix_VolumeMusic(vol);
	cfg->set_vol(vol);
}
