/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"
#include "video.h"
#include "music.h"
#include "support.h"
#include "../scene/scene_matrix.h"
#include "../scene/scene_end.h"
#include "../scene/scene_intro.h"
#include "../scene/scene_disco.h"
#include "../scene/scene_manager.h"
#include <iostream>

using namespace std;

#ifdef USE_GTK // Defined in basecode/Makefile*
#include "setupwindow.h"
#endif

int main(int argc, char **argv)
{	
	// Init
	demo::config cfg;

#ifdef USE_GTK // Defined in basecode/Makefile*
	#ifdef DEBUG
		cfg.set_scenetotal(4);
	#endif	
	demo::setupwindow(argc, argv, &cfg).show();
#endif

#ifndef USE_GTK
	#ifdef DEBUG
		cfg.set_scene(-1);
	#endif	
#endif
	demo::music musicplayer(&cfg);
	demo::video videoshader(cfg.get_width(), cfg.get_height(),
							cfg.get_bpp(), cfg.get_fullscreen());
	
	// Init scenes
	demo::scene::intro intro(videoshader.get_screen640());
	demo::scene::matrix matrix(videoshader.get_screen640());
	demo::scene::disco disco(videoshader.get_screen640());
	//demo::scene::end end(videoshader.get_screen640());

	// Init scene manager
	demo::scene::manager mgr(&videoshader, &musicplayer);
	mgr.add(&intro);
	mgr.add(&matrix);
	mgr.add(&disco);
	//mgr.add(&end);
	
	// Start music
	if(cfg.get_sound())
		musicplayer.play("../data/pb-world_trip.ogg");

	// Run xa-002: Scratch!	
#ifndef DEBUG
	mgr.runall();
#endif
	
#ifdef DEBUG
	if(cfg.get_scene() == -1)
		mgr.runall();
	else {
		mgr.run(cfg.get_scene());
		demo_shutdown();
	}
#endif

	return 0;
}

#ifdef WIN32
#include "WINDOWS.H"
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, 
				   LPSTR lpCmdLine, int nCmdShow)
{
	char* a = new char[strlen(GetCommandLine())];
	strcpy(a,GetCommandLine());
	if(a[0]=='\"') {
		strcpy(a,a+1);
		a[strlen(a)] = '\0';
	};
	main(1,&a);
	return 0;
}
#endif
