/*
  -: Erssi :-
  By. Mankeli / Hno3
  Copyright(C) 2002-2003 Hno3

 -- vectors.h --

originally ripped from Persistence of Vision(tm) Ray Tracer
Copyright 1996-2002 Persistence of Vision Team

but violently raped :G
*/

#ifndef VECTOR_H
#define VECTOR_H

typedef struct vector_t
{
	float x,y,z;
} vector_t;

/* Misc. Vector Math Macro Definitions */

#define VMake(a, b, c, d) {(a).x=(b);(a).y=(c);(a).z=(d);}
#define VZero(a) {(a).x=0;(a).y=0;(a).z=0;}

/* Vector Add */
#define VAdd(a, b, c) {(a).x=(b).x+(c).x;(a).y=(b).y+(c).y;(a).z=(b).z+(c).z;}
#define VAddEq(a, b) {(a).x+=(b).x;(a).y+=(b).y;(a).z+=(b).z;}

/* Vector Subtract */
#define VSub(a, b, c) {(a).x=(b).x-(c).x;(a).y=(b).y-(c).y;(a).z=(b).z-(c).z;}
#define VSubEq(a, b) {(a).x-=(b).x;(a).y-=(b).y;(a).z-=(b).z;}

/* Scale - Multiply Vector by a Scalar */
#define VScale(a, b, k) {(a).x=(b).x*(k);(a).y=(b).y*(k);(a).z=(b).z*(k);}
#define VScaleEq(a, k) {(a).x*=(k);(a).y*=(k);(a).z*=(k);}

/* Inverse Scale - Divide Vector by a Scalar */
#define VInverseScale(a, b, k) {float _tmp=1.0/(k); (a).x=(b).x*_tmp;(a).y=(b).y*_tmp;(a).z=(b).z*_tmp;}
#define VInverseScaleEq(a, k) {float _tmp=1.0/(k); (a).x*=_tmp;(a).y*=_tmp;(a).z*=_tmp;}

/* Dot Product - Gives Scalar angle (a) between two vectors (b) and (c) */
#define VDot(a, b, c) {a=(b).x*(c).x+(b).y*(c).y+(b).z*(c).z;}

/* Cross Product - returns Vector (a) = (b) x (c)
   WARNING:  a must be different from b and c.*/
#define VCross(a,b,c) {(a).x=(b).y*(c).z-(b).z*(c).y; \
                       (a).y=(b).z*(c).x-(b).x*(c).z; \
                       (a).z=(b).x*(c).y-(b).y*(c).x;}

/* Evaluate - returns Vector (a) = Multiply Vector (b) by Vector (c) */
#define VEvaluate(a, b, c) {(a).x=(b).x*(c).x;(a).y=(b).y*(c).y;(a).z=(b).z*(c).z;}
#define VEvaluateEq(a, b) {(a).x*=(b).x;(a).y*=(b).y;(a).z*=(b).z;}

/* Divide - returns Vector (a) = Divide Vector (b) by Vector (c) */
#define VDiv(a, b, c) {(a).x=(b).x/(c).x;(a).y=(b).y/(c).y;(a).z=(b).z/(c).z;}
#define VDivEq(a, b) {(a).x/=(b).x;(a).y/=(b).y;(a).z/=(b).z;}

/* Simple Scalar Square Macro */
#define Sqr(a)  ((a)*(a))

/* Square a Vector (b) and Assign to another Vector (a) */
#define VSquareTerms(a, b) {(a).x=(b).x*(b).x;(a).y=(b).y*(b).y;(a).z=(b).z*(b).z;}

/* Vector Length - returs Scalar Euclidean Length (a) of Vector (b) */
#define VLength(a, b) {a=sqrt((b).x*(b).x+(b).y*(b).y+(b).z*(b).z);}

/* Vector Distance - returs Scalar Euclidean Distance (a) between two
 * points/Vectors (b) and (c) */
#define VDist(a, b, c) {VECTOR _tmp; VSub(_tmp, b, c); VLength(a, _tmp);}

/* Normalize a Vector - returns a vector (length of 1) that points at (b) */
#define VNormalize(a,b) {float _tmp=1.0/sqrt((b).x*(b).x+(b).y*(b).y+(b).z*(b).z);(a).x=(b).x*_tmp;(a).y=(b).y*_tmp;(a).z=(b).z*_tmp;}
#define VNormalizeEq(a) {float _tmp=1.0/sqrt((a).x*(a).x+(a).y*(a).y+(a).z*(a).z);(a).x*=_tmp;(a).y*=_tmp;(a).z*=_tmp;}

/* Compute a Vector (a) Halfway Between Two Given Vectors (b) and (c) */
#define VHalf(a, b, c) {(a).x=0.5*((b).x+(c).x);(a).y=0.5*((b).y+(c).y);(a).z=0.5*((b).z+(c).z);}

/* Calculate the sum of the sqares of the components of a vector.  (the square of its length) */
#define VSumSqr(a)  ((a).x*(a).x + (a).y*(a).y + (a).z*(a).z)



/*
 * Linear combination of 2 vectors. [DB 7/94]
 *
 *   V = k1 * V1 + k2 * V2
 */
#define VLinComb2(V, k1, V1, k2, V2)            \
  { (V).x = (k1) * (V1).x + (k2) * (V2).x;   \
    (V).y = (k1) * (V1).y + (k2) * (V2).y;   \
    (V).z = (k1) * (V1).z + (k2) * (V2).z; }



/*
 * Linear combination of 3 vectors. [DB 7/94]
 *
 *   V = k1 * V1 + k2 * V2 + k3 * V3
 */
#define VLinComb3(V, k1, V1, k2, V2, k3, V3)                     \
  { (V).x = (k1) * (V1).x + (k2) * (V2).x + (k3) * (V3).x;   \
    (V).y = (k1) * (V1).y + (k2) * (V2).y + (k3) * (V3).y;   \
    (V).z = (k1) * (V1).z + (k2) * (V2).z + (k3) * (V3).z; }



/*
 * Evaluate a ray equation. [DB 7/94]
 *
 *   IPoint = Initial + depth * Direction
 */
#define VEvaluateRay(IPoint, Initial, depth, Direction)      \
  { (IPoint).x = (Initial).x + (depth) * (Direction).x;   \
    (IPoint).y = (Initial).y + (depth) * (Direction).y;   \
    (IPoint).z = (Initial).z + (depth) * (Direction).z; }



/*
 * Add a scaled vector. [DB 7/94]
 *
 *   V  = V1 + k * V2;
 *   V += k * V2;
 */
#define VAddScaled(V, V1, k, V2)         \
  { (V).x = (V1).x + (k) * (V2).x;    \
    (V).y = (V1).y + (k) * (V2).y;    \
    (V).z = (V1).z + (k) * (V2).z; }

#define VAddScaledEq(V, k, V2)  \
  { (V).x += (k) * (V2).x;    \
    (V).y += (k) * (V2).y;    \
    (V).z += (k) * (V2).z; }



/*
 * Subtract a scaled vector. [DB 8/94]
 *
 *   V  = V1 - k * V2;
 *   V -= k * V2;
 */
#define VSubScaled(V, V1, k, V2)         \
  { (V).x = (V1).x - (k) * (V2).x;    \
    (V).y = (V1).y - (k) * (V2).y;    \
    (V).z = (V1).z - (k) * (V2).z; }

#define VSubScaledEq(V, k, V2)  \
  { (V).x -= (k) * (V2).x;    \
    (V).y -= (k) * (V2).y;    \
    (V).z -= (k) * (V2).z; }



/*
 * Calculate the volume of a bounding box. [DB 8/94]
 */

#define BOUNDS_VOLUME(a, b)                                   \
  { (a) = (b).Lengths.x * (b).Lengths.y * (b).Lengths.z; }


/*
 * Linear combination of 2 colours. [CEY]
 *
 *   C = k1 * C1 + k2 * C2
 */
#define CLinComb2(C, k1, C1, k2, C2)            \
  { (C)[pRED]    = (k1) * (C1)[pRED]    + (k2) * (C2)[pRED];   \
    (C)[pGREEN]  = (k1) * (C1)[pGREEN]  + (k2) * (C2)[pGREEN]; \
    (C)[pBLUE]   = (k1) * (C1)[pBLUE]   + (k2) * (C2)[pBLUE];  \
    (C)[pFILTER] = (k1) * (C1)[pFILTER] + (k2) * (C2)[pFILTER];\
    (C)[pTRANSM] = (k1) * (C1)[pTRANSM] + (k2) * (C2)[pTRANSM];}


/* Misc. 4D Vector Math Macro Definitions */
/* Inverse Scale - Divide Vector by a Scalar */
#define V4D_InverseScale(a, b, k) {float _tmp = 1.0/(k); (a).x=(b).x*_tmp;(a).y=(b).y*_tmp;(a).z=(b).z*_tmp;(a)[T]=(b)[T]*_tmp;}
#define V4D_InverseScaleEq(a, k) {float _tmp = 1.0/(k); (a).x*=_tmp;(a).y*=_tmp;(a).z*=_tmp;(a)[T]*=_tmp;}

/* Dot Product - Gives Scalar angle (a) between two vectors (b) and (c) */
#define V4D_Dot(a, b, c) {a=(b).x*(c).x+(b).y*(c).y+(b).z*(c).z+(b)[T]*(c)[T];}

#endif


