#include "allegro.h"
#include "ercgolf.h"

BITMAP *dblbuf;
int gfx_bpp,gfx_w,gfx_h,gfx_xofs,gfx_yofs,gfx_blitmode;

void main_loop();

volatile int t,fps,tfps;

void tick(void)
{
   t++;
}

END_OF_FUNCTION(tick);
void tick2(void)
{
   fps=tfps;
   tfps=0;
}

END_OF_FUNCTION(tick);


void gfx_blit(void)
{
	acquire_screen();
	set_color_depth(gfx_bpp);
	switch(gfx_blitmode)
	{
		case 0:
		blit(dblbuf,screen,0,0,gfx_xofs,gfx_yofs,512,384);
		break;
		case 1:
		stretch_blit(dblbuf,screen,0,0,512,384,0,0,gfx_w,gfx_h);
		break;
	}
		//text_mode(0);
		//textprintf(screen,font,8,8,makecol32(255,0,0),"%i",fps);

set_color_depth(32);
	release_screen();
	tfps++;
}

void gfx_332pal(void)
{
	PALETTE pall;
	generate_332_palette(pall);
	set_palette(pall);
	select_palette(pall);
}

int gfx_init(void)
{
	int gfx_mode;
	FILE *handle;
	int no_file = 0;

	printf("gfx_init(): Initialazing GFX..\n");

	gfx_mode = 0;
	gfx_w = 512;
	gfx_h = 384;
	gfx_bpp = 32;

	handle=fopen("gfx_modes.cfg", "r");
	if (handle==NULL)
	{
		no_file=1;
		printf("gfx_init(): Warning: Can't open gfx_modes.cfg.\n");
	}
	if (no_file==0)
		fseek(handle, 0, SEEK_SET);


	for (;;)
	{
		if (no_file==0)
		{
			fscanf(handle,"%i %i %i %i %i",&gfx_mode,&gfx_w,&gfx_h,&gfx_bpp,&gfx_blitmode);
			if (gfx_w==0&&gfx_h==0)
			{
				fclose(handle);
				goto no_modes;
			}
		}

		printf("gfx_init(): Trying %ix%ix%i...\n",gfx_w,gfx_h,gfx_bpp);

		set_color_depth(gfx_bpp);
		if (set_gfx_mode(gfx_mode, gfx_w, gfx_h, 0, 0) == 0)
			goto success;

		if (no_file==1) goto no_modes;
	}
	no_modes:;
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Error setting graphics mode\n%s\n", allegro_error);
		return 1;

	success:;
	if (gfx_bpp==8) gfx_332pal();
	gfx_xofs = (gfx_w-512)/2;
	gfx_yofs = (gfx_h-384)/2;

	//printf("gfx_init(): Creating buffer 512x384x32 (i%)
	dblbuf = create_bitmap_ex(32,512,384);
	set_color_depth(32);
	return 0;

}

void gfx_deinit(void)
{
	destroy_bitmap(dblbuf);
	printf("gfx_deinit(): doublebuffer destroyed.\n");
}


int main(void)
{
	printf("minigolffipeli by.mankeli/hno3\n");
	allegro_init();
	install_mouse();
	install_timer();
	install_keyboard();
	set_window_title("minigolfpippeli <3 veezay+puntro06+cruz^");

	LOCK_VARIABLE(t);
	LOCK_VARIABLE(fps);
	LOCK_VARIABLE(tfps);
	LOCK_FUNCTION(tick);

	install_int_ex(tick, BPS_TO_TIMER(40));
	install_int_ex(tick2, BPS_TO_TIMER(1));

	if (gfx_init() != 0)
	{
		printf("Error!\n");
		return 1;
	}

	printf("main(): entering main loop..\n");
	main_loop();

	gfx_deinit();

	return 0;
}
END_OF_MAIN();




