
#include "robot.hpp"
#include "consts.hpp"
#include <string>
#include <cstdlib>

const std::string robot_name = "cerne";
const int color_1 = 0xAA2222;
const int color_2 = 0x1111EE;

class cernebot : public rtb::Robot {
  struct {
    double distance;
    rtb::Consts::object_type object;
    double radar_angle;
    double time;
    double speed;
    double cannon_angle;
    double energy;
    int teammate;
  } info;

  int refract;
  int disparando;
  double disp_time;
  double giro_time;
  double potencia;
  void actua ();

public:
  cernebot (std::string name, int colour, int away_colour);
  virtual ~cernebot () { }
  void GameStarts ();
  void Radar (double distance, rtb::Consts::object_type object, double radar_angle);
  void Info (double time, double speed, double cannon_angle);
  void Collision (rtb::Consts::object_type object, double angle);
  void RobotInfo (double energy, int teammate);

};

cernebot::cernebot (std::string name, int colour, int away_colour)
  : Robot::Robot (name, colour, away_colour) {
}

void cernebot::GameStarts () {
  Accelerate (10);
  Sweep (rtb::Consts::ROTATE_CANNON_RADAR, 1000, -0.5, 0.5);
  refract = 0;
  disparando=0;
  giro_time=0;
}

void cernebot::Radar (double distance, rtb::Consts::object_type object, double radar_angle) {
  info.distance = distance;
  info.object = object;
  info.radar_angle = radar_angle;
}

void cernebot::Info (double time, double speed, double cannon_angle) {
  info.time = time;
  info.speed = speed;
  info.cannon_angle = cannon_angle;
  if (disparando==1) {
	  Shoot(potencia);
	  if ((time-disp_time)>=0.8) {
		  disparando=0;
		  Sweep (rtb::Consts::ROTATE_CANNON_RADAR, 1000, -0.5, 0.5);
	  }
  }
  
  if (info.object != rtb::Consts::IS_ROBOT) {
    actua ();
  }
}

void cernebot::Collision (rtb::Consts::object_type object, double angle) {
  if (object == rtb::Consts::IS_SHOT) {
    if ((angle < -0.5) || (angle > 0.5)) {
      Print ("Ouch!");
      Accelerate (1000);
    }
    else {
	    potencia=1;
	    disparando=1;
    }
  }
}

void cernebot::RobotInfo (double energy, int teammate) {
  info.energy = energy;
  info.teammate = teammate;

  if (!info.teammate) {
    actua ();
  }
}

void cernebot::actua () {
  if (refract)
    refract--;
  switch (info.object) {
  case rtb::Consts::IS_ROBOT:
	  double correccion;
	  if (info.radar_angle<0.15) {correccion=-0.15;}
	  else if (info.radar_angle>0.15) correccion=0.15;
    RotateAmount (rtb::Consts::ROTATE_ROBOT, 1000, info.radar_angle+correccion);
    disparando=1;
    disp_time=info.time;
    if (info.distance <= 1)
      potencia=100;
    else if (info.distance <= 5)
      potencia=50/info.distance;
    else if (info.distance <= 10)
      potencia=18/info.distance;  
    else
      potencia=0;
    if (info.energy<30) potencia=potencia/2;
    Accelerate (0.45);
    if (info.distance<=2)  Sweep (rtb::Consts::ROTATE_CANNON_RADAR, 1000, -0.1, 0.1);
    else Sweep (rtb::Consts::ROTATE_CANNON_RADAR, 1000, -0.25, 0.25);
      
    break;
  case rtb::Consts::IS_COOKIE:
    RotateAmount (rtb::Consts::ROTATE_ROBOT, 1000, info.radar_angle);
    Accelerate (10);
    break;
  case rtb::Consts::IS_MINE:
    Shoot (0.5);
    break;
  case rtb::Consts::IS_WALL:
    if (info.distance <= 4) {
      Accelerate (-10);
      if ((refract == 0) && (info.radar_angle < 0)) {
	RotateAmount (rtb::Consts::ROTATE_ROBOT, 1000, 3.1416);
	refract = 250;
      } else {
	RotateAmount (rtb::Consts::ROTATE_ROBOT, 1000, -3.1416);
	refract = 250;
      }
      break;
    }
  case rtb::Consts::IS_NOOBJECT:
    if ((disparando==0)&&(info.time-giro_time>=3))  {
	Accelerate (((random() % 40) - 10) / 10);
    	RotateAmount (rtb::Consts::ROTATE_ROBOT, 1000, ((random() % 40) - 20) / 10);
	giro_time=info.time;
    }
  }
//  if (refract==0) {
  if (info.speed>=2.6) { 
	  Accelerate(0);
	Brake(1);

  }
  else if (info.speed<=2.4) {
	Brake(0);
	  Accelerate(10);
  }
  else {
	  Accelerate(0);
	  Brake(0);
  }
 // }
}

int main(void) {
  cernebot cerne (robot_name, color_1, color_2);

  cerne.Scanner();

  return 0;
}
