	; in: b (number of bytes)
setbgpal::
	ld	a, $80
	ld      [rBCPS], a
	ldh	a, [rSTAT]
	ldh	[alpha], a
	xor	a
	ldh	[alpha], a
	ld	c, rBCPD & 255
.loop	ld	d, [hl]
	inc	hl
	VRWAIT
	ld	a, d
	ld	[c], a
	dec     b
	jr      nz, .loop
	ldh	a, [alpha]
	ld	[rSTAT], a
	ret

	; in: b (number of bytes)
setobpal::
	ld	a, $80
	ld      [rOCPS], a
	ldh	a, [rSTAT]
	ldh	[alpha], a
	xor	a
	ldh	[alpha], a
	ld	c, rOCPD & 255
.loop	ld	d, [hl]
	inc	hl
	VRWAIT
	ld	a, d
	ld	[c], a
	dec     b
	jr      nz, .loop
	ldh	a, [alpha]
	ld	[rSTAT], a
	ret
	
	;  in: rgb=de
	; out: r=a g=l b=h
c24to15	rlca
	rlca
	rlca
	ld	e, a
	srl	l
	rr	e
	srl	l
	rr	e
	srl	l
	rr	e
	ld	a, h
	add	a, a
	add	a, a
	add	a, l
	ld	d, a
	ret
	
	; out: r=a g=l b=h
	;  in: rgb=de
c15to24	ld	a, e
	srl	d
	rr	e
	srl	d
	rr	e
	ld	h, d
	srl	e
	srl	e
	ld	l, e
	and	31
	ret
	
	; in: [rXCPS], c=rXCPD, b=num
lighten	ld	a, [c]
	ld	e, a
	ld	a, [c]
	ld	d, a
	call	c15to24
	ld	e, 31
	cp	e
	adc	0
	ld	d, a
	ld	a, l
	cp	e
	adc	0
	ld	l, a
	ld	a, h
	cp	e
	adc	0
	ld	h, a
	dec	c
	ld	a, [c]
	sub	2
	ld	[c], a
	inc	c
	ld	a, d
	call	c24to15
	ld	a, e
	ld	[c], a
	ld	d, a
	ld	[c], a
	djnz	lighten
	ret
	
	; in: [rXCPS], c=rXCPD, b=num
darken	ld	a, [c]
	ld	e, a
	ld	a, [c]
	ld	d, a
	call	c15to24
	ld	e, 1
	cp	e
	sbc	0
	ld	d, a
	ld	a, l
	cp	e
	sbc	0
	ld	l, a
	ld	a, h
	cp	e
	sbc	0
	ld	h, a
	dec	c
	ld	a, [c]
	sub	2
	ld	[c], a
	inc	c
	ld	a, d
	call	c24to15
	ld	a, e
	ld	[c], a
	ld	d, a
	ld	[c], a
	djnz	lighten
	ret

flush	ld	hl, rBCPS
	ld	[hl], $80
	inc	l
	xor	a
.loop	VRWAIT
	ld	[hl], e
	inc	l
	VRWAIT
	ld	[hl], d
	inc	l
	bit	6, l
	jr      z, .loop
	ret
