	INCLUDE	"hardware.inc"
	INCLUDE	"carillon.inc"
	INCLUDE	"dalton.inc"
	
homeb	equ	0
data1	equ	1
data2	equ	2
data3	equ	3
data4	equ	4
data5	equ	5
mathb	equ	6
musicb	equ	7

stack	equ	$c7be
oambuf	equ	$c800
ylist	equ	$c900
rampage1 equ	$ca00
rampage2 equ	$cb00
rampage3 equ	$cc00
rampage4 equ	$cd00
rampage5 equ	$ce00
rampage6 equ	$cf00

beta	equ	$ffe8
gamma	equ	$ffe9
delta	equ	$ffea
counter	equ	$ffeb
count2	equ	$ffec
count3	equ	$ffed
count5	equ	$ffee
alpha	equ	$ffef
curbank	equ	$fff0
lcdcirq	equ	$fff1
oamdma	equ	$fff4
countl	equ	$fffc
counth	equ	$fffd
vblflag	equ	$fffe

	xdef	homeb, data1, data2, data3, data4, data5, mathb, musicb
	xdef	stack, oambuf
	xdef	alpha, lcdcirq, oamdma, countl, counth, vblflag

	SECTION	"bit lookup", HOME[$0000]
	DB	%10000000
	DB	%01000000
	DB	%00100000
	DB	%00010000
	DB	%00001000
	DB	%00000100
	DB	%00000010
	DB	%00000001

oamdma_	ldio	[rDMA], a
	ld	a, $28
.loop	dec	a
	jr	nz, .loop
	ret

	SECTION	"wait vbl", HOME[$0010]
waitvbl	xor	a
	ld	hl, vblflag
.loop	halt
	cp	[hl]
	jr	z, .loop
	ld	[hl], a
	ret
waitVBL: MACRO
	rst	$10
	ENDM

jphl::	jp	[hl]

	SECTION	"vbl code", HOME[$0020]
vblirq	push	af
	push	de
	push	hl
	ld	hl, countl	; 3	3
	ld	e, [hl]		; 2	1
	inc	l		; 1	1
	ld	d, [hl]		; 2	1
	inc	de		; 2	1
	ld	[hl], d		; 2	1
	dec	l		; 1	1
	ld	[hl], e		; 2	1
	ld	a, $ff
	ldh	[vblflag], a
	pop	hl
	pop	de
	pop	af
retint	reti

	;DB	"   ___ ________ "
	;DB	"  / _ ",92," _/_  _/ "
	;DB	"  ",92,"___/__",92,"/_/   "

	SECTION	"vbl interrupt", HOME[$0040]
	;db	$18, 8 ; jr vblirq(=$004a)
	rst	$20

	SECTION	"lcdc interrupt", HOME[$0048]
	db	$18, -89 ; jr lcdcirq(=$fff1)

music_int
	PUSHA
	MusicUpdate musicb
	ldh	a, [curbank]
	ld	[rROMB0], a
	POPA
	reti
	
	SECTION	"waste of space", HOME[$0060]
	DB	"                "
	DB	"                "
	DB	"    .$$$$$$.    "
	DB	"    $$'  '$$    "
	DB	"    ''   .$$    "
	DB	"       .$$'     "
	DB	"       $$'      "
	DB	"       ''       "
	DB	"       $$       "
	DB	"                "

	SECTION	"header", HOME[$0100]
	nop
	jp	begin

	DB	$CE,$ED,$66,$66,$CC,$0D,$00,$0B,$03,$73,$00,$83,$00,$0C,$00,$0D
	DB	$00,$08,$11,$1F,$88,$89,$00,$0E,$DC,$CC,$6E,$E6,$DD,$DD,$D9,$99
	DB	$BB,$BB,$67,$63,$6E,$0E,$EC,$CC,$DD,$DC,$99,$9F,$BB,$B9,$33,$3E
	DB	"SPACE WASTE OCT"	; Title of the game
	DB	$c0			; gbc only
	DB	$00, $00		; Licensee code
	DB	$00			; Gameboy (not sgb)
	DB	$19			; Cartridge type: MBC5
	DB	$02			; Rom Size: 128k (8 banks)
	DB	$00			; Ram Size: n/a
	DB	$01			; Non japanese
	DB	$33			; Licensee code (old)
	DB	$00			; Mask ROM Version number
	DB	$00			; Complement checksum
	DB	$00, $00		; Checksum

	SECTION "code", HOME[$150]

begin	di

	ld	sp, stack

	; Turn lcd off
	xor	a
	ldio	[rLCDC], a
	
	; Set double speed
	ld	a, 1
	ldio	[rKEY1], a
	stop

	; copy oam dma transfer routine to hram
	ld	hl, oamdma_
	ld	de, oamdma
	ld	bc, 8
	call	memcopy

	ld	a, $c3 ; (jp)
	ld	[lcdcirq], a
	ld	de, retint
	call	setlcdcirq
 	
	ROMBANK	musicb
	call	Player_Initialize
	call	Player_MusicStart

	xor	a
	ldio	[rSCX], a
	ldio	[rSCY], a
	ldh	[counth], a
	ldh	[countl], a

	xor	a
	ldio	[rSTAT], a
	ld	a, %00000011
	ldio	[rIE], a
	ld	a, %10000000
	ldio	[rLCDC], a
	ei

	call	intro
	call	kubrad
	call	snurra
	call	plasma
	call	palmguy
	call	carpet
	call	skruv
	call	balkar
	call	butterfly
	call	distbox
	call	twistbar
	call	endscroller

	di
	halt

	; demoparts

time	set	0
	PUSHS
	INCLUDE	"intro.asm"
	INCLUDE	"kubrad.asm"
	INCLUDE	"snurra.asm"
	INCLUDE	"plasma.asm"
	INCLUDE "palmguy.asm"
	INCLUDE	"carpet.asm"
	INCLUDE "skruv.asm"
	INCLUDE "balkar.asm"
	INCLUDE	"btrfly.asm"
	INCLUDE	"distbox.asm"
	INCLUDE "twist.asm"
	INCLUDE	"endscrol.asm"
	POPS

	; misc. routines

	INCLUDE	"memory.asm"
	INCLUDE "pal.asm"
	INCLUDE	"map.asm"
	INCLUDE "pixel.asm"
	INCLUDE "divmul.asm"

setlcdcirq::
	ld	hl, lcdcirq+1
	ld	[hl], e
	inc	l
	ld	[hl], d
	ret

clearsprites::
	ld	hl, oambuf
	ld	b, 160
	xor	a
	call	memstsh
	waitVBL
	ld	a, oambuf>>8
	call	oamdma
	ret

spmovl	ld	hl, oambuf+1
	cp	[hl]
	ret	z
	ld	b, 160
.loop	dec	[hl]
	inc	l
	inc	l
	inc	l
	inc	l
	djnz	.loop
	ret
spmovr	ld	hl, oambuf+1
	cp	[hl]
	ret	z
	ld	b, 160
.loop	inc	[hl]
	inc	l
	inc	l
	inc	l
	inc	l
	djnz	.loop
	ret
spmovu	ld	hl, oambuf
	cp	[hl]
	ret	z
	ld	b, 160
.loop	dec	[hl]
	inc	l
	inc	l
	inc	l
	inc	l
	djnz	.loop
	ret
spmovd	ld	hl, oambuf
	cp	[hl]
	ret	z
	ld	b, 160
.loop	inc	[hl]
	inc	l
	inc	l
	inc	l
	inc	l
	djnz	.loop
	ret
	

	SECTION	"Math tables (and more)", DATA[$4000], BANK[mathb]
multab	INCBIN  "multab.bin"
sintab	INCLUDE "sinus.inc"
costab	INCLUDE "cosinus.inc"

font	INCBIN	"font.tls"

	SECTION	"Music", DATA[$4000], BANK[musicb]
	INCBIN	"musik.bin"

	SECTION "Reserved", BSS[$c700]
	DS	$90	; the stack
	DS	$30	; $c7c0 - $c7ef for player variables
