// alive.c
//   ALIVE - beastieboys.com logo contest intro (v2.Rev3, Nov 19 2002) - www.sirdan.com
//           uses "Cut 04.wav" from the "Alive Loop Pack 4" acidgrandroyal.com release
//
// Compiler        :  GCC Version 3.0.2 (DevKit-Advance)
// Linker          :  GNU Objcopy 2.11.2 (c) 1997-2002 Free Software Foundation, Inc.
// Platform        :  Nintendo GameBoy Advance
// Usage           :  Play on hardware (otherwise use VisualBoyAdvance v1.2+ GBA EMU)
// 
// BMP Converter   >  GFX2GBA Version 1.03 - Tuesday, November 28, 2001
//                      Syntax . gfx2gba <infile> <outfile> -8 -s 1 -v -w 256
// WAV Converter   >  WAV2RAW v1.0 for Game Boy Advance by Sylvain Rochette
//                      Syntax . wav2raw <filename> -c
//
//
// Documentation .
//
// The GBA has two digital-to-analog converters (dubbed Direct Sound A & B) for
// playing back signed 8-bit PCM samples. Functionally these two channels are equal
// and can be used at the same time, but you really only need to use one. To get the
// GBA to play a sound, all you have to do is feed these channels the correct data
// at the correct rate and the hardware will take care of the rest.
// Only little interrupt and timer studies of the GBA architecture is needed and
// you will easily be able to code full games, intros, music disks, etc.
//
// Here you will get a small example of an intro I did in november of 2002 to score
// for a logo contest held at beastieboys.com with kind permission of icr & rbz
//
// the Specs .
//
// GBA CPU 16.777216 MHz (=16777216Hz)
// PCM WAVE 8Bit Samplingrate 22KHz (=22050Hz) 1 Channel monaural
// BITMAP sizes are 240 pixels x 160 pixels, 8bit pal
//
// the Calculation .
//
// We have to tell the timerbase a correct hex value to make our sample playing on
// the right frequency. Precision counts. $Example: *(u16*)0x4000100 = 0xfd07;
// This is the correct value for 22050Hz or 22KHz. But where the hell do we get
// the hex value 0xfd07 from? Easy that is. We know the CPU frequency, right?
// Now lets see, what happens if we calculate 16777216/22050. The result is
// 760.8714739.. Now substract this result from 65536. This is 64775.128526077..
// If you entered this calculation into your windows calculator, just change to
// hex view now. What we get is fd07! Yeah I know that was much too easy for you.
//
// Now you can use samples in all common frequencies and set the timerbase by your own.
//
// Have a nice christmas 2002!
// -dantro <mailto:dantro@gmx.net>

typedef unsigned char u8;			// define u8  as unsigned char  encoded variable
typedef unsigned short u16;			// define u16 as unsigned short encoded variable
typedef unsigned long u32;			// define u32 as unsigned long  encoded variable

#include "bitmap.h"				// .bmp in c source (encoded as unsigned char)
#include "sound.h"				// .wav in c source (encoded as unsigned long int)

u16* theVideoBuffer   = (u16*)0x6000000;	// set a pointer to the video buffer offset
u16* theScreenPalette = (u16*)0x5000000;	// set a pointer to the screen palette offset

int main()					// the main procedure
{
  *(u32*)0x4000000 = 0x4|0x400;			// initialize screen mode 4 and background mode 2

  u16 i;					// write the bitmap colour palette to the pointer
  for (i = 0; i<256; i++)			// of the screen palette offset. this sets up
    theScreenPalette[i] = bitmapPal[i];		// the environment palette required to show the
						// bitmap correctly

  u16* tempData = (u16*)bitmap;			// write the bitmap to the pointer of the gba
  u16 x, y;					// video buffer. this will show the picture
  for (x   = 0; x < 120; x++)			// on screen of our gba. full screen sizes 240x160
    for (y = 0; y < 160; y++)
      theVideoBuffer[y * 120 + x] = tempData[y * 120 + x];

 
  *(u16*)0x4000080 = 0x0000;			// initialize the sound control register
  *(u16*)0x4000082 = 0x0b0f;			// direct sound control channel (left&right volume)
  *(u16*)0x4000084 = 0x0080;			// turn our gba sound chip on
  *(u32*)0x40000BC = (u32)&wav_sample;		// dma channel 1 source address
  *(u32*)0x40000C0 = 0x040000a0;		// dma channel 1 destination address
  *(u16*)0x4000100 = 0xfd07;			// gba_timerbase: timer0
  
  while(1)					// loop_start:
  {
    *(u16*)0x40000C6 = 0xb640;			// start to play our sample wave
    *(u16*)0x4000102 = 0x0080;			// start the timer0 control

    *(u16*)0x400010A = 2|128;			// start an interrupt timer
    *(u16*)0x400010E = 4|128;			// start another timer on another irq
    *(u16*)0x4000108 = 0;			// clear milliseconds timer
    *(u16*)0x400010C = 0;			// clear seconds timer
    while(*(u16*)0x400010C < 9){}		// this wave is 9 sec + 508 millisec long
    *(u16*)0x4000108 = 0;
    while(*(u16*)0x4000108 / (65536/1000) < 508){}
    *(u16*)0x400010A = 0;			// we are done waiting, stop the timers
    *(u16*)0x400010E = 0;
    *(u16*)0x4000108 = 0;			// clear milliseconds
    *(u16*)0x400010C = 0;			// clear seconds

    *(u16*)0x40000C6 = 0;			// stop playing our wave
    *(u16*)0x4000102 = 0;			// stop the timer0 control
  }

  return 0;					// everything is ok, return 0
}
