// Quaternion.h: interface for the CQuaternion class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_QUATERNION_H__ED53EB87_80CD_473E_B222_C5F30BA77C80__INCLUDED_)
#define AFX_QUATERNION_H__ED53EB87_80CD_473E_B222_C5F30BA77C80__INCLUDED_

#include "Vector4.h"	// Added by ClassView
#include "Vector.h"	// Added by ClassView
#include "Matrix4.h"	// Added by ClassView

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CQuaternion : public CVector4
{
public:
	CQuaternion normalize();
	CQuaternion(CMatrix4 &rotm);
	CQuaternion operator - (CQuaternion &q);
	CQuaternion operator - ();
	CQuaternion squad(float t, CQuaternion &p, CQuaternion &a, CQuaternion &b, CQuaternion &q);
	CQuaternion(float x, float y, float z, float w);
	CQuaternion operator + (CQuaternion &q);
	float dot(CQuaternion &q);
	CQuaternion slerp(float t, CQuaternion &q1, CQuaternion &q2);
	CQuaternion exp();
	CQuaternion log();
	CQuaternion(CQuaternion &q);
	CQuaternion conj();
	CQuaternion operator / (float f);
	CQuaternion operator * (float f);
	CQuaternion operator * (CQuaternion &q);
	CQuaternion inverse();
	float norm();
	void set(CVector axis, float angle);
	CMatrix4 getRotMatrix();
	CVector getAxis();
	float getAngle();
	CQuaternion(CVector axis, float angle);
	CQuaternion();
	virtual ~CQuaternion();
};

#endif // !defined(AFX_QUATERNION_H__ED53EB87_80CD_473E_B222_C5F30BA77C80__INCLUDED_)
