// Font.h: interface for the CFont class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FONT_H__7C229EAA_5EA4_460D_91D4_63ACF314DBCF__INCLUDED_)
#define AFX_FONT_H__7C229EAA_5EA4_460D_91D4_63ACF314DBCF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <gl/gl.h>
#include "vector.h"
#include "color.h"

#define FONT_NORMAL		0
#define FONT_BOLD		1
#define FONT_ITALIC		2
#define FONT_UNDERLINE	4
#define FONT_STRIKEOUT	8

class CTextFont
{
public:
	int getStringWidthPixels(char *s);
	float pointsToLogical(int p);
	inline int getHeightPoints() { return height; }
	int getHeightPixels();
	int getCharWidthPixels(char c);
	inline GLYPHMETRICSFLOAT *getMetrics() { return gmf; }
	void print3dl(char *str);
	void print3dp(char *str);
	void print2d(CVector &pos, CColor &color, char *str);
	void print3dp(CVector &pos, CColor &color, char *str);
	void print3dl(CVector &pos, CColor &color, char *str);
	void destroy();
	char * name;
	bool load(char *file, char *name, int height, int style, float extrusion = 0.0f);
	CTextFont();
	virtual ~CTextFont();

protected:
	int height;
	int cwidths[256];
	GLYPHMETRICSFLOAT gmf[256];
	GLuint base_2d, base_3d_polys, base_3d_lines;
	char * file;
	HFONT handle;
};

#endif // !defined(AFX_FONT_H__7C229EAA_5EA4_460D_91D4_63ACF314DBCF__INCLUDED_)
