// Demo.cpp: implementation of the CDemo class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <windows.h>
#include "Demo.h"
#include <math.h>
#include "timer.h"
#include "system.h"

#include <gl\gl.h>
#include <gl\glu.h>
#include <gl\glaux.h>

#include <stdio.h>

#define NUM_X	20
#define NUM_Y	20

#define SIZE_POLY	1
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDemo::CDemo() : CxDLApp()
{
	vp = new CViewport("kk fast");
}

CDemo::~CDemo()
{
	delete vp;
}

void CDemo::start()
{
	p = new poly[NUM_X * NUM_Y];
	int i = 0;
	for (int y = 0; y < NUM_Y; y++) {
		for (int x = 0; x < NUM_X; x++) {
			p[i].a.x = (float)x * SIZE_POLY;
			p[i].a.y = (float)y * SIZE_POLY;
			p[i].a.z = (float)0;
			p[i].b.x = (float)(x + 1) * SIZE_POLY;
			p[i].b.y = (float)y * SIZE_POLY;
			p[i].b.z = (float)0;
			p[i].c.x = (float)x * SIZE_POLY;
			p[i].c.y = (float)(y + 1) * SIZE_POLY;
			p[i].c.z = (float)0;
			p[i].d.x = (float)(x + 1) * SIZE_POLY;
			p[i].d.y = (float)(y + 1) * SIZE_POLY;
			p[i].d.z = (float)0;
			i ++;
		}
	}
	font.load(NULL, "Arial", 48, FONT_BOLD);
	timer.reset();
}

void CDemo::stop()
{
}

//#include "../vertex.h"
void CDemo::frame()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);
//	glEnable(GL_BLEND);
//	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);

	cam.active = true;
	cam.setViewport(vp);
	cam.setPosition(CVector(10, 10, 10));
	cam.setTarget(CVector(15,15,0));
	static double t = 0;
	t += timer.getElapsedTime();
//	cam.refresh();
	glBegin(GL_TRIANGLES);
	glColor4f(0.2f, 0.3f, 0.5f, 0.5f);
	int i = 0;
	for (int y = 0; y < NUM_Y; y++) {
		for (int x = 0; x < NUM_X; x++) {
			glColor3f(0.2f, 0.3f  * (float)sin(t), 0.5f * x / NUM_X);
			glVertex3f(p[i].a.x, p[i].a.y, p[i].a.z + (float)sin(y * t));
			glVertex3f(p[i].b.x, p[i].b.y, p[i].b.z + (float)cos(y * t));
			glVertex3f(p[i].c.x, p[i].c.y, p[i].c.z + (float)sin(x * t));
			glVertex3f(p[i].c.x, p[i].c.y, p[i].c.z + (float)sin(x * t));
			glVertex3f(p[i].d.x, p[i].d.y, p[i].d.z + (float)cos(y * t));
			glVertex3f(p[i].a.x, p[i].a.y, p[i].a.z + (float)sin(y * t));
			i ++;
		}
	}
	glEnd();

	if (t < 2) font.print2d(CVector(-0.3f, 0), CColor(1, 1, 1, 1), "ropa puta!");
	else if (t < 4) font.print2d(CVector(-0.3f, 0), CColor(1, 1, 1, 1), "puta ropa");
	else if (t < 6) font.print2d(CVector(-0.3f, 0), CColor(1, 1, 1, 1), "como me gusta...");
	else if (t < 8) font.print2d(CVector(-0.3f, 0), CColor(1, 1, 1, 1), "pasar la mopa");
	else if (t < 10) font.print2d(CVector(-0.3f, 0), CColor(1, 1, 1, 1), "Esta fast");
	else if (t < 12) font.print2d(CVector(-0.3f, 0), CColor(1, 1, 1, 1), "no puedo");
	else if (t < 14) font.print2d(CVector(-0.3f, 0), CColor(1, 1, 1, 1), "cuando salga");
	else if (t < 16) font.print2d(CVector(-0.3f, 0), CColor(1, 1, 1, 1), "me pillo un pedo");
	else if (t < 18) font.print2d(CVector(-0.3f, 0), CColor(1, 1, 1, 1), "chunda, chunda");
	else if (t < 20) font.print2d(CVector(-0.3f, 0), CColor(1, 1, 1, 1), "chumba chum!");
	else if (t < 22) font.print2d(CVector(-0.3f, 0), CColor(1, 1, 1, 1), "pedooooo");
	else if (t < 24) font.print2d(CVector(-0.3f, 0), CColor(1, 1, 1, 1), "patachum!!");
	else if (t < 26) t = 0;
}

bool CDemo::load(int status)
{
	CSystem::vp = vp;
	vp->set(640, 480, 16, 8, 0, true);

	return true;
}

void CDemo::unload()
{

}



