// Color.h: interface for the CColor class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_COLOR_H__57709E37_80AD_4346_81EC_20B47B3A75BD__INCLUDED_)
#define AFX_COLOR_H__57709E37_80AD_4346_81EC_20B47B3A75BD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CColor
{
public:
	CColor(float r, float g, float b, float a);
	typedef struct {
		float r;
		float g;
		float b;
		float a;
	} TColorComponents;

	union UColorComponents {
		TColorComponents	c;
		float				ca[4];
	};

	bool inline operator !=(CColor &c);
	bool inline operator == (CColor &c);
	void operator = (CColor &c);
	CColor & operator * (float f);
	CColor & operator + (CColor &c);
	void operator += (CColor &c); 
	void operator -= (CColor &c); 
	UColorComponents	rgba;
	CColor();
	virtual ~CColor();

};

#endif // !defined(AFX_COLOR_H__57709E37_80AD_4346_81EC_20B47B3A75BD__INCLUDED_)
