animate:
    call enable_planes

animate_loop:
    ld hl,demo_exec_ram+3                     ;pointer to animation data
    dec (hl)                        ;decrease total counter
    ret z                           ;exit when counter reaches 0
   
    inc hl                          ;make hl point to number of objects
    ld b,(hl)                       ;get number of objects
    
    inc hl                          ;now hl points to first object
animate_objects_loop:
    push bc
    push hl                         ;save pointer and counter
    call handle_object              ;handle the object
    pop hl                          ;restore pointer and counter                          
    pop bc    
    inc hl
    inc hl                          ;make hl point to next object
    djnz animate_objects_loop       ;loop

    
    ld a,(hl)                       ;then get pause value

    call draw_screen                ;draw from buffer to screen
    call clear_buffer               ;then clear the buffer

    call pause                      ;take a break (a isn't modified whileupdating screen)
    
    jp animate_loop                 ;loop until end reached
    
    

handle_object:
    ld bc,0                         ;starting coords
    
handle_object_group:
    call _ldhlind                   ;hl points to object
    ld a,(hl)                       ;get identifyer
    inc hl                          ;hl pointing to coords
    
    push af                         ;save identifyer
    
;get steps
    call handle_counter             ;get the right entry
    push de
    call add_hl_2a                  ;now hl points to current step
    
    ld a,(hl)                       ;read x
    add a,b                         ;add to previous x
    ld b,a                          ;save to x
    
    inc hl
    ld a,(hl)                       ;read y
    add a,c                         ;add to previous y
    ld c,a                          ;save to y

    pop hl    
    pop af                          ;restore identifyer
    
    or a
    jp z,display_animation          ;display animation if identifyer = 0
    
    dec a
    jp z,handle_group               ;display group if identifyer = 1

;if not 0 or 1, then do nothing
    ret
    

;handle a counter
;handle_counter:
    ld a,(hl)                       ;read max value
    inc hl                          ;actual counter
    inc (hl)                        ;increase counter
    cp (hl)                         ;copmare to max vaule
    ld a,(hl)                       ;get counter
    jp nz,counter_ok    
    ld (hl),0                       ;reset
counter_ok:
    inc hl                          ;byte after counter
    dec a
    
    ld e,(hl)
    inc hl
    ld d,(hl)
    inc hl
    ex de,hl    
    ret                             ;return
    
handle_counter:    
    push hl
    inc hl
    ld e,(hl)
    inc hl
    ld d,(hl)
    inc hl
    ex de,hl
    
    ld a,(hl)                       ;read max value
    ex (sp),hl
    inc (hl)
    cp (hl)
    ld a,(hl)
    jp nz,label
    ld (hl),0
label:
    dec a
    pop hl
    inc hl
    ret
    




;hl pointing to steps
display_animation:
    call handle_counter             ;now a contains frame number
find_sprite_loop:
    cp (hl)                         ;compare to sprite's frame number
    inc hl                          ;make hl point to sprite data
    jp c,display_sprite             ;display sprite if it's the right frame for it
    inc hl                          ;else go to next sprite
    inc hl
    jp find_sprite_loop             ;loop until sprite found

display_sprite:
    call _ldhlind                   ;get pointer to sprite
    push hl
    pop ix                          ;pointer to ix
    ld hl,int_end                   ;for background storage
    call PutSprite
    ret
    

;handle a grounp
handle_group:
    ld d,(hl)                       ;read number of objects in group
handle_group_loop:
    inc hl                          ;make hl point to object
    push de
    push hl
    push bc                         ;save our life! ;)
    call handle_object_group        ;handle the group
    pop bc                          ;restore our destoyed life! ;(
    pop hl
    pop de
    inc hl                          ;next object
    dec d                           ;decrease loop counter
    jp nz,handle_group_loop         ;loop until entire group is fixed
    ret



;*******************************************************
;ZMR - Zoomin' Mob Routine (B/W Version)
;The Clipped PutSprite by Dux Gregis
;Assembly Coder's Zenith    1999
;*******************************************************

;the following addresses contain the clip lines (must be a multiple of 8):

;for PutSprite
;x@setBottomClip    default is 56
;x@setRightClip     default is 120

;for ClearSprite
;x@setBottomClip0   default is 56
;x@setRightClip0    default is 120

;this is so you can adjust the position of your status bar
;the sprite will clip left and top at 0


;Zoomin' Mob Routine (PutSprite)
;Input: bc = x,y; ix = 8x8 sprite location; hl = background storage buffer
;Output: clipped sprite; all registers destroyed

;the sprite is 8 bytes, followed by an 8 byte mask
;the background storage buffer is 8 bytes


PutSprite:
ClearSprite:
 ld a,b                             ;clipping is same as PutSprite
 or a
 jp m,clipLeft0

x@setRightClip0     equ     $+1
 sub 120
 jp p,clipRight0

retClipHorz0:
 ld a,c
 or a
 jp m,clipUp0

x@setBottomClip0    equ     $+1
 sub 56
 jp p,clipDown0

cs:
 call findPixel
 ld (x@bitOffset0),a

x@UpLeft0
 nop
; ld a,$ff

x@clipVert0         equ     $+1
 ld b,8
 ld c,0

csLoop:
 push bc
 ld b,(ix)                          ;sprite
 ld a,$ff                           ;mask
 ld e,a

x@bitOffset0        equ     $+1
 ld d,0
 dec d
 jp m,noShift0
bitShift0:
 srl b                              ;sprite
 rr c
 rra                                ;mask
 dec d
 jp p,bitShift0
 ld e,a
x@clipHorz0         equ     $
 nop
 nop

noShift0:
 cpl
 and (hl)
 or b
 ld (hl),a
 inc hl
 ld a,e
 and (hl)
 or c
 ld (hl),a

 inc ix
 ld bc,15
 add hl,bc
 pop bc
 djnz csLoop

 ld h,b
 ld l,b
 ld (x@clipHorz0),hl
 xor a                              ;ld a,nn
 ld (x@UpLeft0),a
 ld a,$5f                           ;ld e,a
 ld (x@clipHorz0-1),a
 ld a,8
 ld (x@clipVert0),a
 ret

clipUp0:
 add a,8
 ret m
 ret z
 ld c,0
 ld (x@clipVert0),a
 jp cs

clipDown0:
 sub 8
 ret p
 neg
 ld (x@clipVert0),a
 jp cs

clipLeft0:
 cp -8
 ret c
 ret z
 res 7,a
 ld b,a
 dec c
 ld hl,$47af                        ;<ld b,a>, <xor a> (clear A, clear B)
 ld (x@clipHorz0),hl
 jp p,retClipHorz0
 inc c
 and 7
 ld b,a
 ld a,$2b                           ;<dec hl>
 ld (x@UpLeft0),a
 jp retClipHorz0

clipRight0:
 sub 8
 ret p
 ld hl,$0e5a                        ;<ld e,d>, <ld c,0> (set E, clear C)
 ld (x@clipHorz0-1),hl              ;little endian ;-)
 jp retClipHorz0


findPixel:
 ld a,c
 add a,a
 add a,a
 ld l,a
 ld h,$fc >>2
 ld a,b
 rra
 add hl,hl
 rra
 add hl,hl
 rra
 add a,l
 ld l,a
 ld a,b
 and 7
 ret


.end