//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cOptions.hpp
// Project: Shooting Star
// Author: 
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cOptions_hpp
#define cOptions_hpp
//==============================================================================
// Includes
#include <string>
#include <fstream>
#include <SDL.h>
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================

struct tPlayerKeys
{
	enum Key
	{
		Key_TurnLeft = 0,
		Key_TurnRight,
		Key_WalkForward,
		Key_WalkBackward,
		Key_Fire,
		Key_NextWeapon,
		Key_PreviousWeapon,
		Key_AimMode,
		NumberOfKeys
	};
	SDLKey keys[NumberOfKeys];
};
	
//! Options
class cOptions
{
	// Constructor & Destructor
	private:
		//! Constructor
		cOptions (void);
	public:
		//! Destructor
		~cOptions (void);
	
	// Public methods
	public:
		static cOptions &GetInstance (void)
		{
			static cOptions singleton;
			return singleton;
		};
		
		//! Save options
		void Save (string filename);
		//! Load options
		void Load (string filename);
		
	// Private methods
	private:
		void SaveKeys (ofstream &fout, tPlayerKeys &keys);
		void LoadKeys (ifstream &fin, tPlayerKeys &keys);
		void SaveBool (ofstream &fout, bool value);
		void LoadBool (ifstream &fin, bool &value);
	
	
	// Member variables
	public:
		bool mFullscreen;
		bool mLowRes;	//!< 640x480 mode
		bool mSound;
		bool mMusic;
		bool mFrameSkip;
		bool mDelay;
		tPlayerKeys mPlayer1Keys;	
		tPlayerKeys mPlayer2Keys;
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cOptions_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
