//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cPlayer.hpp
// Project: Shooting Star
// Author: 
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cPlayer_hpp
#define cPlayer_hpp
//==============================================================================
// Includes
#include <string>
#include "cSoldier.hpp"
#include "cAction.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================

//! Player object
class cPlayer : public cSoldier
{
	// Constructor & Destructor
	public:
		//! Constructor
		cPlayer (string animationPrefix);
		//! Destructor
		virtual ~cPlayer (void);
	
	// Public methods
	public:
		void HandleAction (int action);
		virtual void OnLevelChanged (void);
	
		void Render (Uint32 deltaTime);
	
		void SaveWeapons (void);
		void RestoreWeapons (void);

	// Member variables
	private:
		struct tWeaponInfo
		{
			string name;
			int ammo;
			int clips;
		};
		vector<tWeaponInfo> mStoredWeapons;
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cPlayer_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
