//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cParticleSystem.hpp
// Project: Shooting Star
// Author: 
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cParticleSystem_hpp
#define cParticleSystem_hpp
//==============================================================================
// Includes
#include "cRenderable.hpp"
#include "cCollidable.hpp"
#include "cParticleEmitter.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
struct tParticle
{
	bool alive;
	cVector2f position;
	cVector2f velocity;
	Uint32 energy;
	float size;
	float deltaSize;
	float color[4];
	float deltaColor[4];
};
	
//! ParticleSystem
class cParticleSystem : public cRenderable
{
	// Constructor & Destructor
	public:
		//! Constructor
		cParticleSystem (int size=500);
		//! Destructor
		virtual ~cParticleSystem (void);
	
	// Public methods
	public:
		//! Set particle emitter
		void SetEmitter (cParticleEmitter *pEmitter) { mpEmitter = pEmitter; };	
		void SetEmittingPosition (cVector2f position) { mEmittingPosition = position; };
		
		void SetTexture (Uint32 texture) { mTexture = texture; };
		Uint32 GetTexture (void) const { return mTexture; };
		
		void SetBlending (bool value = true) { mBlend = value; };
		void SetSpeed (float speed, float speedVar) { mSpeed = speed; mSpeedVar = speedVar; };
		void SetSize (float startSize, float endSize) 
		{ 
			mStartSize = startSize; 
			mEndSize = endSize;
		};
		void SetEnergy (Uint32 energy, float energyVar) 
		{ 
			mEnergy = energy;
			mEnergyVar = energyVar; 
		};
		void SetStartColor (float r, float g, float b, float a)
		{
			mStartColor[0] = r;
			mStartColor[1] = g;
			mStartColor[2] = b;
			mStartColor[3] = a;
		};
		void SetEndColor (float r, float g, float b, float a)
		{
			mEndColor[0] = r;
			mEndColor[1] = g;
			mEndColor[2] = b;
			mEndColor[3] = a;
		};
		void SetEmitDelay (Uint32 delay) { mEmitDelay = delay; };
		void SetAcceleration (cVector2f acceleration) { mAcceleration = acceleration; };
		
		void SetAngleVariation (float var) { mAngleVar = var; };
		float GetAngleVariation (void) const { return mAngleVar; };
		
		void KillEmptySystem (bool value) { mKillEmptySystem = value; };
	
		//! Update particle system
		virtual void Update (Uint32 deltaTime);
		//! Render particle system
		virtual void Render (Uint32 deltaTime);
		
		void EmitAll (void);
		
		void EmitParticles (int count);
		void EmitParticles (int count, cVector2f position, cVector2f direction);
	
	// Private methods
	private:
		void EmitParticle (Uint32 deltaTime = 0);
		void EmitParticle (Uint32 deltaTime, cVector2f position, cVector2f direction);
		void UpdateParticle (Uint32 deltaTime, tParticle &particle);
		void FindFreeParticle (void);
	
	// Protected methods
	protected:
	  tParticle *GetParticles (void) { return mpParticles; };
	  int GetNumberOfParticles (void) { return mNumberOfParticles; };
	
	// Member variables
	private:
		cParticleEmitter *mpEmitter;
		cVector2f mEmittingPosition;
		tParticle *mpParticles;
		int mNumberOfParticles;
		int mParticleCount;
		int mFreeParticle;
		Uint32 mLastEmit;
		Uint32 mEmitDelay;	
		bool mActive;
		bool mKillEmptySystem;
	
		cVector2f mAcceleration;
			
		float mAngleVar;
		Uint32 mTexture;
		bool mBlend;
		float mSpeed;
		float mSpeedVar;
		float mStartSize;
		float mEndSize;
		Uint32 mEnergy;
		float mEnergyVar;
		float mStartColor[4];
		float mEndColor[4];
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cParticleSystem_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
