;
; Matrix 128
;
; a 128 byte demo by Csabo of LOD 2003
;

	ORG $115C-2	; compiled location doesn't matter
	DW $115C	; $115C = 4444 sounds good

col	= $D0	; byte variables
count	= $D1
count2	= $D2
ptr	= $C0	; word variables
ptrc	= $C2
ptr2	= $C4

	SEI
	;
newpos	LDA $FF02	; random starting position
	STA ptr2
	;
	LDA #$06	; somewhere in $0600 range (allow it to "come in")
	STA ptr2+1
	;
	LDA p_inc+1	; rotate increase (10, 20, 40)
	ASL a		; so 1, 2 or 4 lines come down
	CMP #80
	BNE set_inc
	;
	LDA #10
set_inc	STA p_inc+1
	;
main	INC count	; main counter
	BNE skip	; do this only every 256th time
	;
	LDX col		; increase background color
	CPX #$07	; but stop at 7
	BEQ no_inc2
	;
	INC col
	;
no_inc2	LDA color,x	; set back and border color
	STA $FF15
	STA $FF19
	;
skip	LDA ptr2
	CLC
p_inc	ADC #10		; increase position
	STA ptr2
	BCC no_inc
	;
	INC ptr2+1
	LDX ptr2+1	; out of screen?
	CPX #$0C
	BEQ newpos	; yes, start new one 
no_inc
	;LDA ptr2
	STA ptr
	LDA ptr2+1
	STA ptr+1
	;
	LDX #$06	; draw loop
	;
putloop	LDA ptr
	CLC
	ADC #40		; down one line
	STA ptr
	STA ptrc
	BCC no_inc1
	INC ptr+1
no_inc1	LDA ptr+1
	PHA
	AND #$04	; make sure it's in range
	BNE no_put
	;
	PLA
	ORA #$04
	STA ptrc+1
	;
	LDY #$00
	LDA color,x	; set color
	STA (ptr),y
	;
	LDA $FF00	; random character (no inverse)
	AND #$7F
	STA (ptrc),y
	;
no_put	DEX
	BPL putloop
	;
sync	LDA $FF1D	; sync to frames
	CMP #$CC
	BNE sync
	BEQ main	; always jump
	;	
color	DB $75,$65,$55,$45,$35,$25,$15,$05
