	;
	; *** DIRECT MODE ***
	; 
	; A demo in 128 bytes.
	; Coded by Csabo of LOD in July, 2003
	;
  	ORG 300-2	; start address has to be in the $100-$1FF area
  	DW  300
  
size	= $15	; must be $01 at start (it will be, because of SYS<addr>)
count	= $E0	; any zeropage
chr_ptr	= $C8	; fixed, used by ROM routine
col_ptr	= $EA	; fixed, used by ROM routine
	
	;
	; *** START ***
	;
	SEI		; disable interrupts
	;		; (works without that too, but it's nicer this way)
	;        
	JSR $C56B	; ROM routine: clear screen
	;
	LDX #$0F	; init: mirror half sinus to create a whole wave
init1	LDA sinus,x	;
	STA sinus+16,y	; assume Y is 0
	INY		; y goes up
	DEX		; x goes down
	BPL init1	; copy routine is less than 16 bytes (bytes saved)
	;
	; *** MAIN DEMO LOOP ***
	;
main	LDX #$63	; wait for a rasterline, $63 is also the counter (height)
sync	CPX $FF1D	; there yet?
	BNE sync	; no, keep waiting
	;
	; *** DISPLAY RASTER + WAVE ***
	;
raster	TXA
	ADC count
	AND #$1F	; keep it in $00-$1F range
	TAY
	LDA sinus,Y	; get sinus
	;
	PHA     	; save if for later
	LSR a		; divide by two
	AND #$07	; keep it in $00-$07 range
	STA $FF07	; set wave (this makes it NTSC incompatible)
	;
	PLA		; get it back
flash	STA $0ACC,X	; make the demo title flash
	;		; (the value $0ACC will keep decreasing,
	;  		;  it is chosen so that once the demo title is
	;		;  fully displayed, the colors will start 'crawling in')
	;    		;
	ORA #$0F	; turn on lower 4 bits to force one color ($0F, green)
	STA $FF15	; set back color
	STA $FF19	; set border color
	;
	DEX
	BNE raster	; keep doing it until X=$00
	;
	STX $FF15	; set colors to black
	STX $FF19
	;
	; *** DISPLAY PLASMA + DEMO NAME ***
	;        
	LDX size
	;
	INC count	; increment counter: * the heart of the demo *
	BNE no_inc	; skip if nonzero, so this happens once out of 256
	;
	DEC flash + 1	; make flash area move left (self modifying code)
	;
	CPX #$0C	; stop increase at $0C (12)
	BEQ no_inc
	;
	INC size	; increase size
no_inc	;
yloop	DEX		; pre-decrement to allow zero iterations
	BEQ main
	;
	JSR $D8AA	; get position from X,Y coordinates to $EA, $C8
	;
	LDA $862A,x	; print demo name: DIRECT MODE (from ROM error message)
	AND #$3F	; convert to lowercase
	STA $0EB6,x	; print to screen
	;
	;		; the pointers point to the beginning of the lines
	;		; however, our x loop can only go up to 32
	;		; so to center it, we shift the loop
	;		; from 00-31 to 03-35
	LDY #35		; starting x value
	;
xloop	LDA sinus-4,y	; get x sinus (minus 4 to compensate for shift)
	ADC sinus+9,x	; add y sinus (change 9 for a different effect)
	ADC count	; add the counter    
	AND #$7F	; remove highest bit (no flash)
	STA (col_ptr),y	; print plasma color
	STA (chr_ptr),y	; print plasma char
	;
	DEY
	CPY #$03	; last x value, stops at 4 chars from left side
	BNE xloop
	BEQ yloop	; always jump
	;
	; *** SINUS DATA ***
	;
	; 16 bytes, first half
	; will be copied after itself backwards
	;
	; high 4 bits is raster color
	; low  4 bits is wave * 2
	; whole thing is for plasma
	;
sinus	DB $00,$01,$12,$13, $14,$25,$26,$37
	DB $48,$5A,$5C,$6D, $6E,$7E,$7F,$7F
	;