#include <stdio.h>
#include <string.h>
#include <math.h>

#ifdef WIN32
#include <windows.h>
#endif
#include <GL/gl.h>

#include "main/overlayanimhandler.h"
#include "exception.h"
#include "demolib_prefs.h"
#include "opengl/texture.h"

#if DEMOLIB_MAINLOOP 

OverlayAnimHandler::OverlayAnimHandler(MainLoop *ml, const char *title, const char *elem, Hashtable *attr) :
	Event(ml, title, elem, attr, "num:alpha")
{
	const char *imgbase = attr->get_str("imgbase");
	const char *imgsuffix = attr->get_str("imgsuffix");
	int num = attr->get_int("num");
 
	char filename[256];
        for (int i = 0; i < num; i++) {
                sprintf(filename, "%s%02d%s", imgbase, i, imgsuffix);
                this->tex.add_end(texture::load(filename));
        }
}
OverlayAnimHandler::~OverlayAnimHandler()
{
        for (int i = 0; i < this->tex.num_elems(); i++) {
		texture::free(this->tex[i]);
		this->tex[i] = NULL;
        }
}

void OverlayAnimHandler::start_effect()
{
}

void OverlayAnimHandler::draw_scene(float progress)
{
	int num = (int)(floor(this->get_val("num", progress))) % this->tex.num_elems();
	
	float alpha = this->get_val("alpha", progress);
	if (alpha <= 0.0f) return;

        glMatrixMode(GL_MODELVIEW);
        glPushMatrix();
	glLoadIdentity();

        glMatrixMode(GL_PROJECTION);
        glPushMatrix();
        glLoadIdentity();

	glOrtho(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

        glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_CULL_FACE);
        glEnable(GL_TEXTURE_2D);
        glColor4f(1.0f, 1.0f, 1.0f, alpha);

	this->tex[num]->bind();

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);

        glBegin(GL_QUADS);

        glTexCoord2f(0.0f, 0.0f);
        glVertex3f(0.0f, 0.0f, 0.0f);

        glTexCoord2f(0.0f, 1.0f);
        glVertex3f(0.0f, 1.0f, 0.0f);

        glTexCoord2f(1.0f, 1.0f);
        glVertex3f(1.0f, 1.0f, 0.0f);

        glTexCoord2f(1.0f, 0.0f);
        glVertex3f(1.0f, 0.0f, 0.0f);

        glEnd();

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);

	glPopMatrix();

	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
}

void OverlayAnimHandler::end_effect() {}

#endif
