/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : main()                                                        |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Fonction (main) principale de la demo                      |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : int Argc, char **Argv                                       |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : 0                                                       |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

#include "SDL.h"
#include "SDL_timer.h"
#include "SDL_thread.h"

#include "Outils.h"
#include "Effets.h"
#include <windows.h>

#define FPS 40

//static HSTREAM str;

/*int main( int Argc, char ** Argv )*/
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)

{
  StructEcran_t *l_pt_Ecran = NULL; /* -- Ecran Principale -- */
  StructAudio_t *l_pt_Audio = NULL; /* -- Le canal audio principal -- */

  /* -- Declaration de toutes les images -- */
  StructImage_t *l_pt_BufferNumericDream = NULL;
  StructImage_t *l_pt_BufferPresente = NULL;
  StructImage_t *l_pt_BufferR = NULL;
  StructImage_t *l_pt_BufferU = NULL;
  StructImage_t *l_pt_BufferB = NULL;
  StructImage_t *l_pt_BufferI = NULL;
  StructImage_t *l_pt_BufferS = NULL;
  StructImage_t *l_pt_BufferH = NULL;
  StructImage_t *l_pt_BufferRubbish = NULL;
  StructImage_t *l_pt_BufferRampeTotal = NULL;
  StructImage_t *l_pt_BufferRampeMasque = NULL;
  StructImage_t *l_pt_BufferSupport = NULL;
  StructImage_t *l_pt_BufferWarp = NULL;
  StructImage_t *l_pt_BufferCinema = NULL;
  StructImage_t *l_pt_BufferCercle = NULL;
  StructImage_t *l_pt_Buffer5 = NULL;
  StructImage_t *l_pt_Buffer4 = NULL;
  StructImage_t *l_pt_Buffer3 = NULL;
  StructImage_t *l_pt_Buffer2 = NULL;  
  StructImage_t *l_pt_Buffer1 = NULL;
  StructImage_t *l_pt_Buffer0 = NULL;
  StructImage_t *l_pt_Arc = NULL;
  //StructImage_t *l_pt_Woman = NULL;
  StructImage_t *l_pt_Bulles = NULL;
  StructImage_t *l_pt_SpriteBullesGros = NULL;
  StructImage_t *l_pt_SpriteBullesMoyen = NULL;
  StructImage_t *l_pt_SpriteBullesPetit = NULL;
  StructImage_t *l_pt_Facade = NULL;
  StructImage_t *l_pt_TV = NULL;
  StructImage_t *l_pt_Fond = NULL;
  StructImage_t *l_pt_Coper1 = NULL;
  StructImage_t *l_pt_Coper2 = NULL;
  StructImage_t *l_pt_Coper3 = NULL;
  StructImage_t *l_pt_Coper4 = NULL;
  StructImage_t *l_pt_ScrollText = NULL;
  StructImage_t *l_pt_DiableTV = NULL;
  StructImage_t *l_pt_Tableau1 = NULL;
  StructImage_t *l_pt_Tableau2 = NULL;
  StructImage_t *l_pt_Fin = NULL;
  StructImage_t *l_pt_Code = NULL;
  StructImage_t *l_pt_Gfx = NULL;
  StructImage_t *l_pt_Zic = NULL;
  StructImage_t *l_pt_Taz = NULL;
  StructImage_t *l_pt_Kman = NULL;
  StructImage_t *l_pt_ImgKman = NULL;
  StructImage_t *l_pt_ImgTaz = NULL;
  StructImage_t *l_pt_Vandame01 = NULL;
  StructImage_t *l_pt_Vandame02 = NULL;
  StructImage_t *l_pt_Vandame03 = NULL;
  StructImage_t *l_pt_Vandame04 = NULL;
  StructImage_t *l_pt_Vandame05 = NULL;
  StructImage_t *l_pt_Vandame06 = NULL;
  StructImage_t *l_pt_Vandame07 = NULL;
  StructImage_t *l_pt_Vandame08 = NULL;
  StructImage_t *l_pt_Vandame09 = NULL;
  StructImage_t *l_pt_Vandame10 = NULL;
  StructImage_t *l_pt_Vandame11 = NULL;
  StructImage_t *l_pt_Vandame12 = NULL;
  StructImage_t *l_pt_Vandame13 = NULL;
  StructImage_t *l_pt_Vandame14 = NULL;
  StructImage_t *l_pt_Vandame15 = NULL;
  StructImage_t *l_pt_Vandame16 = NULL;
  StructImage_t *l_pt_Vandame17 = NULL;
  StructImage_t *l_pt_Vandame18 = NULL;
  StructImage_t *l_pt_Vandame19 = NULL;
  StructImage_t *l_pt_Vandame20 = NULL;
  StructImage_t *l_pt_Vandame21 = NULL;
  StructImage_t *l_pt_OldTV = NULL;
  StructImage_t *l_pt_Greets = NULL;
  StructImage_t *l_pt_Piark = NULL;
  StructImage_t *l_pt_Tawny = NULL;
  StructImage_t *l_pt_Truiss = NULL;
  StructImage_t *l_pt_GenSW = NULL;
  StructImage_t *l_pt_FondSW = NULL;
  StructImage_t *l_pt_FadeSW = NULL;

  
  /* -- Declaration de toutes les musiques -- */
  StructAudio_t *l_pt_ZicPrincipale = NULL;

  /* -- Dclaration du retour Timer pour le fermer -- */
  SDL_TimerID	l_sdl_Timer;

  l_pt_Audio = OpenAudio(); /* -- Init de l'audio -- */

  /* -- Initialisation de l'ecran principal -- */
  l_pt_Ecran = OpenScreen( RESO_X, RESO_Y, BPP, TRUE ); 

  /* -- Initalisation du Nombre de StructureImages_t et StructAudio_t allouees -- */
  InitVariablesGlobales();

  /* -- Chargement des images -- */
  l_pt_BufferNumericDream = O_LoadImage( "ND.png", FALSE, 0, 0, 0 );
  l_pt_BufferPresente = O_LoadImage( "Presente.png", FALSE, 0, 0, 0 );
  l_pt_BufferR = O_LoadImage( "R.png", TRUE, 0, 0, 0 );
  l_pt_BufferU = O_LoadImage( "U.png", TRUE, 0, 0, 0 );
  l_pt_BufferB = O_LoadImage( "B.png", TRUE, 0, 0, 0 );
  l_pt_BufferI = O_LoadImage( "I.png", TRUE, 0, 0, 0 );
  l_pt_BufferS = O_LoadImage( "S.png", TRUE, 0, 0, 0 );
  l_pt_BufferH = O_LoadImage( "H.png", TRUE, 0, 0, 0 );
  l_pt_BufferRubbish = O_LoadImage( "Rubbish.png", TRUE, 0, 0, 0 ); /* -- Support avec transparence -- */
  l_pt_BufferRampeTotal = O_LoadImage( "RampeTotal.png", FALSE, 0, 0, 0 );
  l_pt_BufferRampeMasque = O_LoadImage( "RampeMasque.png", FALSE, 0, 0, 0 );
  l_pt_BufferSupport = O_LoadImage( "Support2.png", FALSE, 0, 0, 0 );
  l_pt_BufferWarp = O_LoadImage( "DisparitionTourbillon.png", FALSE, 0, 0, 0 );
  l_pt_BufferCinema = O_LoadImage( "Cinema.png", FALSE, 0, 0, 0 );
  l_pt_BufferCercle = O_LoadImage( "Cercle.png", TRUE, 255, 255, 255 );
  l_pt_Buffer5 = O_LoadImage( "Decompte5.png", TRUE, 255, 255, 255 );
  l_pt_Buffer4 = O_LoadImage( "Decompte4.png", TRUE, 255, 255, 255 );
  l_pt_Buffer3 = O_LoadImage( "Decompte3.png", TRUE, 255, 255, 255 );
  l_pt_Buffer2 = O_LoadImage( "Decompte2.png", TRUE, 255, 255, 255 );
  l_pt_Buffer1 = O_LoadImage( "Decompte1.png", TRUE, 255, 255, 255 );
  l_pt_Buffer0 = O_LoadImage( "Decompte0.png", TRUE, 255, 255, 255 );
  l_pt_Arc = O_LoadImage( "Arc.png", TRUE, 0, 0, 0 );
  //l_pt_Woman = O_LoadImage( "Woman.png", TRUE, 0, 0, 0 );
  l_pt_Bulles = O_LoadImage( "Bulles.png", FALSE, 0, 0, 0 );
  l_pt_SpriteBullesGros = O_LoadImage( "SpriteBullesGros.png", FALSE, 0, 0, 0 );
  l_pt_SpriteBullesMoyen = O_LoadImage( "SpriteBullesMoyen.png", FALSE, 0, 0, 0 );
  l_pt_SpriteBullesPetit = O_LoadImage( "SpriteBullesPetit.png", FALSE, 0, 0, 0 );
  l_pt_Facade = O_LoadImage( "Facade.png", TRUE, 255, 255, 255 );
  l_pt_TV = O_LoadImage( "TV.png", TRUE, 0, 0, 0 );
  l_pt_Fond = O_LoadImage( "Fond.png", FALSE, 0, 0, 0 );
  l_pt_Coper1 = O_LoadImage( "Coper1.png", FALSE, 0, 0, 0 );
  l_pt_Coper2 = O_LoadImage( "Coper2.png", FALSE, 0, 0, 0 );
  l_pt_Coper3 = O_LoadImage( "Coper3.png", FALSE, 0, 0, 0 );
  l_pt_Coper4 = O_LoadImage( "Coper4.png", FALSE, 0, 0, 0 );
  l_pt_ScrollText = O_LoadImage( "ScrollText.png", TRUE, 0, 0, 0 );
  l_pt_DiableTV = O_LoadImage( "DiableTV.png", FALSE, 0, 0, 0 );
  l_pt_Tableau1 = O_LoadImage( "Tableau1.png", FALSE, 0, 0, 0 );
  l_pt_Tableau2 = O_LoadImage( "Tableau2.png", FALSE, 0, 0, 0 );
  l_pt_Fin = O_LoadImage( "Fin.png", TRUE, 255, 255, 255 );
  l_pt_Code = O_LoadImage( "Code.png", TRUE, 0, 0, 0 );
  l_pt_Gfx = O_LoadImage( "Gfx.png", TRUE, 0, 0, 0 );
  l_pt_Zic = O_LoadImage( "Zic.png", TRUE, 0, 0, 0 );
  l_pt_Taz = O_LoadImage( "Taz.png", TRUE, 0, 0, 0 );
  l_pt_Kman = O_LoadImage( "Kman.png", TRUE, 0, 0, 0 );
  l_pt_ImgKman = O_LoadImage( "ImgKman.png", FALSE, 0, 0, 0 );
  l_pt_ImgTaz = O_LoadImage( "ImgTaz.png", FALSE, 0, 0, 0 );
  l_pt_Vandame01 = O_LoadImage( "Vandame01.png", FALSE, 0, 0, 0 );
  l_pt_Vandame02 = O_LoadImage( "Vandame02.png", FALSE, 0, 0, 0 );
  l_pt_Vandame03 = O_LoadImage( "Vandame03.png", FALSE, 0, 0, 0 );
  l_pt_Vandame04 = O_LoadImage( "Vandame04.png", FALSE, 0, 0, 0 );
  l_pt_Vandame05 = O_LoadImage( "Vandame05.png", FALSE, 0, 0, 0 );
  l_pt_Vandame06 = O_LoadImage( "Vandame06.png", FALSE, 0, 0, 0 );
  l_pt_Vandame07 = O_LoadImage( "Vandame07.png", FALSE, 0, 0, 0 );
  l_pt_Vandame08 = O_LoadImage( "Vandame08.png", FALSE, 0, 0, 0 );
  l_pt_Vandame09 = O_LoadImage( "Vandame09.png", FALSE, 0, 0, 0 );
  l_pt_Vandame10 = O_LoadImage( "Vandame10.png", FALSE, 0, 0, 0 );
  l_pt_Vandame11 = O_LoadImage( "Vandame11.png", FALSE, 0, 0, 0 );
  l_pt_Vandame12 = O_LoadImage( "Vandame12.png", FALSE, 0, 0, 0 );
  l_pt_Vandame13 = O_LoadImage( "Vandame13.png", FALSE, 0, 0, 0 );
  l_pt_Vandame14 = O_LoadImage( "Vandame14.png", FALSE, 0, 0, 0 );
  l_pt_Vandame15 = O_LoadImage( "Vandame15.png", FALSE, 0, 0, 0 );
  l_pt_Vandame16 = O_LoadImage( "Vandame16.png", FALSE, 0, 0, 0 );
  l_pt_Vandame17 = O_LoadImage( "Vandame17.png", FALSE, 0, 0, 0 );
  l_pt_Vandame18 = O_LoadImage( "Vandame18.png", FALSE, 0, 0, 0 );
  l_pt_Vandame19 = O_LoadImage( "Vandame19.png", FALSE, 0, 0, 0 );
  l_pt_Vandame20 = O_LoadImage( "Vandame20.png", FALSE, 0, 0, 0 );
  l_pt_Vandame21 = O_LoadImage( "Vandame21.png", FALSE, 0, 0, 0 );
  l_pt_OldTV = O_LoadImage( "OldTV.png", TRUE, 0, 0, 0 );
  l_pt_Greets = O_LoadImage( "Greets.png", TRUE, 0, 0, 0 );
  l_pt_Piark = O_LoadImage( "Piark.png", TRUE, 0, 0, 0 );
  l_pt_Tawny = O_LoadImage( "Tawny.png", TRUE, 0, 0, 0 );
  l_pt_Truiss = O_LoadImage( "Truiss.png", TRUE, 0, 0, 0 );
  l_pt_GenSW = O_LoadImage( "GenSW.png", TRUE, 0, 0, 0 );
  l_pt_FondSW = O_LoadImage( "FondSW.png", FALSE, 0, 0, 0 );
  l_pt_FadeSW = O_LoadImage( "degrade.png", FALSE, 0, 0, 0 );
  
  
  /* -- Chargement des musiques -- */
  l_pt_ZicPrincipale = LoadZic( l_pt_Audio, "rubbish.wav" );  

  /* -- Lance la lecture de la musique -- */
  PlayAudio( l_pt_ZicPrincipale );
  g_ul_CompteurSound = 0;
  //l_sdl_Timer = SDL_AddTimer( 500, ( unsigned int (__cdecl *)(unsigned int,void *) )SoundSync, NULL );
  l_sdl_Timer = SDL_SetTimer( 500, SoundSync );
 
  /* -- ======================================================================= -- */
  /* -- ======                                                           ====== -- */
  /* -- ======                Le decompte style cinema                   ====== -- */
  /* -- ======                                                           ====== -- */
  /* -- ======================================================================= -- */

  {
    SDL_Rect l_sdl_CoordsDecompte, l_sdl_CoordsCercle, l_sdl_CoordsBande;
    unsigned long l_ul_TimeBegin = 0, l_ul_TimeEnd = 0;
    
    l_ul_TimeBegin = SDL_GetTicks(); /* -- Init le compteur de frames -- */
    
    /* -- Les numeros du decompte -- */
    l_sdl_CoordsDecompte.x = ( RESO_X - l_pt_Buffer5->Largeur ) /2;
    l_sdl_CoordsDecompte.y = ( RESO_Y - l_pt_Buffer5->Hauteur ) /2;
    l_sdl_CoordsDecompte.w = l_pt_Buffer5->Largeur;
    l_sdl_CoordsDecompte.h = l_pt_Buffer5->Hauteur;
    
    /* -- Le cercle -- */
    l_sdl_CoordsCercle.w = l_pt_BufferCercle->Largeur;
    l_sdl_CoordsCercle.h = l_pt_BufferCercle->Hauteur;
    
    /* -- La bande -- */
    l_sdl_CoordsBande.w = 2; /* -- 2 pixels de large -- */
    l_sdl_CoordsBande.h = RESO_Y; /* -- Hauteur de la bande -- */
    l_sdl_CoordsBande.y = 0;
    
    l_ul_TimeEnd = SDL_GetTicks(); /* -- Verrifie les x secondes d'attente -- */
    
    while( ( l_ul_TimeEnd - l_ul_TimeBegin ) < 6000 )
      {
        if( WaitKey() == TRUE )
          break;
        /* -- Init aleatoire des positions X et Y -- */
        l_sdl_CoordsCercle.x = (unsigned short ) ( ( float ) ( RESO_X - l_pt_BufferCercle->Largeur ) * rand() / ( RAND_MAX + 1.0 ) ); /* -- Random de 1 a RESO_X - LargeurSprite -- */
        l_sdl_CoordsCercle.y = (unsigned short ) ( ( float ) ( RESO_Y - l_pt_BufferCercle->Hauteur ) * rand() / ( RAND_MAX + 1.0 ) ); /* -- Random de 1 a RESO_Y - HauteurSprite -- */
        
        l_sdl_CoordsBande.x = (unsigned short ) ( ( float ) ( RESO_X - 2 ) * rand() / ( RAND_MAX + 1.0 ) ); /* -- Random de 1 a RESO_X - 2 -- */
        
        SDL_BlitSurface( l_pt_BufferCinema->DonneesImage, &l_pt_BufferCinema->Coords,  l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
        
        if( ( l_ul_TimeEnd - l_ul_TimeBegin >= 0 ) && ( l_ul_TimeEnd - l_ul_TimeBegin < 1000 ) )
          SDL_BlitSurface( l_pt_Buffer5->DonneesImage, &l_pt_Buffer5->Coords,  l_pt_Ecran->DonneesImage, &l_sdl_CoordsDecompte );
        if( ( l_ul_TimeEnd - l_ul_TimeBegin > 1000 ) && ( l_ul_TimeEnd - l_ul_TimeBegin < 2000 ) )
          SDL_BlitSurface( l_pt_Buffer4->DonneesImage, &l_pt_Buffer4->Coords,  l_pt_Ecran->DonneesImage, &l_sdl_CoordsDecompte );
        if( ( l_ul_TimeEnd - l_ul_TimeBegin > 2000 ) && ( l_ul_TimeEnd - l_ul_TimeBegin < 3000 ) )
          SDL_BlitSurface( l_pt_Buffer3->DonneesImage, &l_pt_Buffer3->Coords,  l_pt_Ecran->DonneesImage, &l_sdl_CoordsDecompte );
        if( ( l_ul_TimeEnd - l_ul_TimeBegin > 3000 ) && ( l_ul_TimeEnd - l_ul_TimeBegin < 4000 ) )
          SDL_BlitSurface( l_pt_Buffer2->DonneesImage, &l_pt_Buffer2->Coords,  l_pt_Ecran->DonneesImage, &l_sdl_CoordsDecompte );
        if( ( l_ul_TimeEnd - l_ul_TimeBegin > 4000 ) && ( l_ul_TimeEnd - l_ul_TimeBegin < 5000 ) )
          SDL_BlitSurface( l_pt_Buffer1->DonneesImage, &l_pt_Buffer1->Coords,  l_pt_Ecran->DonneesImage, &l_sdl_CoordsDecompte );
        if( ( l_ul_TimeEnd - l_ul_TimeBegin > 5000 ) && ( l_ul_TimeEnd - l_ul_TimeBegin < 6000 ) )
          SDL_BlitSurface( l_pt_Buffer0->DonneesImage, &l_pt_Buffer0->Coords,  l_pt_Ecran->DonneesImage, &l_sdl_CoordsDecompte );

        SDL_BlitSurface( l_pt_BufferCercle->DonneesImage, &l_pt_BufferCercle->Coords,  l_pt_Ecran->DonneesImage, &l_sdl_CoordsCercle );

        SDL_FillRect( l_pt_Ecran->DonneesImage, &l_sdl_CoordsBande, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 70, 70, 70 ) ); /* -- Bande noire verticale -- */

        SDL_Flip( l_pt_Ecran->DonneesImage );
        
        MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, 15, 0, 6 );
        SDL_Flip( l_pt_Ecran->DonneesImage );
        WaitDelayAndWaitKey( 7 );
      
        l_ul_TimeEnd = SDL_GetTicks(); /* -- Verrifie les x secondes d'attente -- */
      }
  }

  /* -- ======================================================================= -- */
  /* -- ======                                                           ====== -- */
  /* -- ======                       Le Zoom ND                          ====== -- */
  /* -- ======                                                           ====== -- */
  /* -- ======================================================================= -- */
  g_ul_CompteurSound = 0;
  
  SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, 0); /* -- Efface l'ecran -- */

  ZoomOver( l_pt_BufferNumericDream, ( StructImage_t * ) l_pt_Ecran, 2 );
  while( g_ul_CompteurSound < 12 ); /* -- 6 secondes -- */
  WaitDelayAndWaitKey( 2000 );

  g_ul_CompteurSound = 0;
  FadeOut( ( StructImage_t * ) l_pt_Ecran, 1.2 );
  while( g_ul_CompteurSound < 4 ); /* -- 2 secondes -- */

  SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, 0); 
  SDL_Flip( l_pt_Ecran->DonneesImage );

  //while( g_ul_CompteurSound < 5 )

  /* -- ======================================================================= -- */
  /* -- ======                                                           ====== -- */
  /* -- ======                     Le scroll PRESENTE                    ====== -- */
  /* -- ======                                                           ====== -- */
  /* -- ======================================================================= -- */
  g_ul_CompteurSound = 0;

  MoveToH( l_pt_BufferPresente, ( StructImage_t * ) l_pt_Ecran, RESO_X, ( ( RESO_X - l_pt_BufferPresente->Largeur ) /2 ) - 10, ( RESO_Y - l_pt_BufferPresente->Hauteur ) /2, 4 );
  SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, 0); /* -- Efface l'ecran -- */

  MoveToH( l_pt_BufferPresente, ( StructImage_t * ) l_pt_Ecran, ( ( RESO_X - l_pt_BufferPresente->Largeur ) /2 ) - 10, ( ( RESO_X - l_pt_BufferPresente->Largeur ) /2 ) + 10, ( RESO_Y - l_pt_BufferPresente->Hauteur ) /2, 6);
  SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, 0); /* -- Efface l'ecran -- */

  MoveToH( l_pt_BufferPresente, ( StructImage_t * ) l_pt_Ecran, ( ( RESO_X - l_pt_BufferPresente->Largeur ) /2 ) + 10, ( ( RESO_X - l_pt_BufferPresente->Largeur ) /2 ), ( RESO_Y - l_pt_BufferPresente->Hauteur ) /2, 6 );

  while( g_ul_CompteurSound < 2 ); /* -- 1 secondes -- */

  WaitDelayAndWaitKey( 2000 ); /* -- 3 Secondes -- */  

  g_ul_CompteurSound = 0;
  FadeOut( ( StructImage_t * ) l_pt_Ecran, 1.2 );
  while( g_ul_CompteurSound < 2 ); /* -- 1 secondes -- */

  /* -- ======================================================================= -- */
  /* -- ======                                                           ====== -- */
  /* -- ======                  Le scroll de la rampe                    ====== -- */
  /* -- ======                                                           ====== -- */
  /* -- ======================================================================= -- */
  
  /* -- Scroll 'RampeTotal' -- */
  g_ul_CompteurSound = 0;
  MoveToV( l_pt_BufferRampeTotal, ( StructImage_t * ) l_pt_Ecran, -RESO_Y, 3, 0, 3 );
  while( g_ul_CompteurSound < 4 ); /* -- 2 secondes -- */

  WaitDelayAndWaitKey( 2000 ); /* -- 2 Secondes -- */

  /* -- ======================================================================= -- */
  /* -- ======                                                           ====== -- */
  /* -- ======                Le scroll texte sur relief                 ====== -- */
  /* -- ======                                                           ====== -- */
  /* -- ======================================================================= -- */

  /* -- Scroll texte -- */
  g_ul_CompteurSound = 0;
  SDL_BlitSurface( l_pt_BufferRampeTotal->DonneesImage, &l_pt_BufferRampeTotal->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );

  ScrollTexteSurRelief( l_pt_BufferRubbish, ( StructImage_t * ) l_pt_Ecran, l_pt_BufferRampeMasque, 3 );
  while( g_ul_CompteurSound < 6); /* -- 3 secondes -- */

  /* -- ======================================================================= -- */
  /* -- ======                                                           ====== -- */
  /* -- ======          Le scroll des lettres sur le support             ====== -- */
  /* -- ======                                                           ====== -- */
  /* -- ======================================================================= -- */

  g_ul_CompteurSound = 0;

  SDL_BlitSurface( l_pt_BufferSupport->DonneesImage, &l_pt_BufferSupport->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );

  {
    unsigned short l_us_PositionX = ( ( RESO_X - l_pt_BufferRubbish->Largeur ) /2 ) - 5; /* -- le -5 est pour compenser l'erreur de centrage -- */
    unsigned short l_us_PasX = l_pt_BufferR->Largeur, l_us_Tremblement = 2;
    /* -- MoveTo sur Support du 'R' -- */
    MoveToV( l_pt_BufferR, ( StructImage_t * ) l_pt_Ecran, 0 - l_pt_BufferR->Hauteur, 235 - l_pt_BufferR->Hauteur, l_us_PositionX, 2 );
    l_us_PositionX += l_us_PasX;
    MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, 5, 0, l_us_Tremblement );
    MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, -5, 0, l_us_Tremblement );

    WaitDelayAndWaitKey( 300 );

    /* -- MoveTo sur Support du 'U' -- */
    MoveToV( l_pt_BufferU, ( StructImage_t * ) l_pt_Ecran, 0 - l_pt_BufferU->Hauteur, 235 - l_pt_BufferU->Hauteur, l_us_PositionX, 2 );
    l_us_PositionX += l_us_PasX;
    MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, 5, 0, l_us_Tremblement );
    MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, -5, 0, l_us_Tremblement );

    WaitDelayAndWaitKey( 300 );

    /* -- MoveTo sur Support du 'B' -- */
    MoveToV( l_pt_BufferB, ( StructImage_t * ) l_pt_Ecran, 0 - l_pt_BufferB->Hauteur, 235 - l_pt_BufferB->Hauteur, l_us_PositionX, 2 );
    l_us_PositionX += l_us_PasX;
    MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, 5, 0, l_us_Tremblement );
    MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, -5, 0, l_us_Tremblement );

    WaitDelayAndWaitKey( 300 );

    /* -- MoveTo sur Support du 'B' -- */
    MoveToV( l_pt_BufferB, ( StructImage_t * ) l_pt_Ecran, 0 - l_pt_BufferB->Hauteur, 235 - l_pt_BufferB->Hauteur, l_us_PositionX, 2 );
    l_us_PositionX += l_us_PasX;
    MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, 5, 0, l_us_Tremblement );
    MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, -5, 0, l_us_Tremblement );

    WaitDelayAndWaitKey( 300 );

    /* -- MoveTo sur Support du 'I' -- */
    MoveToV( l_pt_BufferI, ( StructImage_t * ) l_pt_Ecran, 0 - l_pt_BufferI->Hauteur, 235 - l_pt_BufferI->Hauteur, l_us_PositionX, 2 );
    l_us_PositionX += l_us_PasX;
    MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, 5, 0, l_us_Tremblement );
    MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, -5, 0, l_us_Tremblement );

    WaitDelayAndWaitKey( 300 );

    /* -- MoveTo sur Support du 'S' -- */
    MoveToV( l_pt_BufferS, ( StructImage_t * ) l_pt_Ecran, 0 - l_pt_BufferS->Hauteur, 235 - l_pt_BufferS->Hauteur, l_us_PositionX, 2 );
    l_us_PositionX += l_us_PasX;
    MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, 5, 0, l_us_Tremblement );
    MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, -5, 0, l_us_Tremblement );

    WaitDelayAndWaitKey( 300 );

    /* -- MoveTo sur Support du 'H' -- */
    MoveToV( l_pt_BufferH, ( StructImage_t * ) l_pt_Ecran, 0 - l_pt_BufferH->Hauteur, 235 - l_pt_BufferH->Hauteur, l_us_PositionX, 2 );
    MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, 5, 0, l_us_Tremblement );
    MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, -5, 0, l_us_Tremblement );
  }
  while( g_ul_CompteurSound < 16); /* -- 8 secondes -- */

  WaitDelayAndWaitKey( 2000 );


  /* -- ======================================================================= -- */
  /* -- ======                                                           ====== -- */
  /* -- ======                        Les Flashs                         ====== -- */
  /* -- ======                                                           ====== -- */
  /* -- ======================================================================= -- */

  Flash( ( StructImage_t * ) l_pt_Ecran, 6, 100, 255, 255, 255 );

  /* -- ======================================================================= -- */
  /* -- ======                                                           ====== -- */
  /* -- ======                    L'effet d'ecoulement                   ====== -- */
  /* -- ======                                                           ====== -- */
  /* -- ======================================================================= -- */
  g_ul_CompteurSound = 0;

  Ecoule( ( StructImage_t * ) l_pt_Ecran, l_pt_Bulles, 5 );
  while( g_ul_CompteurSound < 2); /* -- 8 secondes -- */
  WaitDelayAndWaitKey( 1000 );

  /* -- ======================================================================= -- */
  /* -- ======                                                           ====== -- */
  /* -- ======                   Tremblements + Bulles                   ====== -- */
  /* -- ======                                                           ====== -- */
  /* -- ======================================================================= -- */

  {
    unsigned long l_ul_TimeBegin = 0, l_ul_TimeEnd = 0;
    short l_s_CompteurPetit1 = 380, l_s_CompteurPetit2 = 270;
    short l_s_CompteurMoyen1 = 95, l_s_CompteurMoyen2 = 30;
    short l_s_CompteurGros1= 200, l_s_CompteurGros2 = 210;
    float l_f_PasWater = 0.0;
    unsigned char l_uc_Pas = 6;
    g_ul_CompteurSound = 0;
    
    SDL_BlitSurface( l_pt_Bulles->DonneesImage, &l_pt_Bulles->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    
    l_ul_TimeBegin = SDL_GetTicks(); /* -- Init le compteur de frames -- */
    l_ul_TimeEnd = SDL_GetTicks(); /* -- Init le compteur de frames -- */
    
    while( ( l_ul_TimeEnd - l_ul_TimeBegin ) < 1000 )
      {
        MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, 10, 0, 5 );
        MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, -10, 0, 5 );
        l_ul_TimeEnd = SDL_GetTicks(); /* -- Init le compteur de frames -- */
        WaitDelayAndWaitKey( 10 );
      }
    WaitDelayAndWaitKey( 2000 );
    
    l_ul_TimeBegin = SDL_GetTicks(); /* -- Init le compteur de frames -- */
    l_ul_TimeEnd = SDL_GetTicks(); /* -- Init le compteur de frames -- */
    
    while( ( l_ul_TimeEnd - l_ul_TimeBegin ) < 3500 )
      {
        MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, 10, 0, 5 );
        MoveToV( ( StructImage_t * ) l_pt_Ecran, ( StructImage_t * ) l_pt_Ecran, 0, -10, 0, 5 );
        l_ul_TimeEnd = SDL_GetTicks(); /* -- Init le compteur de frames -- */
        WaitDelayAndWaitKey( 10 );
      }
    
    l_ul_TimeBegin = SDL_GetTicks(); /* -- Init le compteur de frames -- */
    l_ul_TimeEnd = SDL_GetTicks(); /* -- Init le compteur de frames -- */
    

    while( ( l_ul_TimeEnd - l_ul_TimeBegin ) < 10000 )
      {
        /* -- Copie le fond a bulles -- */
        SDL_BlitSurface( l_pt_Bulles->DonneesImage, &l_pt_Bulles->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
        

        /* -- Annimation des bulles vers le haut -- */
        AfficheBulle( 5 + ( sin( l_f_PasWater ) *10 ), l_s_CompteurPetit1, l_pt_SpriteBullesPetit, ( StructImage_t * ) l_pt_Ecran );
        AfficheBulle( 570 + ( sin( l_f_PasWater ) *10 ), l_s_CompteurPetit2, l_pt_SpriteBullesPetit, ( StructImage_t * ) l_pt_Ecran );
        
        AfficheBulle( 340 + ( sin( l_f_PasWater ) *10 ), l_s_CompteurMoyen1, l_pt_SpriteBullesMoyen, ( StructImage_t * ) l_pt_Ecran );
        AfficheBulle( 50 + ( sin( l_f_PasWater ) *10 ), l_s_CompteurMoyen2, l_pt_SpriteBullesMoyen, ( StructImage_t * ) l_pt_Ecran );
        
        AfficheBulle( 110 + ( sin( l_f_PasWater ) *10 ), l_s_CompteurGros1, l_pt_SpriteBullesGros, ( StructImage_t * ) l_pt_Ecran );
        AfficheBulle( 355 + ( sin( l_f_PasWater ) *10 ), l_s_CompteurGros2, l_pt_SpriteBullesGros, ( StructImage_t * ) l_pt_Ecran );
        
        SDL_Flip( l_pt_Ecran->DonneesImage );
        
        l_s_CompteurPetit1 -= l_uc_Pas;
        l_s_CompteurPetit2 -= l_uc_Pas;
        l_s_CompteurMoyen1 -= l_uc_Pas;
        l_s_CompteurMoyen2 -= l_uc_Pas;
        l_s_CompteurGros1 -= l_uc_Pas;
        l_s_CompteurGros2 -= l_uc_Pas;
        
        if( l_s_CompteurPetit1 < -l_pt_SpriteBullesPetit->Hauteur )
          l_s_CompteurPetit1 = 380;
        if( l_s_CompteurPetit2 < -l_pt_SpriteBullesPetit->Hauteur )
          l_s_CompteurPetit2 = 270;
        
        if( l_s_CompteurMoyen1 < -l_pt_SpriteBullesMoyen->Hauteur )
          l_s_CompteurMoyen1 = 95;
        if( l_s_CompteurMoyen2 < -l_pt_SpriteBullesMoyen->Hauteur )
          l_s_CompteurMoyen2 = 30;
        
        if( l_s_CompteurGros1 < -l_pt_SpriteBullesGros->Hauteur )
          l_s_CompteurGros1 = 200;
        if( l_s_CompteurGros2 < -l_pt_SpriteBullesGros->Hauteur )
          l_s_CompteurGros2 = 210;
        
        l_f_PasWater += .8;
        l_ul_TimeEnd = SDL_GetTicks(); /* -- Init le compteur de frames -- */
        if( WaitKey() == TRUE )
          break;
      }
    while( g_ul_CompteurSound < 34); /* -- 17 secondes -- */

    WaitDelayAndWaitKey( 1000 );
  }
  
  /* -- ======================================================================= -- */
  /* -- ======                                                           ====== -- */
  /* -- ======                    L'apparence WARP                       ====== -- */
  /* -- ======                                                           ====== -- */
  /* -- ======================================================================= -- */

  WarpApparence( l_pt_BufferWarp, ( StructImage_t * ) l_pt_Ecran, l_pt_Fond, 5 );
  WaitDelayAndWaitKey( 1000 );
  
  /* -- ======================================================================= -- */
  /* -- ======                                                           ====== -- */
  /* -- ======             Les 4 teles et les 4 effets                   ====== -- */
  /* -- ======                                                           ====== -- */
  /* -- ======================================================================= -- */
  
  {
    unsigned long l_ul_TimeBegin = 0, l_ul_TimeEnd = 0;
    BOOL l_b_FlagCoper = TRUE;
    char l_c_PasCoperGeneral = 2, l_c_PasOpacite = 3;
    char l_c_PasCoper1 = l_c_PasCoperGeneral, l_c_PasCoper2 = 0, l_c_PasCoper3 = 0, l_c_PasCoper4 = 0;
    unsigned char l_uc_Opacite = 0;
    SDL_Rect l_sdl_Coords, l_sdl_CoordsTmp; /* -- Coord de l'interieur des teles : 21, 17, 250, 177 -- */
    SDL_Rect l_sdl_CoordsCoper1, l_sdl_CoordsCoper2, l_sdl_CoordsCoper3, l_sdl_CoordsCoper4;
    StructImage_t *l_t_BufferTV1 = NULL, *l_t_BufferTV2 = NULL, *l_t_BufferTV3 = NULL, *l_t_BufferTV4 = NULL;
    float l_f_PasScrollText = 0.0, l_f_PasWobbler = 0.0;
    
    g_ul_CompteurSound = 0;
    l_t_BufferTV1 = ( StructImage_t * ) malloc( sizeof( StructImage_t ) );
    if( l_t_BufferTV1 == NULL )
      return 0;
    l_t_BufferTV2 = ( StructImage_t * ) malloc( sizeof( StructImage_t ) );
    if( l_t_BufferTV2 == NULL )
      return 0;
    l_t_BufferTV3 = ( StructImage_t * ) malloc( sizeof( StructImage_t ) );
    if( l_t_BufferTV3 == NULL )
      return 0;
    l_t_BufferTV4 = ( StructImage_t * ) malloc( sizeof( StructImage_t ) );
    if( l_t_BufferTV4 == NULL )
      return 0;
    
    l_t_BufferTV1->Largeur = 250;
    l_t_BufferTV1->Hauteur = 177;
    l_t_BufferTV1->Coords.x = l_t_BufferTV1->Coords.y = 0;
    l_t_BufferTV1->Coords.w = l_t_BufferTV1->Largeur;
    l_t_BufferTV1->Coords.h = l_t_BufferTV1->Hauteur;
    
    l_t_BufferTV2->Largeur = 250;
    l_t_BufferTV2->Hauteur = 177;
    l_t_BufferTV2->Coords.x = l_t_BufferTV2->Coords.y = 0;
    l_t_BufferTV2->Coords.w = l_t_BufferTV2->Largeur;
    l_t_BufferTV2->Coords.h = l_t_BufferTV2->Hauteur;
    
    l_t_BufferTV3->Largeur = 250;
    l_t_BufferTV3->Hauteur = 177;
    l_t_BufferTV3->Coords.x = l_t_BufferTV3->Coords.y = 0;
    l_t_BufferTV3->Coords.w = l_t_BufferTV3->Largeur;
    l_t_BufferTV3->Coords.h = l_t_BufferTV3->Hauteur;
    
    l_t_BufferTV4->Largeur = 250;
    l_t_BufferTV4->Hauteur = 177;
    l_t_BufferTV4->Coords.x = l_t_BufferTV4->Coords.y = 0;
    l_t_BufferTV4->Coords.w = l_t_BufferTV4->Largeur;
    l_t_BufferTV4->Coords.h = l_t_BufferTV4->Hauteur;
    
    l_sdl_CoordsCoper1.x = 0;
    l_sdl_CoordsCoper1.y = 0;
    l_sdl_CoordsCoper1.w = l_pt_Coper1->Largeur;
    l_sdl_CoordsCoper1.h = l_pt_Coper1->Hauteur;
    
    l_sdl_CoordsCoper2.x = 0;
    l_sdl_CoordsCoper2.y = 0;
    l_sdl_CoordsCoper2.w = l_pt_Coper2->Largeur;
    l_sdl_CoordsCoper2.h = l_pt_Coper2->Hauteur;
    
    l_sdl_CoordsCoper3.x = 0;
    l_sdl_CoordsCoper3.y = 0;
    l_sdl_CoordsCoper3.w = l_pt_Coper3->Largeur;
    l_sdl_CoordsCoper3.h = l_pt_Coper3->Hauteur;
    
    l_sdl_CoordsCoper4.x = 0;
    l_sdl_CoordsCoper4.y = 0;
    l_sdl_CoordsCoper4.w = l_pt_Coper4->Largeur;
    l_sdl_CoordsCoper4.h = l_pt_Coper4->Hauteur;
    
    /* -- Creation des 4 buffer pour les 4 teles -- */
    l_t_BufferTV1->DonneesImage = SDL_CreateRGBSurface( SDL_HWSURFACE, l_t_BufferTV1->Largeur, l_t_BufferTV1->Hauteur, l_pt_Ecran->DonneesImage->format->BitsPerPixel, 0, 0, 0, 0 );
    l_t_BufferTV2->DonneesImage = SDL_CreateRGBSurface( SDL_HWSURFACE, l_t_BufferTV2->Largeur, l_t_BufferTV2->Hauteur, l_pt_Ecran->DonneesImage->format->BitsPerPixel, 0, 0, 0, 0 );
    l_t_BufferTV3->DonneesImage = SDL_CreateRGBSurface( SDL_HWSURFACE, l_t_BufferTV3->Largeur, l_t_BufferTV3->Hauteur, l_pt_Ecran->DonneesImage->format->BitsPerPixel, 0, 0, 0, 0 );
    l_t_BufferTV4->DonneesImage = SDL_CreateRGBSurface( SDL_HWSURFACE, l_t_BufferTV4->Largeur, l_t_BufferTV4->Hauteur, l_pt_Ecran->DonneesImage->format->BitsPerPixel, 0, 0, 0, 0 );
    
    
    SDL_FillRect( l_t_BufferTV1->DonneesImage, &l_t_BufferTV1->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) ); 
    SDL_FillRect( l_t_BufferTV2->DonneesImage, &l_t_BufferTV2->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) ); 
    SDL_FillRect( l_t_BufferTV3->DonneesImage, &l_t_BufferTV3->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) ); 
    SDL_FillRect( l_t_BufferTV4->DonneesImage, &l_t_BufferTV4->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) ); 
    
    /* -- Copie les 4 teles -- */
    
    l_sdl_Coords.x = 0;
    l_sdl_Coords.y = 0;
    l_sdl_Coords.w = l_pt_TV->Largeur;
    l_sdl_Coords.h = l_pt_TV->Hauteur;
    
    l_sdl_CoordsTmp.x = 21;
    l_sdl_CoordsTmp.y = 17;
    l_sdl_CoordsTmp.w = l_t_BufferTV1->Largeur;
    l_sdl_CoordsTmp.h = l_t_BufferTV1->Hauteur;
    
    SDL_BlitSurface( l_pt_TV->DonneesImage, &l_pt_TV->Coords, l_pt_Ecran->DonneesImage, &l_sdl_Coords );
    SDL_BlitSurface( l_t_BufferTV1->DonneesImage, &l_t_BufferTV1->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );	
    SDL_Flip( l_pt_Ecran->DonneesImage );
    
    WaitDelayAndWaitKey( 500 );
    l_sdl_Coords.x = RESO_X - l_pt_TV->Largeur;
    l_sdl_CoordsTmp.x = l_sdl_Coords.x + 21;
    l_sdl_CoordsTmp.y = 17;
    SDL_BlitSurface( l_pt_TV->DonneesImage, &l_pt_TV->Coords, l_pt_Ecran->DonneesImage, &l_sdl_Coords );
    SDL_BlitSurface( l_t_BufferTV2->DonneesImage, &l_t_BufferTV2->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    
    WaitDelayAndWaitKey( 500 );
    l_sdl_Coords.x = RESO_X - l_pt_TV->Largeur;
    l_sdl_Coords.y = RESO_Y - l_pt_TV->Hauteur;
    l_sdl_CoordsTmp.x = l_sdl_Coords.x + 21;
    l_sdl_CoordsTmp.y = l_sdl_Coords.y + 17;
    SDL_BlitSurface( l_pt_TV->DonneesImage, &l_pt_TV->Coords, l_pt_Ecran->DonneesImage, &l_sdl_Coords );
    SDL_BlitSurface( l_t_BufferTV3->DonneesImage, &l_t_BufferTV3->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    
    WaitDelayAndWaitKey( 500 );
    l_sdl_Coords.x = 0;
    l_sdl_Coords.y = RESO_Y - l_pt_TV->Hauteur;
    l_sdl_CoordsTmp.x = 21;
    l_sdl_CoordsTmp.y = l_sdl_Coords.y + 17;
    SDL_BlitSurface( l_pt_TV->DonneesImage, &l_pt_TV->Coords, l_pt_Ecran->DonneesImage, &l_sdl_Coords );
    SDL_BlitSurface( l_t_BufferTV4->DonneesImage, &l_t_BufferTV4->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    
    /* -- L'effet de neige sur les 4 teles -- */
    l_ul_TimeBegin = SDL_GetTicks(); /* -- Init le compteur de frames -- */
    l_ul_TimeEnd = SDL_GetTicks(); /* -- Init le compteur de frames -- */
    
    while( ( ( l_ul_TimeEnd - l_ul_TimeBegin ) < 3000 ) && ( WaitKey() != TRUE ) )
      {
        l_sdl_CoordsTmp.x = 21;
        l_sdl_CoordsTmp.y = 17;
        NeigeTV( l_t_BufferTV1->DonneesImage, l_t_BufferTV1->Coords );
        SDL_BlitSurface( l_t_BufferTV1->DonneesImage, &l_t_BufferTV1->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );
        
        l_sdl_CoordsTmp.x = 371;
        l_sdl_CoordsTmp.y = 17;
        NeigeTV( l_t_BufferTV2->DonneesImage, l_t_BufferTV2->Coords );
        SDL_BlitSurface( l_t_BufferTV2->DonneesImage, &l_t_BufferTV2->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );
        
        l_sdl_CoordsTmp.x = 371;
        l_sdl_CoordsTmp.y = 267;
        NeigeTV( l_t_BufferTV3->DonneesImage, l_t_BufferTV3->Coords );
        SDL_BlitSurface( l_t_BufferTV3->DonneesImage, &l_t_BufferTV3->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );
        
        l_sdl_CoordsTmp.x = 21;
        l_sdl_CoordsTmp.y = 267;
        NeigeTV( l_t_BufferTV4->DonneesImage, l_t_BufferTV4->Coords );
        SDL_BlitSurface( l_t_BufferTV4->DonneesImage, &l_t_BufferTV4->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );
        
        SDL_Flip( l_pt_Ecran->DonneesImage );
        l_ul_TimeEnd = SDL_GetTicks(); 
      }
    
    l_sdl_CoordsCoper1.x = 0;
    l_sdl_CoordsCoper1.y = 0;
    
    /* -- les 4 effets sur les 4 teles -- */
    l_ul_TimeBegin = SDL_GetTicks(); /* -- Init le compteur de frames -- */
    l_ul_TimeEnd = SDL_GetTicks(); /* -- Init le compteur de frames -- */
    
    while( ( l_pt_ScrollText->Coords.x < l_pt_ScrollText->Largeur ) && ( WaitKey() != TRUE ) )
      //while( WaitKey() != TRUE )
      {
        /* -- Tele HG -- */
        if( l_sdl_CoordsCoper1.y >= ( l_t_BufferTV1->Coords.h - l_pt_Coper1->Hauteur ) )
          l_c_PasCoper1 = -l_c_PasCoperGeneral;
        if( l_sdl_CoordsCoper1.y <= 0 )
          l_c_PasCoper1 = l_c_PasCoperGeneral;
        
        if( l_b_FlagCoper == TRUE )
          {
            if( l_sdl_CoordsCoper1.y > l_sdl_CoordsCoper1.h + 5 )
              l_c_PasCoper2 = l_c_PasCoperGeneral;
            if( l_sdl_CoordsCoper2.y > l_sdl_CoordsCoper2.h + 5 )
              l_c_PasCoper3 = l_c_PasCoperGeneral;
            if( l_sdl_CoordsCoper3.y > l_sdl_CoordsCoper3.h + 5 )
              {
	 l_c_PasCoper4 = l_c_PasCoperGeneral;
	 l_b_FlagCoper = FALSE;
              }
          }
        else
          {
            if( l_sdl_CoordsCoper2.y >= ( l_t_BufferTV1->Coords.h - l_pt_Coper2->Hauteur ) )
              l_c_PasCoper2 = -l_c_PasCoperGeneral;
            if( l_sdl_CoordsCoper2.y <= 0 )
              l_c_PasCoper2 = l_c_PasCoperGeneral;
            
            if( l_sdl_CoordsCoper3.y >= ( l_t_BufferTV1->Coords.h - l_pt_Coper3->Hauteur ) )
              l_c_PasCoper3 = -l_c_PasCoperGeneral;
            if( l_sdl_CoordsCoper3.y <= 0 )
              l_c_PasCoper3 = l_c_PasCoperGeneral;
            
            if( l_sdl_CoordsCoper4.y >= ( l_t_BufferTV1->Coords.h - l_pt_Coper4->Hauteur ) )
              l_c_PasCoper4 = -l_c_PasCoperGeneral;
            if( l_sdl_CoordsCoper4.y <= 0 )
              l_c_PasCoper4 = l_c_PasCoperGeneral;
          }
        
        SDL_FillRect( l_t_BufferTV1->DonneesImage, &l_t_BufferTV1->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) ); 
        SDL_BlitSurface( l_pt_Coper1->DonneesImage, &l_pt_Coper1->Coords, l_t_BufferTV1->DonneesImage, &l_sdl_CoordsCoper1 );
        SDL_BlitSurface( l_pt_Coper2->DonneesImage, &l_pt_Coper2->Coords, l_t_BufferTV1->DonneesImage, &l_sdl_CoordsCoper2 );
        SDL_BlitSurface( l_pt_Coper3->DonneesImage, &l_pt_Coper3->Coords, l_t_BufferTV1->DonneesImage, &l_sdl_CoordsCoper3 );
        SDL_BlitSurface( l_pt_Coper4->DonneesImage, &l_pt_Coper4->Coords, l_t_BufferTV1->DonneesImage, &l_sdl_CoordsCoper4 );
        VideoApparence( l_t_BufferTV1 ); /* -- cette ligne doit tjs etre la derniere car elle provoque l'effet TV sur la rotalite de l'image -- */
        l_sdl_CoordsTmp.x = 21;
        l_sdl_CoordsTmp.y = 17;
        SDL_BlitSurface( l_t_BufferTV1->DonneesImage, &l_t_BufferTV1->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );
        
        /* -- Tele HD -- */
        
        SDL_FillRect( l_t_BufferTV2->DonneesImage, &l_t_BufferTV2->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) ); 
        
        if( l_pt_ScrollText->Coords.x < l_pt_ScrollText->Largeur )
          {
            l_sdl_CoordsTmp.x = 0;
            l_sdl_CoordsTmp.y = ( l_t_BufferTV2->Hauteur - l_pt_ScrollText->Hauteur ) /4 + ( sin( l_f_PasScrollText ) *10 );
            l_pt_ScrollText->Coords.w = l_t_BufferTV2->Largeur;
            SDL_BlitSurface( l_pt_ScrollText->DonneesImage, &l_pt_ScrollText->Coords, l_t_BufferTV2->DonneesImage, &l_sdl_CoordsTmp );
            l_sdl_CoordsTmp.y *= 2;
            SDL_BlitSurface( l_pt_ScrollText->DonneesImage, &l_pt_ScrollText->Coords, l_t_BufferTV2->DonneesImage, &l_sdl_CoordsTmp );
            l_pt_ScrollText->Coords.x += 2;
            l_f_PasScrollText += .08;
          }
        else
          {
            l_pt_ScrollText->Coords.x = 0;
          }
        
        VideoApparence( l_t_BufferTV2 ); /* -- cette ligne doit tjs etre la derniere car elle provoque l'effet TV sur la rotalite de l'image -- */
        l_sdl_CoordsTmp.x = 371;
        l_sdl_CoordsTmp.y = 17;
        SDL_BlitSurface( l_t_BufferTV2->DonneesImage, &l_t_BufferTV2->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );
        
        /* -- Tele BD -- */
        l_sdl_CoordsTmp.x = 0;
        l_sdl_CoordsTmp.y = 0;
        SDL_BlitSurface( l_pt_DiableTV->DonneesImage, &l_pt_DiableTV->Coords, l_t_BufferTV3->DonneesImage, &l_t_BufferTV3->Coords );
        
        {
          unsigned short l_us_CompteurY = 0, l_us_SavVariable = l_sdl_CoordsTmp.h;
          
          l_sdl_CoordsTmp.y = 0;
          l_sdl_CoordsTmp.h = 1;
          l_pt_DiableTV->Coords.h = 1;
          for( l_us_CompteurY = 0 ; l_us_CompteurY < l_pt_DiableTV->Hauteur ; l_us_CompteurY++ )
            {
              l_sdl_CoordsTmp.x = sin( l_f_PasWobbler ) *5;
              SDL_BlitSurface( l_pt_DiableTV->DonneesImage, &l_pt_DiableTV->Coords, l_t_BufferTV3->DonneesImage, &l_sdl_CoordsTmp );
              l_sdl_CoordsTmp.y ++;
              l_pt_DiableTV->Coords.y++;
              l_f_PasWobbler += .08;
            }
          l_pt_DiableTV->Coords.h = l_pt_DiableTV->Hauteur;
          l_pt_DiableTV->Coords.y = 0;
          l_sdl_CoordsTmp.h = l_us_SavVariable;
        }
        VideoApparence( l_t_BufferTV3 ); /* -- cette ligne doit tjs etre la derniere car elle provoque l'effet TV sur la rotalite de l'image -- */
        l_sdl_CoordsTmp.x = 371;
        l_sdl_CoordsTmp.y = 267;
        SDL_BlitSurface( l_t_BufferTV3->DonneesImage, &l_t_BufferTV3->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );
        
        /* -- Tele BG -- */
        
        SDL_BlitSurface( l_pt_Tableau1->DonneesImage, &l_pt_Tableau1->Coords, l_t_BufferTV4->DonneesImage, &l_t_BufferTV4->Coords );
        SDL_SetAlpha( l_pt_Tableau2->DonneesImage, SDL_SRCALPHA, l_uc_Opacite ); /* -- 128 opacite a 50% -- */
        SDL_BlitSurface( l_pt_Tableau2->DonneesImage, &l_pt_Tableau2->Coords, l_t_BufferTV4->DonneesImage, &l_t_BufferTV4->Coords );
        
        VideoApparence( l_t_BufferTV4 ); /* -- cette ligne doit tjs etre la derniere car elle provoque l'effet TV sur la rotalite de l'image -- */
        l_sdl_CoordsTmp.x = 21;
        l_sdl_CoordsTmp.y = 267;
        SDL_BlitSurface( l_t_BufferTV4->DonneesImage, &l_t_BufferTV4->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );
        if( l_uc_Opacite + l_c_PasOpacite >= 255 )
          l_c_PasOpacite = -3;
        if( l_uc_Opacite + l_c_PasOpacite <= 0 )
          l_c_PasOpacite = 3;
        
        l_uc_Opacite += l_c_PasOpacite;
        
        SDL_Flip( l_pt_Ecran->DonneesImage );
        
        l_ul_TimeEnd = SDL_GetTicks(); 
        l_sdl_CoordsCoper1.y += l_c_PasCoper1; 
        l_sdl_CoordsCoper2.y += l_c_PasCoper2; 
        l_sdl_CoordsCoper3.y += l_c_PasCoper3; 
        l_sdl_CoordsCoper4.y += l_c_PasCoper4; 
        
      } /* -- Fin du while -- */
    
    SDL_FreeSurface( l_t_BufferTV1->DonneesImage );
    SDL_FreeSurface( l_t_BufferTV2->DonneesImage );
    SDL_FreeSurface( l_t_BufferTV3->DonneesImage );
    SDL_FreeSurface( l_t_BufferTV4->DonneesImage );
    
    free( l_t_BufferTV1 );
    free( l_t_BufferTV2 );
    free( l_t_BufferTV3 );
    free( l_t_BufferTV4 );
  }
  
  /* -- ======================================================================= -- */
  /* -- =======                                                         ======= -- */
  /* -- =======                  Fade sur les 4 teles                   ======= -- */
  /* -- =======                                                         ======= -- */
  /* -- ======================================================================= -- */
  FadeOut( ( StructImage_t * ) l_pt_Ecran, 1.2 );
  
  
  /* -- ======================================================================= -- */
  /* -- =======                                                         ======= -- */
  /* -- =======                  Fin Membre de la demo                  ======= -- */
  /* -- =======                                                         ======= -- */
  /* -- ======================================================================= -- */
  {
    SDL_Rect l_sdl_CoordsSprite;
    g_ul_CompteurSound = 0;
    
    /* -- Affichage de Taz -- */
    /* -- Affichage de Taz -- */
    /* -- Affichage de Taz -- */
    /* -- Affichage de Taz -- */
    SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( 1000 );	
    
    l_sdl_CoordsSprite.x = 10;
    l_sdl_CoordsSprite.y = 345;
    l_sdl_CoordsSprite.w = l_pt_Code->Largeur;
    l_sdl_CoordsSprite.h = l_pt_Code->Hauteur;
    SDL_BlitSurface( l_pt_Code->DonneesImage, &l_pt_Code->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsSprite );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( 1000 );	
    
    SDL_BlitSurface( l_pt_ImgTaz->DonneesImage, &l_pt_ImgTaz->Coords, l_pt_Ecran->DonneesImage, &l_pt_ImgTaz->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    
    l_sdl_CoordsSprite.x = 30 + l_pt_Code->Largeur;
    l_sdl_CoordsSprite.y = 390;
    l_sdl_CoordsSprite.w = l_pt_Taz->Largeur;
    l_sdl_CoordsSprite.h = l_pt_Taz->Hauteur;
    SDL_BlitSurface( l_pt_Taz->DonneesImage, &l_pt_Taz->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsSprite );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( 1000 );
    

    while( ( Flou( ( StructImage_t * ) l_pt_Ecran, 0, 350, 640, 130, 1 ) == NOK ) && ( WaitKey() == FALSE ) )
      {
        SDL_Flip( l_pt_Ecran->DonneesImage );
      }
    WaitDelayAndWaitKey( 800 );

    /* -- Affichage du flash Vandame -- */
    SDL_BlitSurface( l_pt_Vandame01->DonneesImage, &l_pt_Vandame01->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame01->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame02->DonneesImage, &l_pt_Vandame02->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame02->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame03->DonneesImage, &l_pt_Vandame03->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame03->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame04->DonneesImage, &l_pt_Vandame04->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame04->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame05->DonneesImage, &l_pt_Vandame05->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame05->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame06->DonneesImage, &l_pt_Vandame06->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame06->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame07->DonneesImage, &l_pt_Vandame07->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame07->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame08->DonneesImage, &l_pt_Vandame08->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame08->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame09->DonneesImage, &l_pt_Vandame09->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame09->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame10->DonneesImage, &l_pt_Vandame10->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame10->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame11->DonneesImage, &l_pt_Vandame11->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame11->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame12->DonneesImage, &l_pt_Vandame12->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame12->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame13->DonneesImage, &l_pt_Vandame13->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame13->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame14->DonneesImage, &l_pt_Vandame14->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame14->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame15->DonneesImage, &l_pt_Vandame15->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame15->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame16->DonneesImage, &l_pt_Vandame16->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame16->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame17->DonneesImage, &l_pt_Vandame17->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame17->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame18->DonneesImage, &l_pt_Vandame18->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame18->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame19->DonneesImage, &l_pt_Vandame19->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame19->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame20->DonneesImage, &l_pt_Vandame20->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame20->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame21->DonneesImage, &l_pt_Vandame21->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame21->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );

    /* -- Affichage de Kman -- */
    /* -- Affichage de Kman -- */
    /* -- Affichage de Kman -- */
    /* -- Affichage de Kman -- */
    SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( 1000 );	
    
    l_sdl_CoordsSprite.x = 10;
    l_sdl_CoordsSprite.y = 345;
    l_sdl_CoordsSprite.w = l_pt_Zic->Largeur;
    l_sdl_CoordsSprite.h = l_pt_Zic->Hauteur;
    SDL_BlitSurface( l_pt_Zic->DonneesImage, &l_pt_Zic->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsSprite );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( 1000 );	
    
    SDL_BlitSurface( l_pt_ImgKman->DonneesImage, &l_pt_ImgKman->Coords, l_pt_Ecran->DonneesImage, &l_pt_ImgKman->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    
    l_sdl_CoordsSprite.x = 30 + l_pt_Zic->Largeur;
    l_sdl_CoordsSprite.y = 390;
    l_sdl_CoordsSprite.w = l_pt_Kman->Largeur;
    l_sdl_CoordsSprite.h = l_pt_Kman->Hauteur;
    SDL_BlitSurface( l_pt_Kman->DonneesImage, &l_pt_Kman->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsSprite );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( 800 );
    
    while( ( Flou( ( StructImage_t * ) l_pt_Ecran, 0, 350, 640, 130, 1 ) == NOK ) && ( WaitKey() == FALSE ) )
      {
        SDL_Flip( l_pt_Ecran->DonneesImage );
      }

    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    /* -- Affichage du flash Vandame -- */
    SDL_BlitSurface( l_pt_Vandame01->DonneesImage, &l_pt_Vandame01->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame01->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame02->DonneesImage, &l_pt_Vandame02->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame02->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame03->DonneesImage, &l_pt_Vandame03->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame03->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame04->DonneesImage, &l_pt_Vandame04->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame04->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame05->DonneesImage, &l_pt_Vandame05->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame05->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame06->DonneesImage, &l_pt_Vandame06->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame06->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame07->DonneesImage, &l_pt_Vandame07->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame07->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame08->DonneesImage, &l_pt_Vandame08->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame08->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame09->DonneesImage, &l_pt_Vandame09->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame09->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame10->DonneesImage, &l_pt_Vandame10->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame10->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame11->DonneesImage, &l_pt_Vandame11->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame11->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame12->DonneesImage, &l_pt_Vandame12->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame12->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame13->DonneesImage, &l_pt_Vandame13->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame13->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame14->DonneesImage, &l_pt_Vandame14->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame14->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame15->DonneesImage, &l_pt_Vandame15->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame15->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame16->DonneesImage, &l_pt_Vandame16->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame16->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame17->DonneesImage, &l_pt_Vandame17->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame17->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame18->DonneesImage, &l_pt_Vandame18->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame18->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame19->DonneesImage, &l_pt_Vandame19->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame19->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame20->DonneesImage, &l_pt_Vandame20->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame20->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame21->DonneesImage, &l_pt_Vandame21->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame21->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );

    /* -- Affichage de Taz -- */
    /* -- Affichage de Taz -- */
    /* -- Affichage de Taz -- */
    /* -- Affichage de Taz -- */
    SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( 1000 );	
    
    l_sdl_CoordsSprite.x = 10;
    l_sdl_CoordsSprite.y = 345;
    l_sdl_CoordsSprite.w = l_pt_Gfx->Largeur;
    l_sdl_CoordsSprite.h = l_pt_Gfx->Hauteur;
    SDL_BlitSurface( l_pt_Gfx->DonneesImage, &l_pt_Gfx->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsSprite );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( 700 );	
    
    SDL_BlitSurface( l_pt_ImgTaz->DonneesImage, &l_pt_ImgTaz->Coords, l_pt_Ecran->DonneesImage, &l_pt_ImgTaz->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    
    l_sdl_CoordsSprite.x = 30 + l_pt_Gfx->Largeur;
    l_sdl_CoordsSprite.y = 390;
    l_sdl_CoordsSprite.w = l_pt_Taz->Largeur;
    l_sdl_CoordsSprite.h = l_pt_Taz->Hauteur;
    SDL_BlitSurface( l_pt_Taz->DonneesImage, &l_pt_Taz->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsSprite );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( 800 );
    
    while( ( Flou( ( StructImage_t * ) l_pt_Ecran, 0, 350, 640, 130, 1 ) == NOK ) && ( WaitKey() == FALSE ) )
      {
        SDL_Flip( l_pt_Ecran->DonneesImage );
      }

    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    /* -- Affichage du flash Vandame -- */
    SDL_BlitSurface( l_pt_Vandame01->DonneesImage, &l_pt_Vandame01->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame01->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame02->DonneesImage, &l_pt_Vandame02->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame02->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame03->DonneesImage, &l_pt_Vandame03->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame03->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage);
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame04->DonneesImage, &l_pt_Vandame04->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame04->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame05->DonneesImage, &l_pt_Vandame05->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame05->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame06->DonneesImage, &l_pt_Vandame06->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame06->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame07->DonneesImage, &l_pt_Vandame07->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame07->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame08->DonneesImage, &l_pt_Vandame08->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame08->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame09->DonneesImage, &l_pt_Vandame09->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame09->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame10->DonneesImage, &l_pt_Vandame10->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame10->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame11->DonneesImage, &l_pt_Vandame11->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame11->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame12->DonneesImage, &l_pt_Vandame12->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame12->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame13->DonneesImage, &l_pt_Vandame13->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame13->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame14->DonneesImage, &l_pt_Vandame14->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame14->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame15->DonneesImage, &l_pt_Vandame15->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame15->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame16->DonneesImage, &l_pt_Vandame16->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame16->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame17->DonneesImage, &l_pt_Vandame17->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame17->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame18->DonneesImage, &l_pt_Vandame18->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame18->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame19->DonneesImage, &l_pt_Vandame19->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame19->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame20->DonneesImage, &l_pt_Vandame20->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame20->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );
    SDL_BlitSurface( l_pt_Vandame21->DonneesImage, &l_pt_Vandame21->Coords, l_pt_Ecran->DonneesImage, &l_pt_Vandame21->Coords );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( FPS );

    SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    
    SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) );
    /* -- Affichage de la facade -- */
    SDL_BlitSurface( l_pt_Fin->DonneesImage, &l_pt_Fin->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( 1000 );	
  }
  

  
  /* -- ======================================================================= -- */
  /* -- =======                                                         ======= -- */
  /* -- =======                   Greets  Vieille tl                  ======= -- */
  /* -- =======                                                         ======= -- */
  /* -- ======================================================================= -- */
  {
    /* -- Coordonnees du coin sup. gauche de l'interieur de la tele : x = 68 ; y = 64 -- */
    /* -- Largeur et hauteur de l'interieur de la tele : L = 508 ; H = 356 -- */
    SDL_Rect l_sdl_CoordsTmp;
    SDL_Surface  *l_sdl_Buffer1 = NULL;

    l_sdl_Buffer1 = SDL_CreateRGBSurface( SDL_HWSURFACE, 508, 336, l_pt_Ecran->DonneesImage->format->BitsPerPixel, 0, 0, 0, 0 );

    SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) );

    SDL_BlitSurface( l_pt_OldTV->DonneesImage, &l_pt_OldTV->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );

    /* -- Affichage du Greets -- */
    l_sdl_CoordsTmp.x = ( RESO_X - l_pt_Greets->Largeur ) >> 1; // Centrage avec une division par 2
    l_sdl_CoordsTmp.y = 55;
    l_sdl_CoordsTmp.w = l_pt_Greets->Largeur;
    l_sdl_CoordsTmp.h = l_pt_Greets->Hauteur;

    SDL_BlitSurface( l_pt_Greets->DonneesImage, &l_pt_Greets->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );
    VideoApparence( ( StructImage_t * )  l_pt_Ecran ); /* -- cette ligne doit tjs etre la derniere car elle provoque l'effet TV sur la rotalite de l'image -- */
    SDL_BlitSurface( l_pt_OldTV->DonneesImage, &l_pt_OldTV->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( 1000 );

    /* -- Affichage Piark + Greets -- */

    SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) );
    l_sdl_CoordsTmp.x = ( RESO_X - l_pt_Greets->Largeur ) >> 1; // Centrage avec une division par 2
    l_sdl_CoordsTmp.y = 55;
    l_sdl_CoordsTmp.w = l_pt_Greets->Largeur;
    l_sdl_CoordsTmp.h = l_pt_Greets->Hauteur;

    SDL_BlitSurface( l_pt_Greets->DonneesImage, &l_pt_Greets->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );

    l_sdl_CoordsTmp.x = ( RESO_X - l_pt_Piark->Largeur ) >> 1; // Centrage avec une division par 2
    l_sdl_CoordsTmp.y += l_pt_Piark->Hauteur +10;
    l_sdl_CoordsTmp.w = l_pt_Piark->Largeur;
    l_sdl_CoordsTmp.h = l_pt_Piark->Hauteur;

    SDL_BlitSurface( l_pt_Piark->DonneesImage, &l_pt_Piark->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );
    VideoApparence( ( StructImage_t * )  l_pt_Ecran ); /* -- cette ligne doit tjs etre la derniere car elle provoque l'effet TV sur la rotalite de l'image -- */
    SDL_BlitSurface( l_pt_OldTV->DonneesImage, &l_pt_OldTV->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( 1000 );

    /* -- Affichage Tawny + Piark + Greets -- */

    SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) );
    l_sdl_CoordsTmp.x = ( RESO_X - l_pt_Greets->Largeur ) >> 1; // Centrage avec une division par 2
    l_sdl_CoordsTmp.y = 55;
    l_sdl_CoordsTmp.w = l_pt_Greets->Largeur;
    l_sdl_CoordsTmp.h = l_pt_Greets->Hauteur;

    SDL_BlitSurface( l_pt_Greets->DonneesImage, &l_pt_Greets->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );

    l_sdl_CoordsTmp.x = ( RESO_X - l_pt_Piark->Largeur ) >> 1; // Centrage avec une division par 2
    l_sdl_CoordsTmp.y += l_pt_Piark->Hauteur +10;
    l_sdl_CoordsTmp.w = l_pt_Piark->Largeur;
    l_sdl_CoordsTmp.h = l_pt_Piark->Hauteur;

    SDL_BlitSurface( l_pt_Piark->DonneesImage, &l_pt_Piark->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );

    l_sdl_CoordsTmp.x = ( RESO_X - l_pt_Tawny->Largeur ) >> 1; // Centrage avec une division par 2
    l_sdl_CoordsTmp.y += l_pt_Tawny->Hauteur +10;
    l_sdl_CoordsTmp.w = l_pt_Tawny->Largeur;
    l_sdl_CoordsTmp.h = l_pt_Tawny->Hauteur;

    SDL_BlitSurface( l_pt_Tawny->DonneesImage, &l_pt_Tawny->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );
    VideoApparence( ( StructImage_t * )  l_pt_Ecran ); /* -- cette ligne doit tjs etre la derniere car elle provoque l'effet TV sur la rotalite de l'image -- */
    SDL_BlitSurface( l_pt_OldTV->DonneesImage, &l_pt_OldTV->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( 1000 );

    /* -- Affichage Truiss + Tawny + Piark + Greets -- */

    SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) );
    l_sdl_CoordsTmp.x = ( RESO_X - l_pt_Greets->Largeur ) >> 1; // Centrage avec une division par 2
    l_sdl_CoordsTmp.y = 55;
    l_sdl_CoordsTmp.w = l_pt_Greets->Largeur;
    l_sdl_CoordsTmp.h = l_pt_Greets->Hauteur;

    SDL_BlitSurface( l_pt_Greets->DonneesImage, &l_pt_Greets->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );

    l_sdl_CoordsTmp.x = ( RESO_X - l_pt_Piark->Largeur ) >> 1; // Centrage avec une division par 2
    l_sdl_CoordsTmp.y += l_pt_Piark->Hauteur +10;
    l_sdl_CoordsTmp.w = l_pt_Piark->Largeur;
    l_sdl_CoordsTmp.h = l_pt_Piark->Hauteur;

    SDL_BlitSurface( l_pt_Piark->DonneesImage, &l_pt_Piark->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );

    l_sdl_CoordsTmp.x = ( RESO_X - l_pt_Tawny->Largeur ) >> 1; // Centrage avec une division par 2
    l_sdl_CoordsTmp.y += l_pt_Tawny->Hauteur +10;
    l_sdl_CoordsTmp.w = l_pt_Tawny->Largeur;
    l_sdl_CoordsTmp.h = l_pt_Tawny->Hauteur;

    SDL_BlitSurface( l_pt_Tawny->DonneesImage, &l_pt_Tawny->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );

    l_sdl_CoordsTmp.x = ( RESO_X - l_pt_Truiss->Largeur ) >> 1; /* -- Centrage avec une division par 2 -- */
    l_sdl_CoordsTmp.y += l_pt_Truiss->Hauteur +10;
    l_sdl_CoordsTmp.w = l_pt_Truiss->Largeur;
    l_sdl_CoordsTmp.h = l_pt_Truiss->Hauteur;

    SDL_BlitSurface( l_pt_Truiss->DonneesImage, &l_pt_Truiss->Coords, l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp );
    VideoApparence( ( StructImage_t * )  l_pt_Ecran ); /* -- cette ligne doit tjs etre la derniere car elle provoque l'effet TV sur la rotalite de l'image -- */
    SDL_BlitSurface( l_pt_OldTV->DonneesImage, &l_pt_OldTV->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );
    WaitDelayAndWaitKey( 2000 );

    SDL_FreeSurface( l_sdl_Buffer1 );
  }
WaitDelayAndWaitKey( 2000 );
  /* -- ======================================================================= -- */
  /* -- =======                                                         ======= -- */
  /* -- =======            La fin Star Wars sur vieille tl            ======= -- */
  /* -- =======                                                         ======= -- */
  /* -- ======================================================================= -- */
  {
    /* -- Coordonnees du coin sup. gauche de l'interieur de la tele : x = 68 ; y = 64 -- */
    /* -- Largeur et hauteur de l'interieur de la tele : L = 508 ; H = 356 -- */
    SDL_Rect l_sdl_CoordsTmp;
    SDL_Surface  *l_sdl_Buffer1 = NULL;
    int l_i_Largeur = RESO_X;

    l_sdl_Buffer1 = SDL_CreateRGBSurface( SDL_HWSURFACE, 508, 336, l_pt_Ecran->DonneesImage->format->BitsPerPixel, 0, 0, 0, 0 );

    SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) );

    VideoApparence( ( StructImage_t * )  l_pt_Ecran ); /* -- cette ligne doit tjs etre la derniere car elle provoque l'effet TV sur la rotalite de l'image -- */

    SDL_BlitSurface( l_pt_OldTV->DonneesImage, &l_pt_OldTV->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
    SDL_Flip( l_pt_Ecran->DonneesImage );

    /* -- Le generique a la StarWars !!!! -- */
    {
      short l_ps_CoordsPerspective[ RESO_Y ];
      unsigned int l_ui_Compteur1 = 0, l_ui_Compteur2 = 0;

      for( l_ui_Compteur1 = 0 ; l_ui_Compteur1 < RESO_Y ; l_ui_Compteur1++ )
        l_ps_CoordsPerspective[ l_ui_Compteur1 ] = 0;

      SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) );
      
      PrepareGeneriqueStarWars( &l_ps_CoordsPerspective[0], 250, 0, 0, RESO_Y ); /* --  250, 0, 0, RESO_Y pas touche !!! -- */
      for( l_ui_Compteur2 = 0 ; l_ui_Compteur2 < l_pt_GenSW->Hauteur - RESO_Y ; l_ui_Compteur2+=3 )
        {
          //SDL_BlitSurface( l_pt_FondSW->DonneesImage, &l_pt_FondSW->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );
          for( l_ui_Compteur1 = 0 ; l_ui_Compteur1 < RESO_Y  ; l_ui_Compteur1++ )
            {
              MappeLigneH( 0, l_ui_Compteur1+l_ui_Compteur2,
	            RESO_X, l_ui_Compteur1+l_ui_Compteur2,
	            l_pt_GenSW,
	            l_ps_CoordsPerspective[ l_ui_Compteur1 ], l_ui_Compteur1,
	            RESO_X - ( 2 * l_ps_CoordsPerspective[ l_ui_Compteur1 ] ), 
	            ( StructImage_t * ) l_pt_Ecran );
            }
            SDL_SetAlpha( l_pt_FadeSW->DonneesImage, SDL_SRCALPHA, 200 ); /* -- 128 opacite a 50% -- */
	        SDL_BlitSurface( l_pt_FadeSW->DonneesImage, &l_pt_FadeSW->Coords, l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords );

          //VideoApparence( ( StructImage_t * )  l_pt_Ecran ); /* -- cette ligne doit tjs etre la derniere car elle provoque l'effet TV sur la rotalite de l'image -- */
          SDL_Flip( l_pt_Ecran->DonneesImage );
          if( WaitKey() == TRUE )
            break;
        }
    } /* -- Fine du generique StarWars -- */
    WaitDelayAndWaitKey( 1000 );
    Flash( ( StructImage_t * ) l_pt_Ecran, 1, 300, 255, 255, 255 );
    
    l_sdl_CoordsTmp.x = 0;
    l_sdl_CoordsTmp.y = RESO_Y /2;
    l_sdl_CoordsTmp.w = l_i_Largeur;
    l_sdl_CoordsTmp.h = 1;
    while( l_sdl_CoordsTmp.x < RESO_X /2 )
      {
        SDL_FillRect( l_pt_Ecran->DonneesImage, &l_pt_Ecran->Coords, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 0, 0, 0 ) );
        
        l_sdl_CoordsTmp.x+=10;
        l_sdl_CoordsTmp.y = RESO_Y /2;
        l_sdl_CoordsTmp.w -= 20;
        l_sdl_CoordsTmp.h = 1;
        SDL_FillRect( l_pt_Ecran->DonneesImage, &l_sdl_CoordsTmp, SDL_MapRGB( l_pt_Ecran->DonneesImage->format, 255, 255, 255 ) );
        SDL_Flip( l_pt_Ecran->DonneesImage );
        }
  }

  /* -- ======================================================================= -- */
  /* -- =======                                                         ======= -- */
  /* -- =======                  FIN DU PROGRAMME                       ======= -- */
  /* -- =======                                                         ======= -- */
  /* -- ======================================================================= -- */
  
  
  /* -- Liberation des buffers images -- */
  CloseImage( l_pt_BufferNumericDream );
  CloseImage( l_pt_BufferPresente );
  CloseImage( l_pt_BufferR );
  CloseImage( l_pt_BufferU );
  CloseImage( l_pt_BufferB );
  CloseImage( l_pt_BufferI );
  CloseImage( l_pt_BufferS );
  CloseImage( l_pt_BufferH );
  CloseImage( l_pt_BufferRubbish );
  CloseImage( l_pt_BufferRampeTotal );
  CloseImage( l_pt_BufferRampeMasque );
  CloseImage( l_pt_BufferSupport );
  CloseImage( l_pt_BufferWarp );
  CloseImage( l_pt_BufferCinema );
  CloseImage( l_pt_BufferCercle );
  CloseImage( l_pt_Buffer5 );
  CloseImage( l_pt_Buffer4 );
  CloseImage( l_pt_Buffer3 );
  CloseImage( l_pt_Buffer2 );
  CloseImage( l_pt_Buffer1 );
  CloseImage( l_pt_Buffer0 );
  CloseImage( l_pt_Arc );
  //CloseImage( l_pt_Woman );
  CloseImage( l_pt_Bulles );
  CloseImage( l_pt_SpriteBullesGros );
  CloseImage( l_pt_SpriteBullesMoyen );
  CloseImage( l_pt_SpriteBullesPetit );
  CloseImage( l_pt_Facade );
  CloseImage( l_pt_TV );
  CloseImage( l_pt_Fond );
  CloseImage( l_pt_Coper1 );
  CloseImage( l_pt_Coper2 );
  CloseImage( l_pt_Coper3 );
  CloseImage( l_pt_Coper4 );
  CloseImage( l_pt_ScrollText );
  CloseImage( l_pt_DiableTV );
  CloseImage( l_pt_Tableau1 );
  CloseImage( l_pt_Tableau2 );
  CloseImage( l_pt_Fin );
  CloseImage( l_pt_Code );
  CloseImage( l_pt_Gfx );
  CloseImage( l_pt_Zic );
  CloseImage( l_pt_Taz );
  CloseImage( l_pt_Kman );
  CloseImage( l_pt_ImgKman );
  CloseImage( l_pt_ImgTaz );
  CloseImage( l_pt_Vandame01 );
  CloseImage( l_pt_Vandame02 );
  CloseImage( l_pt_Vandame03 );
  CloseImage( l_pt_Vandame04 );
  CloseImage( l_pt_Vandame05 );
  CloseImage( l_pt_Vandame06 );
  CloseImage( l_pt_Vandame07 );
  CloseImage( l_pt_Vandame08 );
  CloseImage( l_pt_Vandame09 );
  CloseImage( l_pt_Vandame10 );
  CloseImage( l_pt_Vandame11 );
  CloseImage( l_pt_Vandame12 );
  CloseImage( l_pt_Vandame13 );
  CloseImage( l_pt_Vandame14 );
  CloseImage( l_pt_Vandame15 );
  CloseImage( l_pt_Vandame16 );
  CloseImage( l_pt_Vandame17 );
  CloseImage( l_pt_Vandame18 );
  CloseImage( l_pt_Vandame19 );
  CloseImage( l_pt_Vandame20 );
  CloseImage( l_pt_Vandame21 );
  CloseImage( l_pt_OldTV );
  CloseImage( l_pt_Greets );
  CloseImage( l_pt_Piark );
  CloseImage( l_pt_Tawny );
  CloseImage( l_pt_Truiss );
  CloseImage( l_pt_GenSW );
  CloseImage( l_pt_FondSW );
  CloseImage( l_pt_FadeSW );

  /* -- Liberation des musiques -- */
  CloseZic( l_pt_ZicPrincipale );

  /* -- Libere le canal audio -- */
  CloseAudio( l_pt_Audio );

  /* -- Close Timer -- */
  SDL_RemoveTimer( l_sdl_Timer );

  /* -- Test si toutes les allocation sont libres -- */
/*  if( GLOBAL_NbAllocationZics != 0 )
    fprintf( stderr, "ATTENTION ; %d Zics alloues n'ont pas t dsalloues\n", GLOBAL_NbAllocationZics );

  if( GLOBAL_NbAllocationImages != 0 )
    fprintf( stderr, "ATTENTION ; %d Images alloues n'ont pas t dsalloues\n", GLOBAL_NbAllocationImages );
*/
  /* -- Fermeture Ecran -- */
  CloseScreen( l_pt_Ecran );
  return 0;
}
