uses windows,crt,video,tEngine,fmod;

// surface 80x25 (fixed), full clipping checking

// povolene znaky: ' '=#32 .. #255

const 
	clip_left: integer = 0;
	clip_right: integer = 79;
	clip_top: integer = 0;
	clip_bottom: integer = 24;
	
	 
type 
	tSurface = array [0..80*25-1] of word;
	
var mod80: array [-1000..1000] of integer;
	mod25: array [-1000..1000] of integer;
  	MDL    : PFMUSIC_MODULE;
  	color: array [0..15] of byte;

procedure clipCheck (var x,y: integer);
begin
	if x<clip_left then x:=clip_left;
	if x>clip_right then x:=clip_right;
	if y<clip_top then y:=clip_top;
	if y>clip_bottom then y:=clip_bottom;
end;

procedure clearSurface (var a: tSurface);
var i: integer;
begin
	for i:=0 to 80*25-1 do a[i]:=32;
end;

procedure flipSurface (var a: tSurface);
var i: integer;
begin
	for i:=0 to 80*25-1 do videoBuf^[i]:=a[i];
	updateScreen(true);
end;

procedure drawCharRectangle (x1,y1,x2,y2: integer; a: byte; var s: tSurface);
var i,j,q: integer;
begin
	clipCheck(x1,y1);
	clipCheck(x2,y2);
	for j:=y1 to y2 do begin
		q:=j*80;
		for i:=x1 to x2 do begin
			s[q+i]:=hi(s[q+i]) shl 8+a;
		end;
	end;
end;

procedure drawColorRectangle (x1,y1,x2,y2: integer; a: byte; var s: tSurface);
var i,j,q: integer;
begin
	clipCheck(x1,y1);
	clipCheck(x2,y2);
	for j:=y1 to y2 do begin
		q:=j*80;
		for i:=x1 to x2 do begin
			s[q+i]:=lo(s[q+i])+a shl 8;
		end;
	end;
end;
	
procedure drawCharColorRectangle (x1,y1,x2,y2: integer; w: word; var s: tSurface);
var i,j,q: integer;
begin
	clipCheck(x1,y1);
	clipCheck(x2,y2);
	for j:=y1 to y2 do begin
		q:=j*80;
		for i:=x1 to x2 do begin
			s[q+i]:=w;
		end;
	end;
end;

procedure drawRandomCharColorRectangle (x1,y1,x2,y2: integer; w: byte; var s: tSurface);
var i,j,q: integer;
begin
	clipCheck(x1,y1);
	clipCheck(x2,y2);
	for j:=y1 to y2 do begin
		q:=j*80;
		for i:=x1 to x2 do begin
			s[q+i]:=random(220)+32+w shl 8;
		end;
	end;
end;

procedure drawCharRandomColorRectangle (x1,y1,x2,y2: integer; w: byte; var s: tSurface);
var i,j,q: integer;
begin
	clipCheck(x1,y1);
	clipCheck(x2,y2);
	for j:=y1 to y2 do begin
		q:=j*80;
		for i:=x1 to x2 do begin
			s[q+i]:=w+random(16) shl 8;
		end;
	end;
end;

procedure putRandoms (num: word; var s: tSurface);
var i: integer;
begin
	for i:=0 to num-1 do s[random(80*25)]:=random(220)+32+random(256) shl 8;
end;

procedure shiftXCharSurface (dx: integer; var s: tSurface);
var t: tSurface;
	q,i,j: integer;
begin
	for j:=0 to 24 do begin
		q:=j*80;
		for i:=0 to 79 do t[q+i]:=lo(s[q+mod80[i+dx]])+hi(s[q+i]) shl 8;	//still bug
	end;
	s:=t;
end;

procedure shiftXColorSurface (dx: integer; var s: tSurface);
var t: tSurface;
	q,i,j: integer;
begin
	for j:=0 to 24 do begin
		q:=j*80;
		for i:=0 to 79 do t[q+i]:=lo(s[q+i])+hi(s[q+mod80[i+dx]]) shl 8;
	end;
	s:=t;
end;

procedure shiftXCharColorSurface (dx: integer; var s: tSurface);
begin
	shiftXCharSurface(dx,s);
	shiftXColorSurface(dx,s);
end;

procedure init_app;
var i,q: integer;
begin
	for i:=-1000 to 1000 do begin
		q:=i mod 80;
		while q<0 do inc(q,80);
		mod80[i]:=q;
	end;
	for i:=-1000 to 1000 do begin
		q:=i mod 25;
		while q<0 do inc(q,25);
		mod25[i]:=q;
	end;
	initVideo;

	IF NOT FSOUND_Init(44100, 32, 0) THEN BEGIN
     	WriteLn('Error: Failed Initializing...');
     	FSOUND_Close();
     	ReadKey;
     	halt;
   	END;

  	MDL:=FMUSIC_LoadSong('02lov.it');
  	IF MDL= nil THEN BEGIN
     	WriteLn('Error: Failed Song Loading...');
     	FSOUND_Close();
     	ReadKey;
     	halt;
   	END;
   	FMUSIC_PlaySong(MDL);
   	randomize;
   	
	timer_init;
end;
	
procedure done_app;
begin
   	fmusic_freesong(mdl);
   	fsound_close();
	doneVideo;
end;

var i: integer;
	s: tSurface;
	back0_x,back0_y: integer;
	back1_x,back1_y: integer;
	back2_x,back2_y: integer;
	back3_x,back3_y: integer;
	
procedure back0 (st,et: dword);
var x: integer;
begin
	shiftXCharColorSurface(4-random(8),s);
	if timer_get<55840 then for i:=32 to 255 do s[i]:=i+15 shl 8
	else for i:=32 to 255 do s[random(80*25)]:=i+15 shl 8;
	if timer_get<100000 then begin
		{drawCharRectangle(0,0,20,10,random(240)+32,s);
		drawColorRectangle(0,0,10,10,white shl 4,s);}
		drawCharColorRectangle(back1_x,back1_y,back1_x+20,back1_y+10,random(220)+32+(color[12] shl 4) shl 8,s);
		drawColorRectangle(back2_x,back2_y,back2_x+20,back2_y+10,white shl 4,s);
		drawColorRectangle(back0_x,back0_y,back0_x+14,back0_y+9,random(256),s);
		drawColorRectangle(back3_x,back3_y,back3_x+14,back3_y+9,random(256),s);
	end else begin
		for i:=0 to 50 do begin
			x:=random(80*25);
			s[x]:=lo(s[x])+random(16) shl (4+8);
		end;
	end;
end;

procedure fore0 (st,et: dword);
var x,y,t: dword;
begin
	if (timer_get and 7=0) then begin
		x:=random(80);
		y:=random(25);
		drawRandomCharColorRectangle(x,y,x+random(30),y+random(16),random(16),s);
	end;
end;

procedure putrandRectangle (st,et: dword);
var x,y: integer;
begin
	{x:=random(70);
	y:=random(20);
	drawCharColorRectangle(x,y,x+30,y+14,random(256)+random(16) shl 8,s);}
	putRandoms(1000,s);
end;

procedure clear0 (st,et: dword);
begin
	clearSurface(s);
end;

const ceee: array [0..10] of dword = (8420,12400,16400,20380,24360,28360,32340,36340,40320,44300,48300);
var pomeee: array [0..10] of dword;
const sharps: array [0..7] of dword = (55840,57840,59840,61840,63820,65820,67820,69800);
const hsharps: array [0..9] of dword = (71800,73800,75780,77780,79780,81780,83760,85760,87760,89740);

procedure eee0 (st,et: dword);
var a: integer;
begin
	a:=0;
	for i:=0 to 10 do if st=ceee[i]+100 then a:=i;
	case pomeee[a] of
		0: drawcharColorRectangle(0,0,40,24,176+color[0] shl 8,s);
		1: drawcharColorRectangle(40,0,79,24,177+color[1] shl 8,s);
		2: drawcharColorRectangle(0,12,79,24,178+color[2] shl 8,s);
		3: drawcharColorRectangle(0,0,79,12,219+color[3] shl 8,s);
	end;
end;

procedure sharp3 (st,et: dword);
var t: dword;
	i,j,q,x: integer;
begin
	t:=timer_get;
	x:=round(80*(t-st)/(et-st));
	i:=0;
	for j:=0 to 7 do if st=sharps[j] then i:=j;
	drawColorRectangle(x,0,x+10,24,color[i],s);
	for j:=0 to 24 do begin
		q:=j*80;
		for i:=x to x+9 do if q+i<80*24 then s[q+i]:=hi(s[q+i]) shl 8+(random(3)+176);
	end;
end;

procedure hsharp (st,et: dword);
var t: dword;
	i,j,q,y: integer;
begin
	t:=timer_get;
	y:=round(12+sin(2*pi*(t-st)/(et-st))*12);
	i:=0;
	for j:=0 to 9 do if st=hsharps[j] then i:=15-j;
	drawRandomCharColorRectangle(0,y-4,79,y+4,i shl 4,s);
end;
	
procedure back1 (st,et: dword);
var i: integer;
	x: integer;
begin
	{for i:=0 to 100 do s[random(80*25)]:=ord(' ')+(black+black shl 4) shl 8;}
	x:=round(80*(timer_get-st)/(et-st));
	for i:=0 to 24 do begin
		s[80*i+x]:=ord(' ')+(black+black shl 4) shl 8;
		s[(80*i+x+1) mod (80*25)]:=ord(' ')+(black+black shl 4) shl 8;
		s[(80*i+x+2) mod (80*25)]:=ord(' ')+(black+black shl 4) shl 8;
	end;
end;

procedure credit (st,et: dword);
const 
	cr0: array [0..12] of char = ('c','r','e','a','t','e','d',' ','b','y',' ','e','L');
	cr1: array [0..15] of char = ('s','o','u','n','d',' ','b','y',' ','_','m','_','e','_','e','k');
var i,j,k: dword;
begin
	//clearSurface(s);
	for i:=0 to 12 do s[80*12+80-13+i]:=ord(cr0[i])+(lightgray) shl 8;
	for i:=0 to 15 do s[80*13+80-16+i]:=ord(cr1[i])+(lightgray) shl 8;
	i:=random(60);
	s[80*19+i]:=random(220)+32+(random(16)+random(16) shl 4) shl 8;
	s[80*19+i+1]:=random(220)+32+(random(16)+random(16) shl 4) shl 8;
	s[80*19+i+2]:=random(220)+32+(random(16)+random(16) shl 4) shl 8;
	s[80*19+i+3]:=random(220)+32+(random(16)+random(16) shl 4) shl 8;
	s[80*19+i+4]:=random(220)+32+(random(16)+random(16) shl 4) shl 8;
end;

begin
	randomize;
	for i:=0 to 10 do pomeee[i]:=random(4);
	for i:=0 to 15 do color[i]:=random(16);
	back0_x:=random(60); back0_y:=random(20);
	back1_x:=random(60); back1_y:=random(20);
	back2_x:=random(60); back2_y:=random(20);
	init_app;
	
	time_add_item(0,123600-2000,@back0);
	time_add_item(123600-20,123600+10,@clear0);
	time_add_item(123600-2000,123600-1,@back1);
	
	time_add_item(123600,500000,@credit);
	
	time_add_item(440,440+200,@putrandRectangle);
	time_add_item(440+200,440+200+100,@clear0);
	
	time_add_item(1140,1140+200,@putrandRectangle);
	time_add_item(1140+200,1140+200+100,@clear0);
	
	time_add_item(2440,2440+200,@putrandRectangle);
	time_add_item(2440+200,2440+200+100,@clear0);
	
	time_add_item(3280,3280+200,@putrandRectangle);
	time_add_item(3280+200,3280+200+100,@clear0);
	
	time_add_item(4420,4420+200,@putrandRectangle);
	time_add_item(4420+200,4420+200+100,@clear0);

	time_add_item(5140,5140+200,@putrandRectangle);
	time_add_item(5140+200,5140+200+100,@clear0);

	time_add_item(6420,6420+200,@putrandRectangle);
	time_add_item(6420+200,6420+200+100,@clear0);

	time_add_item(7280,7280+200,@putrandRectangle);
	time_add_item(7280+200,7280+200+100,@clear0);
	
	for i:=0 to 7 do time_add_item(sharps[i],sharps[i]+1700,@sharp3);
	
	for i:=0 to 9 do begin
		time_add_item(hsharps[i],hsharps[i]+1600,@clear0);
		time_add_item(hsharps[i],hsharps[i]+1800,@back0);
		time_add_item(hsharps[i],hsharps[i]+1800,@hsharp);
	end;
	
	for i:=0 to 10 do time_add_item(ceee[i]+100,ceee[i]+100+500,@eee0);

	time_add_item(0,100000,@fore0);

	repeat
		if timer_passed>50 then begin
			time_call_items;
			flipSurface(s);
			timer_update;
		end;
	until (timer_get>127920) or keypressed;
	done_app;
end.