{$mode delphi}
unit efx2;

interface

uses windows,gl;

function efx2_init_new (note, volume: word): boolean;
procedure efx2_draw;

implementation

const 
	max = 8;
	tt = 350;

var 
	p: array [0..max-1] of record
		playing: boolean;
		startTime: dword;
		x,y: glfloat;
		dx,dy: glfloat;
		r,g,b,a: glfloat;
	end;
	
function efx2_init_new (note, volume: word): boolean;
var i,j: integer;
	q: single;
begin
	j:=-1;
	for i:=0 to max-1 do if not p[i].playing then j:=i;
	if j=-1 then begin
		result:=false;
		exit;
	end;
	with p[j] do begin
		playing:=true;
		startTime:=getTickCount;
		x:=random;
		y:=random;
		r:=random; g:=random; b:=random; a:=(volume/64)+0.2;
		if a>1.0 then a:=1.0;
		dx:=random*2-1;
		dy:=random*2-1;
		q:=1/sqrt(sqr(dx)+sqr(dy));
		dx:=dx*q*0.1;
		dy:=dy*q*0.1;
	end;
end;
	
procedure efx2_draw;
var t: longint;
	i: integer;
	xx,yy: single;
begin
	for i:=0 to max-1 do with p[i] do if playing then begin
		t:=getTickCount-startTime;
		if t>tt then playing:=false;
		glColor4f(r,g,b,a-(t/tt)*a);
		glPushmatrix();
		glTranslatef(x+random*0.05-0.025,y+random*0.05-0.025,0);
		//glTranslatef(x,y,0);
		glScalef(1+sin(pi*(t/tt))*0.2,1+sin(pi*(t/tt))*0.2,1);
		glBegin(GL_QUAD_STRIP);
		for i:=0 to 28 do begin
			xx:=sin(2*pi/28*i);
			yy:=cos(2*pi/28*i);
			glVertex2f(xx*3/10,yy*3/10);
			glVertex2f(xx*2/10,yy*2/10);			
		end;			
		glEnd();
		glPopMatrix();
	end;
end;

var i: integer;

begin
	for i:=0 to max-1 do p[i].playing:=false;
end.