{$mode delphi}
unit efx15;

interface

uses windows,gl;

function efx15_init_new (note, volume: word): boolean;
procedure efx15_draw;

implementation

const 
	max = 8;
	tt = 600;

var 
	p: array [0..max-1] of record
		playing: boolean;
		startTime: dword;
		x,amp,freq: glfloat;
		r,g,b,a: glfloat;
	end;
	
function efx15_init_new (note, volume: word): boolean;
var i,j: integer;
	v: single;
begin
	j:=-1;
	for i:=0 to max-1 do if not p[i].playing then j:=i;
	if j=-1 then begin
		result:=false;
		exit;
	end;
	with p[j] do begin
		playing:=true;
		startTime:=getTickCount;
		x:=random;
		amp:=random*0.2+0.1;
		freq:=4;
		v:=volume/64.0;
		r:=random*v; g:=random*v; b:=random*v; a:=v*1.5;
		if a>1.0 then a:=1.0;
	end;
end;
	
procedure efx15_draw;
var t: longint;
	i,j: integer;
	xx: single;
	//old1,old2: array [0..1] of single;
begin
	for i:=0 to max-1 do with p[i] do if playing then begin
		t:=getTickCount-startTime;
		if t>tt then playing:=false;
		glColor4f(r,g,b,a-(t/tt)*a);
		//glLineWidth(20.0);
		glBegin(GL_QUAD_STRIP);
		for j:=0 to 20 do begin
			xx:=amp*sin(j*freq*t/4000);
			glVertex2f(x+xx-0.035,j/20.0);
			glVertex2f(x+xx+0.035,j/20.0);
		end;
		glEnd();
	end;
end;

var i: integer;

begin
	for i:=0 to max-1 do p[i].playing:=false;
end.