{$mode delphi}
unit efx14;

interface

uses windows,gl;

function efx14_init_new (note, volume: word): boolean;
procedure efx14_draw;

implementation

const 
	max = 1;
	tt = 39000;

var 
	p: array [0..max-1] of record
		playing: boolean;
		startTime: dword;
		r1,g1,b1: glfloat;
		r2,g2,b2: glfloat;
		speed1,speed2: glfloat;		
	end;
	
function efx14_init_new (note, volume: word): boolean;
var i,j: integer;
	q: single;
begin
	j:=-1;
	for i:=0 to max-1 do if not p[i].playing then j:=i;
	if j=-1 then begin
		result:=false;
		exit;
	end;
	with p[j] do begin
		playing:=true;
		startTime:=getTickCount;
		r1:=0.0; g1:=0.1; b1:=0.34;
		r2:=0.34; g2:=0.0; b2:=0.1;
		//r1:=0.1; g1:=random; b1:=random;
		//r2:=random; g2:=random; b2:=random;
		speed1:=0;
	end;
end;
	
procedure efx14_draw;
const max_alpha = 0.7;
var t: longint;
	i: integer;
	w,y1: glfloat;
begin
	for i:=0 to max-1 do with p[i] do if playing then begin
		t:=getTickCount-startTime;
		if t>tt then playing:=false;
		
		glPushmatrix();
		
		if t<6000 then glColor4f(r1,g1,b1,t/6000*max_alpha)
		else if (t>tt-1000) then glColor4f(r1,g1,b1,(tt-t)/1000*max_alpha)
		else glColor4f(r1,g1,b1,max_alpha);
		speed1:=abs(sin((t/tt)*4*pi))*t*0.000011;
		//w:=sin(t*0.005)*0.02+0.4;
		w:=0.4;
		y1:=(t*0.001*speed1);
		y1:=y1-trunc(y1);
		glRectf(0,(y1*(w+1.0))-w,1,(y1*(w+1.0)));
	
		if t<6000 then glColor4f(r2,g2,b2,t/6000*max_alpha)
		else if (t>tt-1000) then glColor4f(r2,g2,b2,(tt-t)/1000*max_alpha)
		else glColor4f(r2,g2,b2,max_alpha);
		
		speed2:=abs(sin((t/tt)*4*pi+423859))*t*0.000011;
		//w:=sin(t*0.005)*0.02+0.4;
		y1:=((t)*0.001*speed2);
		y1:=y1-trunc(y1);
		glRectf(0,(y1*(w+1.0))-w,1,(y1*(w+1.0)));
		
		glPopMatrix();
	end;
end;

var i: integer;

begin
	for i:=0 to max-1 do p[i].playing:=false;
end.