#include <stdio.h>
#include <vga.h>
#include <math.h>
#include "skysound.h"


#define SIDE (double)20
#define RAD (M_PI / 180)
#define DELAY 4 

int WIDTH = 1024;
int HEIGHT = 768;


void d_init ( void );
void d_deinit ( void );
void view_cube( int r, int g, int b );
void spin_cube(double a); 
void write_text(char *buf, int r, int g, int b, int p, int q, int size);
void circle(int r, int g, int b, int size, int p, int q, int filled);

double d[4] = { 135, 45, 225, 315 };
double e[4] = { 135, 45, 225, 315 };

double x[4] = { };
double y[4] = { };
double u[4] = { };
double z[4] = { };

int firstrun = 0;

int color[4] = { 0x00, 0x00, 0x00, 1 };

char num[][5*10] = {
{ // 0
 0,1,1,1,0,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,1,1,
 1,0,1,0,1,
 1,1,0,0,1,
 1,0,0,0,1,
 0,1,1,1,0,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // 1
 0,0,1,0,0,
 0,1,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,1,1,1,0,
},
{ // 2
 0,1,1,0,0,
 1,0,0,1,0,
 0,0,0,0,1,
 0,0,0,1,0,
 0,0,1,0,0,
 0,1,0,0,0,
 1,0,0,0,0,
 1,1,1,1,1,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // 3
 0,1,1,1,0,
 1,0,0,0,1,
 0,0,0,0,1,
 0,0,1,1,0,
 0,0,0,0,1,
 0,0,0,0,1,
 1,0,0,0,1,
 0,1,1,1,0,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // 4
 0,0,0,1,0,
 0,0,1,1,0,
 0,1,0,1,0,
 1,0,0,1,0,
 1,1,1,1,1,
 0,0,0,1,0,
 0,0,0,1,0,
 0,0,0,1,0,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // 5
 1,1,1,1,1,
 1,0,0,0,0,
 1,0,0,0,0,
 1,1,1,1,0,
 0,0,0,0,1,
 0,0,0,0,1,
 1,0,0,0,1,
 0,1,1,1,0,
},
{ // 6
 0,1,1,1,1,
 1,0,0,0,0,
 1,0,0,0,0,
 1,1,1,1,0,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 0,1,1,1,0,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // 7
 1,1,1,1,1,
 0,0,0,0,1,
 0,0,0,1,0,
 0,0,1,0,0,
 0,1,0,0,0,
 0,1,0,0,0,
 0,1,0,0,0,
 0,1,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // 8
 0,1,1,1,0,
 1,0,0,0,1,
 1,0,0,0,1,
 0,1,1,1,0,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 0,1,1,1,0,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // 9
 0,1,1,1,0,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 0,1,1,1,1,
 0,0,0,0,1,
 0,0,0,0,1,
 0,1,1,1,0,
 0,0,0,0,0,
 0,0,0,0,0,
},
};

char lower[][5*10] = {
{ // a
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 0,1,1,1,0,
 0,0,0,0,1,
 0,1,1,1,1,
 1,0,0,0,1,
 0,1,1,1,1,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // b
 1,0,0,0,0,
 1,0,0,0,0,
 1,0,0,0,0,
 1,1,1,1,0,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 1,1,1,1,0,
 0,0,0,0,0,
 0,0,0,0,0,

},
{ // c
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 0,1,1,1,1,
 1,0,0,0,0,
 1,0,0,0,0,
 1,0,0,0,0,
 0,1,1,1,1,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // d
 0,0,0,0,1,
 0,0,0,0,1,
 0,0,0,0,1,
 0,1,1,1,1,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 0,1,1,1,1,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // e
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 0,1,1,1,0,
 1,0,0,0,1,
 1,1,1,1,0,
 1,0,0,0,0,
 0,1,1,1,1,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // f
 0,0,0,1,1,
 0,0,1,0,0,
 0,0,1,0,0,
 0,1,1,1,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,0,0,0,
},
{ // g
 0,0,0,0,0, 
 0,0,0,0,0,
 0,0,0,0,0,
 0,1,1,1,1,
 1,0,0,0,1,
 1,0,0,0,1,
 0,1,1,1,1,
 0,0,0,0,1,
 0,1,1,1,0,
},
{ // h
 1,0,0,0,0,
 1,0,0,0,0,
 1,0,0,0,0,
 1,1,1,1,0,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // i
 0,0,1,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 0,1,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // j
 0,0,1,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 0,1,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 1,1,0,0,0,
},
{ // k
 1,0,0,0,0,
 1,0,0,0,0,
 1,0,0,0,0,
 1,0,1,0,0,
 1,1,0,0,0,
 1,1,0,0,0,
 1,0,1,0,0,
 1,0,0,1,0,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // l
 0,1,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,1,1,1,0,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // m
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 1,1,0,1,0,
 1,1,1,1,1,
 1,0,1,0,1,
 1,0,1,0,1,
 1,0,0,0,1,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // n
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 1,1,1,1,0,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // o
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 0,1,1,1,0,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 0,1,1,1,0,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // p
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 1,1,1,1,0,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 1,1,1,1,0,
 1,0,0,0,0,
 1,0,0,0,0,
},
{ // q
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 0,1,1,1,1,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 0,1,1,1,1,
 0,0,0,0,1,
 0,0,0,0,1,
},
{ // r
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,1,1,1,
 0,1,0,0,0,
 0,1,0,0,0,
 0,1,0,0,0,
 0,1,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // s
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 0,1,1,1,1,
 1,1,0,0,0,
 0,0,1,0,0,
 0,0,0,1,1,
 1,1,1,1,0,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // t
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 1,1,1,1,1,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,1,0,0,
 0,0,0,1,1,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // u
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 0,1,1,1,1,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // v
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,1,0,
 1,0,1,0,0,
 0,1,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // w
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 1,0,0,0,1,
 1,0,1,0,1,
 1,0,1,0,1,
 1,1,1,1,1,
 0,1,0,1,0,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // x
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 1,0,0,0,1,
 0,1,0,1,0,
 0,0,1,0,0,
 0,1,0,1,0,
 1,0,0,0,1,
 0,0,0,0,0,
 0,0,0,0,0,
},
{ // y
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 1,0,0,0,1,
 0,1,1,1,1,
 0,0,0,0,1,
 0,1,1,1,0,
},
{ // z
 0,0,0,0,0,
 0,0,0,0,0,
 0,0,0,0,0,
 1,1,1,1,1,
 0,0,0,1,0,
 0,0,1,0,0,
 0,1,0,0,0,
 1,1,1,1,1,
 0,0,0,0,0,
 0,0,0,0,0,
},

};

void circle(int r, int g, int b, int size, int p, int q, int filled)
{
 double degree;
 int i;
 if(!filled) filled = size;
 
 for(i = size;i > 0;i-=filled)
 {
  for(degree = -180;degree <= 180;degree+=1)
  {
   vga_setrgbcolor(r, g, b);
   vga_drawpixel((int)(cos((degree*RAD))*i)+p, (int)(sin((degree)*RAD)*i)+q);
  }
 }
}

void spin_cube(double a)
{
   int i;
   
   if(!firstrun)
   {
    x[0] = WIDTH+cos(d[0]*RAD)*SIDE-SIDE*2;
    x[1] = WIDTH+cos(d[1]*RAD)*SIDE-SIDE*2;
    x[2] = WIDTH+cos(d[2]*RAD)*SIDE-SIDE*2;
    x[3] = WIDTH+cos(d[3]*RAD)*SIDE-SIDE*2;

    y[0] = HEIGHT+sin((d[0])*RAD)*SIDE-(int)(SIDE*1.5);
    y[1] = HEIGHT+sin((d[1])*RAD)*SIDE-(int)(SIDE*1.5);
    y[2] = HEIGHT+sin((d[2])*RAD)*SIDE-(int)(SIDE*1.5);
    y[3] = HEIGHT+sin((d[3])*RAD)*SIDE-(int)(SIDE*1.5);

    u[0] = x[0]+(int)(SIDE/1.5);
    u[1] = x[1]+(int)(SIDE/1.5);
    u[2] = x[2]+(int)(SIDE/1.5);
    u[3] = x[3]+(int)(SIDE/1.5);

    z[0] = y[0];
    z[1] = y[1];
    z[2] = y[2];
    z[3] = y[3];

    firstrun = 1;
   }
   
   d[0] += a;
   d[1] += a;
   d[2] += a;
   d[3] += a;
   e[0] += a;
   e[1] += a;
   e[2] += a;
   e[3] += a;

   view_cube(0x00, 0x00, 0x00);

   x[0] += cos(d[0]*RAD)*SIDE-((cos((d[0]-a)*RAD))*SIDE);
   x[1] += cos(d[1]*RAD)*SIDE-((cos((d[1]-a)*RAD))*SIDE);
   x[2] += cos(d[2]*RAD)*SIDE-((cos((d[2]-a)*RAD))*SIDE);
   x[3] += cos(d[3]*RAD)*SIDE-((cos((d[3]-a)*RAD))*SIDE);

   y[0] += sin(d[0]*RAD)*SIDE-((sin((d[0]-a)*RAD))*SIDE);
   y[1] += sin(d[1]*RAD)*SIDE-((sin((d[1]-a)*RAD))*SIDE);
   y[2] += sin(d[2]*RAD)*SIDE-((sin((d[2]-a)*RAD))*SIDE);
   y[3] += sin(d[3]*RAD)*SIDE-((sin((d[3]-a)*RAD))*SIDE);

   u[0] += cos(e[0]*RAD)*SIDE-((cos((e[0]-a)*RAD))*SIDE);
   u[1] += cos(e[1]*RAD)*SIDE-((cos((e[1]-a)*RAD))*SIDE);
   u[2] += cos(e[2]*RAD)*SIDE-((cos((e[2]-a)*RAD))*SIDE);
   u[3] += cos(e[3]*RAD)*SIDE-((cos((e[3]-a)*RAD))*SIDE);

   z[0] += sin(e[0]*RAD)*SIDE-((sin((e[0]-a)*RAD))*SIDE);
   z[1] += sin(e[1]*RAD)*SIDE-((sin((e[1]-a)*RAD))*SIDE);
   z[2] += sin(e[2]*RAD)*SIDE-((sin((e[2]-a)*RAD))*SIDE);
   z[3] += sin(e[3]*RAD)*SIDE-((sin((e[3]-a)*RAD))*SIDE);

   view_cube(color[0], color[1], color[2]);
   if(color[0] < 0xff && color[3] == 1 || color[0] > 0x00 && color[3] == -1)
    color[0] += color[3];
   else if(color[1] < 0xff && color[3] == 1 || color[1] > 0x00 && color[3] == -1)
    color[1] += color[3];
   else if(color[2] < 0xff && color[3] == 1 || color[2] > 0x00 && color[3] == -1)
    color[2] += color[3];

   if(color[0] == 0xff && color[1] == 0xff && color[2] == 0xff || color[0] == 0x00 && color[1] == 0x00 && color[2] == 0x00)
   {
    color[3] = color[3] * -1;
   }
}


void d_deinit( void )
{
 vga_setmode(0);
 SSND_FreeMPG();
 SSND_Uninit();
 system("killall demo;clear");
}

void view_cube( int r, int g, int b )
{
 vga_setrgbcolor(r, g, b);

 // Kvadrat, 2D
 vga_drawline((int)x[0], (int)y[0], (int)x[1], (int)y[1]);
 vga_drawline((int)x[2], (int)y[2], (int)x[3], (int)y[3]);

 vga_drawline((int)x[0], (int)y[0], (int)x[2], (int)y[2]);
 vga_drawline((int)x[1], (int)y[1], (int)x[3], (int)y[3]);

 // Kub, 3D
 vga_drawline((int)x[0], (int)y[0], (int)u[0], (int)z[0]);
 vga_drawline((int)x[1], (int)y[1], (int)u[1], (int)z[1]);

 vga_drawline((int)x[2], (int)y[2], (int)u[2], (int)z[2]);
 vga_drawline((int)x[3], (int)y[3], (int)u[3], (int)z[3]);

 vga_drawline((int)u[0], (int)z[0], (int)u[1], (int)z[1]);
 vga_drawline((int)u[2], (int)z[2], (int)u[3], (int)z[3]);

 vga_drawline((int)u[0], (int)z[0], (int)u[2], (int)z[2]);
 vga_drawline((int)u[1], (int)z[1], (int)u[3], (int)z[3]);
}
		 
void d_init( void )
{
 if(WIDTH == 1024) vga_setmode(24); // 1024x768x64k
 if(WIDTH == 800) vga_setmode(0);
 if(WIDTH == 640) vga_setmode(0);

 vga_init();
 vga_clear();

/*
 x[0] = 1024+cos(d[0]*RAD)*SIDE-SIDE*2;
 x[1] = 1024+cos(d[1]*RAD)*SIDE-SIDE*2;
 x[2] = 1024+cos(d[2]*RAD)*SIDE-SIDE*2;
 x[3] = 1024+cos(d[3]*RAD)*SIDE-SIDE*2;

 y[0] = 768+sin((d[0])*RAD)*SIDE-(int)(SIDE*1.5);
 y[1] = 768+sin((d[1])*RAD)*SIDE-(int)(SIDE*1.5);
 y[2] = 768+sin((d[2])*RAD)*SIDE-(int)(SIDE*1.5);
 y[3] = 768+sin((d[3])*RAD)*SIDE-(int)(SIDE*1.5);


 u[0] = x[0]+(int)(SIDE/1.5);
 u[1] = x[1]+(int)(SIDE/1.5);
 u[2] = x[2]+(int)(SIDE/1.5);
 u[3] = x[3]+(int)(SIDE/1.5);

 z[0] = y[0];
 z[1] = y[1];
 z[2] = y[2];
 z[3] = y[3];
*/
}


void write_text(char *buf, int r, int g, int b, int p, int q, int size)
{
 int i = 0;
 int n = 0;
 int x_size;
 int y_size;
 int u;

 int p_real = p;
 int q_real = q;

 char odd[][5*10] = {
 { // '
  0,0,1,1,0,
  0,0,1,0,0,
  0,1,0,0,0,
  0,0,0,0,0,
  0,0,0,0,0,
  0,0,0,0,0,
  0,0,0,0,0,
  0,0,0,0,0,
  0,0,0,0,0,
  0,0,0,0,0,
 },
 { // (
  0,0,0,1,0,
  0,0,1,0,0,
  0,1,0,0,0,
  0,1,0,0,0,
  1,1,0,0,0,
  1,1,0,0,0,
  0,1,0,0,0,
  0,1,0,0,0,
  0,0,1,0,0,
  0,0,0,1,0,
 },
 { // )
  0,1,0,0,0,
  0,0,1,0,0,
  0,0,0,1,0,
  0,0,0,1,0,
  0,0,0,1,1,
  0,0,0,1,1,
  0,0,0,1,0,
  0,0,0,1,0,
  0,0,1,0,0,
  0,1,0,0,0,
 },
 { // .
  0,0,0,0,0,
  0,0,0,0,0,
  0,0,0,0,0,
  0,0,0,0,0,
  0,0,0,0,0,
  0,0,0,0,0,
  0,0,0,0,0,
  0,0,0,1,0,
  0,0,0,0,0,
  0,0,0,0,0,
 },
 { // #
  0,1,0,1,0,
  0,1,0,1,0,
  1,1,1,1,1,
  0,1,0,1,0,
  0,1,0,1,0,
  1,1,1,1,1,
  0,1,0,1,0,
  0,1,0,1,0,
  0,0,0,0,0,
  0,0,0,0,0,
 },
 };

 
 vga_setrgbcolor(r, g, b);
 while(n < strlen(buf))
 {
  u = 0;
  if(buf[n] == '\n')
  {
   p += 11*size+2;
   q = q_real;
  }
  else if(buf[n] == ' ')
   p += 7*size;
  else
  {
   for(i = 0; i < (5*10);i++)
   {
    if ((lower[buf[n]-97][i] && buf[n] >= 97 && buf[n] <= 122) || (num[buf[n]-48][i] && buf[n] >= 48 && buf[n] <= 57) || (buf[n] == '\'' && odd[0][i]) || (buf[n] == '(' && odd[1][i]) || (buf[n] == ')' && odd[2][i]) || (buf[n] == '.' && odd[3][i]) || (buf[n] == '#' && odd[4][i]))
    {
     u = 1;
     for(x_size = size;x_size > 0;x_size--)
     {
      for(y_size = size;y_size > 0;y_size--)
       vga_drawpixel(p+(x_size-1)+(i % 5)*size, q+(y_size-1)+(i / 5)*size);
     }
    }
   }
   if(u) p += 7*size;
  }
 n++;
 }
}
