///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THWINDOW_H
#define SHARED_THWINDOW_H
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <windows.h>

///////////////////////////////////////////////////////////////////////////////////////////////////

class ThWindow
{
public:
// constructors
																		ThWindow(void);
	virtual														~ThWindow(void);
// methods
	bool															create(WNDCLASSEX& wcl, DWORD style, DWORD exStyle, HWND parent = NULL);
	void															attach(HWND window);
	void															release(void);
	void															show(void);
	void															hide(void);
// attributes
	bool															isCreated(void) const;
	bool															isVisible(void) const;
	HWND															getHandle(void) const;
	bool															getTitle(ThString& title) const;
	void															setTitle(const char* title);
// static methods
	static bool												update(bool wait);
protected:
// callbacks
	virtual LRESULT										create(CREATESTRUCT& cs);
	virtual LRESULT										command(HWND control, WORD identifier, BOOL accel);
	virtual LRESULT										message(UINT message, WPARAM wParam, LPARAM lParam);
private:
// static methods
	static LRESULT CALLBACK						windowProc(HWND window, UINT message, WPARAM wParam, LPARAM lParam);
// data
	ATOM															m_class;
	HWND															m_window;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THWINDOW_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
