///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THPARTICLE_H
#define SHARED_THPARTICLE_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThParticle : public ThListItem<ThParticle>
{
public:
// data
	ThVector3													m_position;
	ThVector3													m_speed;
	ThVector4													m_color;
	ThVector2													m_size;
	float															m_lifeTime;
	float															m_timeLeft;
};

//-------------------------------------------------------------------------------------------------

class ThParticleEmitter
{
public:
// methods
	void															generateDefaults(void);
// data
	ThVector3													m_position;
	ThRange<float>										m_speed;
	ThVector3													m_vector;
	ThRange<float>										m_angle;
	ThVector3													m_accel;
	ThSpace<ThVector4>								m_color;
	ThSpace<ThVector2>								m_size;
	ThRange<float>										m_time;
	float															m_ratio;
};

//-------------------------------------------------------------------------------------------------

class ThParticleSystem : public ThEffectObject
{
public:
// constructors
																		ThParticleSystem(void);
	virtual														~ThParticleSystem(void);
// methods
	void															create(unsigned int count);
	void															release(void);
	void															start(void);
	void															stop(void);
	void															pause(void);
	void															resume(void);
// callbacks
	bool															update(float deltaTime);
	bool															render(void);
// attributes
	bool															isStarted(void) const;
	bool															isPaused(void) const;
	unsigned int											getParticleCount(void) const;
	ThParticle*												getFirstParticle(void);
	ThParticleEmitter*								getEmitter(void);
protected:
// callbacks
	virtual void											createParticle(ThParticle* particle);
	virtual bool											updateParticle(ThParticle* particle, float deltaTime);
	virtual void											renderParticle(ThParticle* particle);
private:
// data
	bool															m_started;
	bool															m_paused;
	float															m_counter;
	ThPtr<ThParticleEmitter>					m_emitter;
	ThBlock<ThParticle>								m_particles;
	ThItemList<ThParticle>						m_active;
	ThItemList<ThParticle>						m_passive;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THPARTICLE_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
