///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THDISPLAY_H
#define SHARED_THDISPLAY_H
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <windows.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glaux.h>

///////////////////////////////////////////////////////////////////////////////////////////////////

interface IThDisplay
{
// constructors
	virtual														~IThDisplay(void);
// methods
	virtual void											update(void) = 0;
// texture methods
	virtual bool											loadTexture(const char* fileName, bool mipmap = false) = 0;
	virtual bool											loadTexture(IThInputStream* stream, bool mipmap = false) = 0;
// attributes
	virtual unsigned int							getWidth(void) = 0;
	virtual unsigned int							getHeight(void) = 0;
	virtual const char*								getTitle(void) = 0;
	virtual void											setTitle(const char* title) = 0;
// static methods
	static IThDisplay*								createInstance(unsigned int width, unsigned int height);
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /*SHARED_THDISPLAY_H*/
///////////////////////////////////////////////////////////////////////////////////////////////////
