///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THCORE_H
#define SHARED_THCORE_H
///////////////////////////////////////////////////////////////////////////////////////////////////

#define THERESA_VERSION 0x0004007F

#define THERESA_DEVELOPER_BUILD

#define THERESA_BUFFER_SIZE 2048

#define THERESA_NEWLINE "\r\n"

#define THERESA_WIDTH		320
#define THERESA_HEIGHT	240

#define THERESA_WIDTH_STRING	"320"
#define THERESA_HEIGHT_STRING	"240"

#if defined(_DEBUG)

	#define THERESA_DEBUG_BUILD
	#define THASSERT(expression, message) { while (!(expression)) if (!Assert(#expression, message, __FILE__, __LINE__)) break; }
	#define THDEBUG(x) x

#elif defined(_RELEASE)

	#define THERESA_RELEASE_BUILD
	#define THASSERT(expression, message)
	#define THDEBUG(x) 0

#elif defined(_SMALL)

	#define THERESA_SMALL_BUILD
	#define THASSERT(expression, message)
	#define THDEBUG(x) 0

#else
	#error Somebody set us up the bomb! You have no chance to survive make your time!
#endif

#ifndef interface
	#define interface struct
#endif

#ifndef NULL
	#define NULL 0
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////

// ThMemory ---------------------------------------------------------------------------------------

template <typename T>
class ThPtr;
template <typename T>
class ThRef;
template <typename T>
class ThRefObject;
template <typename T>
class ThBlock;
template <typename T>
class ThListItem;
template <typename T>
class ThItemList;
template <typename T>
class ThHashItem;
template <typename T, unsigned int N>
class ThHashList;
template <typename T>
class ThIterator;
template <typename T>
class ThConstIterator;
template <typename T>
class ThSingleton;

interface IThStaticBlock;
interface IThDynamicBlock;

// ThGeometry -------------------------------------------------------------------------------------

template <typename T>
class ThRange;
template <typename T>
class ThSpace;
class ThVector2;
class ThVector3;
class ThVector4;
class ThMatrix3;
class ThMatrix4;
class ThArea;
class ThSphere;

// ThTimer ----------------------------------------------------------------------------------------

class ThTimer;

// ThString ---------------------------------------------------------------------------------------

class ThString;
class ThStringItem;
class ThStringList;

// ThWindow ---------------------------------------------------------------------------------------

class ThWindow;

// ThDialog ---------------------------------------------------------------------------------------

class ThDialog;

// ThError ----------------------------------------------------------------------------------------

interface IThError;

// ThScript ---------------------------------------------------------------------------------------

class ThToken;

interface IThSymbolTable;
interface IThTokenizer;
interface IThAnalyzer;

// ThStream ---------------------------------------------------------------------------------------

interface IThInputStream;
interface IThOutputStream;
interface IThStream;

// ThChunk ----------------------------------------------------------------------------------------

class ThChunk;

// ThStorage --------------------------------------------------------------------------------------

interface IThStorage;

// ThServer ---------------------------------------------------------------------------------------

class ThMessage;
class ThMessageItem;
class ThServerObject;

interface IThServer;

// ThDisplay --------------------------------------------------------------------------------------

interface IThDisplay;

// ThMusic ----------------------------------------------------------------------------------------

interface IThMusic;

// ThSystem ---------------------------------------------------------------------------------------

interface IThSystem;

// ThEffect ---------------------------------------------------------------------------------------

class ThEffectObject;

interface IThEffect;

///////////////////////////////////////////////////////////////////////////////////////////////////

extern bool TheresaMain(const char* commandLine);

///////////////////////////////////////////////////////////////////////////////////////////////////

void*										AllocateBlock(unsigned int size);
void*										ResizeBlock(void* block, unsigned int size);
void										ReleaseBlock(void* block);

const char*							GetPlatformName(void);

#ifdef THERESA_DEBUG_BUILD
bool										Assert(const char* expression, const char* message, const char* fileName, unsigned int line);
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////

inline void*						operator new (unsigned int size);
inline void*						operator new[] (unsigned int size);
inline void							operator delete (void* block);
inline void							operator delete[] (void* block);

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THCORE_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
