///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <ThCore.h>
#include <ThMemory.h>
#include <ThString.h>
#include <ThWindow.h>

///////////////////////////////////////////////////////////////////////////////////////////////////

// ThWindow constructors --------------------------------------------------------------------------

ThWindow::ThWindow(void)
{
	m_window = NULL;
}

ThWindow::~ThWindow(void)
{
	release();
}

// ThWindow methods -------------------------------------------------------------------------------

bool ThWindow::create(WNDCLASSEX& wcl, DWORD style, DWORD exStyle, HWND parent)
{
	release();

	wcl.lpfnWndProc = windowProc;
	wcl.hInstance   = GetModuleHandle(NULL);

	m_class = RegisterClassEx(&wcl);
	if (!m_class)
		return false;

	m_window = CreateWindowEx(exStyle, wcl.lpszClassName, "", style, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, parent, NULL, GetModuleHandle(NULL), (LPVOID) this);
	if (!m_window)
	{
		release();
		return false;
	}

	return true;
}

void ThWindow::attach(HWND window)
{
	m_window = window;
}

void ThWindow::release(void)
{
	if (m_window)
	{
		DestroyWindow(m_window);
		m_window = NULL;
	}

	if (m_class)
	{
		UnregisterClass(MAKEINTATOM(m_class), GetModuleHandle(NULL));
		m_class = 0;
	}
}

void ThWindow::show(void)
{
	if (!m_window)
		return;

	ShowWindow(m_window, SW_SHOW);
	UpdateWindow(m_window);
}

void ThWindow::hide(void)
{
	if (!m_window)
		return;

	ShowWindow(m_window, SW_HIDE);
}

// ThWindow attributes ----------------------------------------------------------------------------

bool ThWindow::isCreated(void) const
{
	return m_window != NULL;
}

bool ThWindow::isVisible(void) const
{
	if (!m_window)
		return false;

	return IsWindowVisible(m_window) ? true : false;
}

HWND ThWindow::getHandle(void) const
{
	return m_window;
}

bool ThWindow::getTitle(ThString& title) const
{
	if (!m_window)
		return false;

	int length = GetWindowTextLength(m_window);

	title.allocate(length + 1);

	if (length)
	{
		if (!GetWindowText(m_window, title, title.getSize()))
			return false;
	}

	return true;
}

void ThWindow::setTitle(const char* title)
{
	if (!m_window)
		return;

	SetWindowText(m_window, title);
}

// ThWindow static methods ------------------------------------------------------------------------

bool ThWindow::update(bool wait)
{
	MSG msg;

	bool result = true;

	while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
	{
		if (msg.message == WM_QUIT)
			result = false;

		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return result;
}

// ThWindow callbacks -----------------------------------------------------------------------------

LRESULT ThWindow::create(CREATESTRUCT& cs)
{
	return 0;
}

LRESULT ThWindow::command(HWND control, WORD identifier, BOOL accel)
{
	return 0;
}

LRESULT ThWindow::message(UINT message, WPARAM wParam, LPARAM lParam)
{
	return DefWindowProc(m_window, message, wParam, lParam);
}

// ThWindow static methods ------------------------------------------------------------------------

LRESULT CALLBACK ThWindow::windowProc(HWND window, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_CREATE:
		{
			CREATESTRUCT* cs = (CREATESTRUCT*) lParam;

			SetWindowLongPtr(window, GWLP_USERDATA, (LONG_PTR) cs->lpCreateParams);

			if (ThWindow* object = (ThWindow*) GetWindowLongPtr(window, GWLP_USERDATA))
				return object->create(*cs);

			break;
		}

		case WM_COMMAND:
		{
			if (ThWindow* object = (ThWindow*) GetWindowLongPtr(window, GWLP_USERDATA))
				return object->command((HWND) lParam, LOWORD(wParam), HIWORD(wParam));

			break;
		}

		default:
		{
			if (ThWindow* object = (ThWindow*) GetWindowLongPtr(window, GWLP_USERDATA))
				return object->message(message, wParam, lParam);

			break;
		}
	}

	return DefWindowProc(window, message, wParam, lParam);
}

///////////////////////////////////////////////////////////////////////////////////////////////////
