///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THSYSTEM_H
#define THERESA_THSYSTEM_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThSystem : public IThSystem, public ThServerObject
{
public:
// constructors
																		ThSystem(void);
																		~ThSystem(void);
// methods
	bool															open(void);
	void															close(void);
// interface methods
	bool															start(void);
	void															stop(void);
	void															pause(void);
	void															resume(void);
// interface display methods
	bool															openDisplay(unsigned int width, unsigned int height);
	void															closeDisplay(void);
// interface music methods
	bool															openMusic(const char* fileName);
	void															closeMusic(void);
// interface attributes
	bool															isStarted(void);
	bool															isPaused(void);
	float															getTotalTime(void);
	float															getDeltaTime(void);
	void															setTotalTime(float time);
	IThDisplay*												getDisplay(void);
	IThMusic*													getMusic(void);
private:
// callbacks
	bool															recieve(ThMessage* message);
// data
	bool															m_stopped;
	ThTimer														m_timer;
	float															m_currTime;
	float															m_prevTime;
	ThPtr<IThDisplay>									m_display;
	ThPtr<IThMusic>										m_music;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /*THERESA_THSYSTEM_H*/
///////////////////////////////////////////////////////////////////////////////////////////////////
