///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THSTREAM_H
#define THERESA_THSTREAM_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThDynamicBlockStream : public IThStream, public IThDynamicBlock
{
public:
// constructors
																		ThDynamicBlockStream(unsigned int size);
	virtual														~ThDynamicBlockStream(void);
// methods
	virtual unsigned int							read(void* data, unsigned int size);
	virtual unsigned int							write(const void* data, unsigned int size);
	virtual unsigned int							skip(unsigned int size);
	virtual bool											seek(unsigned int position);
	virtual bool											truncate(void);
	virtual void*											lock(void);
	virtual void											unlock(void);
	virtual void											allocate(unsigned int size);
	virtual void											resize(unsigned int size);
	virtual void											release(void);
// attributes
	virtual bool											isEOF(void) const;
	virtual unsigned int							getSize(void) const;
	virtual unsigned int							getPosition(void) const;
private:
// data
	ThByteBlock												m_data;
	unsigned int											m_locks;
	unsigned int											m_size;
	unsigned int											m_position;
};

//-------------------------------------------------------------------------------------------------

class ThAggregateStream : public IThStream
{
public:
// constructors
																		ThAggregateStream(IThStream* inner);
	virtual														~ThAggregateStream(void);
// methods
	virtual unsigned int							read(void* data, unsigned int size);
	virtual unsigned int							write(const void* data, unsigned int size);
	virtual unsigned int							skip(unsigned int size);
	virtual bool											seek(unsigned int position);
	virtual bool											truncate(void);
// attributes
	virtual bool											isEOF(void) const;
	virtual unsigned int							getSize(void) const;
	virtual unsigned int							getPosition(void) const;
private:
// data
	IThStream*												m_inner;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_THSTREAM_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
