///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <ThCore.h>
#include <ThMemory.h>
#include <ThError.h>
#include <ThStorage.h>
#include <ThServer.h>
#include <ThSystem.h>
#include <ThEffect.h>
#include <ThSetup.h>

#include "ThSetup.h"

#include <windows.h>

///////////////////////////////////////////////////////////////////////////////////////////////////

// IThSetup constructors --------------------------------------------------------------------------

IThSetup::~IThSetup(void)
{
}

// IThSetup static methods ------------------------------------------------------------------------

IThSetup* IThSetup::createInstance(void)
{
	ThPtr<ThSetup> object = new ThSetup();

	if (!object->open())
		return false;

	return object.detach();
}

///////////////////////////////////////////////////////////////////////////////////////////////////

// ThSetup constructors ---------------------------------------------------------------------------

ThSetup::ThSetup(void)
{
}

ThSetup::~ThSetup(void)
{
	close();
}

// ThSetup methods --------------------------------------------------------------------------------

bool ThSetup::open(void)
{
	close();

	if (!IThError::create())
	{
		MessageBox(NULL, "Unable to create error object", "Theresa", MB_OK | MB_ICONERROR);
		return false;
	}

	if (!IThStorage::create())
	{
		Error->display("Setup", "Unable to create storage object.");
		return false;
	}

	if (!IThServer::create())
	{
		Error->display("Setup", "Unable to create server object.");
		return false;
	}

	if (!IThSystem::create())
	{
		Error->display("Setup", "Unable to create system object.");
		return false;
	}

	if (!IThEffect::create())
	{
		Error->display("Setup", "Unable to create effect object.");
		return false;
	}

	return true;
}

void ThSetup::close(void)
{
	if (Effect)
		Effect.release();

	if (System)
		System.release();

	if (Server)
		Server.release();

	if (Storage)
		Storage.release();

	if (Error)
		Error.release();
}

// ThSetup interface methods ----------------------------------------------------------------------

int ThSetup::run(const char* commandLine)
{
	TheresaMain(commandLine);

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain(HINSTANCE instance, HINSTANCE prevInstance, LPSTR commandLine, int cmdShow)
{
	if (ThPtr<IThSetup> object = IThSetup::createInstance())
		return object->run(commandLine);

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
