///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THMUSIC_H
#define THERESA_THMUSIC_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThMusicWindow : public ThWindow
{
public:
// constructors
																		ThMusicWindow(UINT message);
// methods
	bool															create(void);
private:
// callbacks
	LRESULT														message(UINT message, WPARAM wParam, LPARAM lParam);
// data
	UINT															m_message;
};

//-------------------------------------------------------------------------------------------------

class ThMusic : public IThMusic, public ThServerObject
{
public:
// constructors
																		ThMusic(void);
																		~ThMusic(void);
// methods
	bool															open(IThInputStream* source);
	void															close(void);
// interface methods
	void															start(void);
	void															stop(void);
	void															pause(void);
	void															resume(void);
// interface attributes
	bool															isStarted(void) const;
	bool															isPaused(void) const;
	float															getTime(void) const;
	bool															setTime(float time);
private:
// classes
	class Object;
// callbacks
	bool															recieve(ThMessage* message);
// static methods
	static LRESULT CALLBACK						windowProc(HWND window, UINT message, WPARAM wParam, LPARAM lParam);
// data
	bool															m_started;
	bool															m_paused;
	ThByteBlock												m_buffer;
	ThPtr<ThMusicWindow>							m_window;
	HMUSIC														m_music;
	HSTREAM														m_stream;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_THMUSIC_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
