//===================================================================================
//FILE : vertex.vsh
//DESC : per-pixel lighting setup
//PROJ : Inercia 2k2 demo
//CODER: Tiago Sousa
//==================================================================================

// Registers

//  c4-7   		 = WorldViewProj matrix
//  c8-11   		 = WorldTransposed matrix

//  c16                  = LightPosition in object space
//  c17                  = CamPosition in object space

//  v0	 		 = vertex position
//  v7 	 	         = texture coordinates (2d)
//  v8 	 		 = normal vector
//  v9 	 		 = tangent vector

vs.1.1             

// projected vertex position
m4x4 oPos, v0, c4

// light position - vertex position (light vector)
add r0.xyz, c16.xyz, -v0.xyz

// camera position - vertex position
add r1.xyz, c17.xyz, -v0.xyz

// compute half vector
add r1.xyz, r1.xyz, r0.xyz

// transform light vector to tangent space
//dp3 oT1.x, r0.xyz, v9.xyz        // LdotTangent
//dp3 oT1.y, r0.xyz, v10.xyz       // LdotBinormal
//dp3 oT1.z, r0.xyz, v8.xyz        // LdotNormal

dp3 r2.x, r0.xyz, v9.xyz        // LdotTangent
dp3 r2.y, r0.xyz, v10.xyz       // LdotBinormal
dp3 r2.z, r0.xyz, v8.xyz        // LdotNormal

mov oT1.xyz, r2.xyz

// normalize result light vector
dp3 r3.x, r2.xyz, r2.xyz
rsq r3.x, r3.x
mul r2.xyz, r2.xyz, r3.x
// save self-shadowing term in diffuse component
mov oD0.xyzw, r2.z

// transform half vector to tangent space
dp3 oT2.x, r1.xyz, v9.xyz        // HdotTangent
dp3 oT2.y, r1.xyz, v10.xyz       // HdotBinormal
dp3 oT2.z, r1.xyz, v8.xyz        // HdotNormal

mov  oT0.xy, v7.xy		// copy texture coordinates
mov  oT3.xy, v7.xy		// copy texture coordinates

/////////////////////////////////////////////////////////////////////////////