// Persistence of Vision Ray Tracer Scene Description File
// File: forest.pov
// Vers: 3.5
// Desc: Aokromes' Clone Forest
// Date: 19/07/2002
// Auth: Arnau Rossell Castell
//
#version 3.5;
#include "colors.inc"
#include "skies.inc"

global_settings{assumed_gamma 1.0}
#declare Boleo=seed(1);
#declare Arbre=
union
{
	cylinder{<0,0,0>,<0,3,0>,.2 pigment{Brown}}
	union
	{
		cone{<0,-1,0>,2  ,<0,2,0>, 0 rotate< 6,  0,0>translate<0,3,0>}
		cone{<0,-1,0>,1.6,<0,2,0>, 0 rotate<10,180,0>translate<0,5,0>}
		cone{<0,-1,0>,1.3,<0,1,0>, 0 rotate< 3,  0,0>translate<0,7,0>}
		pigment{ForestGreen}
	}
}

#macro Bosc(Clonar,Superficie,Separacio,TamanyX,TamanyZ)
	union
	{
		#local X=-(TamanyX/2);
		#local bot=0;
		#while(X<(TamanyX/2))
			#local Z=-(TamanyZ/2);
			#while(Z<(TamanyZ/2))
				object{Clonar translate trace(Superficie,<X+rand(Boleo)*4,1000,Z+bot+rand(Boleo)*4>,<0,-1,0>)}
				#local Z=Z+Separacio;
			#end
			#local X=X+Separacio;
			#if(bot=0)
				#local bot=Separacio/2;
			#else
				#local bot=0;
			#end
		#end
	}
#end

#declare Terreno=
height_field
{
	function 500,500
	{
		pattern
		{
			dents
			scale .08
			turbulence .25
		}
    }
	smooth
	translate<-.5,0,-.5>
	scale<600,30,600>
}

camera
{
	location  <300,31,300>
	direction 1.5*z	right     x*image_width/image_height
	look_at   <0,-50,0>
}
light_source{<3000, 3000, 3000> 1}

object{Terreno pigment{Tan}}


object{Bosc(Arbre,Terreno,6,600,600)}





plane {<.2,-1,0>,-70000
	texture
	{
	    pigment
	    {
	    	bozo
    		color_map
    		{
	    		[0.0 color <1,1,1>]
    			[0.3 color <.8,.8,.8>]
    			[1.0 color SkyBlue]
	    	}
    		scale 9000
    		scale 20*x
	    }
	    finish{ambient 1}
	}
	
}

// create a TrueType text shape
text {
  ttf             // font type (only TrueType format for now)
  "crystal.ttf",  // Microsoft Windows-format TrueType font file name
  "Aokromes' Clone Forest",      // the string to create
  .002,              // the extrusion depth
  0               // inter-character spacing
  
  scale 15
  rotate<90,0,90>
  rotate<-90,0,0>
  rotate <0,135,0>
  translate<200,40,80>
  
  no_shadow
}
