/*
    main.c

    base para los fast_code.

    soporta modos de cualquier bpp. soporta tambin modos de paleta
    (emulado sobre 32bpp).


    iq + una-i
*/

#include <conio.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>

#include "gfx.h"
#include "timer.h"
#include "ffx.h"

extern int xres;
extern int yres;
extern int  bpp;



//------ emulacion de 8 a 32-------------------

static long coltable[256];
static void convert8to32( long *dst, unsigned char *ori )
{
    int i;

    for( i=0; i<(xres*yres); i++ )
        *dst++ = coltable[*ori++];
}

void set_palette( long *palette )
{
    int i;

    if( palette )
        {
        memcpy( coltable, palette, 256*4 );
        }
    else
        {
        for( i=0; i<256; i++ )
            coltable[i] = 0xff000000|(i<<16)|(i<<8)|i;
        }
}

void set_color( int i, int r, int g, int b )
{
    coltable[i] = 0xff000000|(r<<16)|(g<<8)|b;
}


//------ emulacion de 8 a 32-------------------

void main( void )
{
    void            *buffer;
    long            to;
    float           t;
    long            amount;
    long            *aux;



    if( bpp==8 )
        {
        set_palette( 0 );
        aux    = (long*)malloc( xres*yres*4 );
        buffer = (void*)malloc( xres*yres );
        if( !aux | !buffer )
            return;
        memset( aux,    0, xres*yres*4 );
        memset( buffer, 0, xres*yres*1 );
        if( !gfx_init(xres, yres, 32 ) )
            return;
        gfx_dump( aux, xres*yres*4 );
        }
    else
        {
        buffer = (void*)malloc( xres*yres*bpp>>3 );
        if( !buffer )
            return;
        if( !gfx_init(xres, yres, bpp ) )
            return;
        memset( buffer, 0, xres*yres*bpp>>3 );
        gfx_dump( buffer, xres*yres*bpp>>3 );
        }


    if( !FFX_Init(buffer) )
        {
        gfx_done();
        return;
        }
 



    TIMER_Init();

    to = TIMER_GetTimer();

    while( !kbhit() )
        {
        t = (TIMER_GetTimer()-to)/200.0;

        FFX_DoFrame( buffer, t );

        if( bpp==8 )
            {
            convert8to32( aux, buffer );
            gfx_dump( aux, xres*yres*4 );
            }
        else
            {
            gfx_dump( buffer, xres*yres*bpp>>3 );
            }
        }

    getch();

    TIMER_End();
    FFX_End();

    gfx_done();
}
