' Vrat qbasic demo
'
' Fr Birdie
'
' Av Jsr och Warlock
'
'

DEFINT A-Z

DECLARE SUB Delay (milliseconds AS DOUBLE)
DECLARE SUB CheckExit ()
DECLARE SUB MoveDots ()

CONST MinY = 2
CONST MaxY = 24
CONST MaxBlocks = 128
CONST MaxLength = 10

CONST MaxDots = 50

TYPE DotType
    x AS SINGLE
    y AS SINGLE
    speed AS SINGLE
    gravity AS SINGLE
    ydir AS INTEGER
    startgravity AS SINGLE
    startspeed AS SINGLE
    DnSpd AS SINGLE
    LastX AS SINGLE
    LastY AS SINGLE
    clr AS INTEGER
END TYPE

DIM SHARED Dots(MaxDots) AS DotType

DIM Blocks(MaxBlocks, MaxLength) AS STRING

DIM BPos(MaxBlocks) AS SINGLE   'Position
DIM BSpd(MaxBlocks) AS SINGLE   'Hastighet
DIM BLen(MaxBlocks) AS SINGLE   'Lngd
DIM BCol(MaxBlocks) AS SINGLE   'X Position

DIM DropDown(50, 3) AS INTEGER
DIM titletext AS STRING

DIM GetBox(8 * 200) AS INTEGER

DIM addx(4)     AS DOUBLE
DIM addy(4)     AS DOUBLE

DIM x1(3)       AS DOUBLE
DIM y1(3)       AS DOUBLE

DIM SineTable(360)  AS DOUBLE
DIM Costable(360)  AS DOUBLE

DIM d             AS DOUBLE

DIM ScrollX     AS LONG

DIM ScrollText  AS STRING

RANDOMIZE 128

titletext = "A QBasic Demo"

ScrollText = "                             "
ScrollText = ScrollText + "QBasic can't do all I want it to..."
ScrollText = ScrollText + " But still a demo was created, maybe not the greatest ever."
ScrollText = ScrollText + " But still a fairly good one... I hope  *smile*"
ScrollText = ScrollText + " And now what? There is still time left and so little to write about."
ScrollText = ScrollText + " Humm, maybe some credits"
ScrollText = ScrollText + " would be in place - Credits: This was created by Jsr and Warlock,"
ScrollText = ScrollText + " with inspiration from the rest of the sceners at Birdie."
ScrollText = ScrollText + " A hello to our friends, and all NESdevers and rom|hackers out there!"

FOR x = 0 TO 360

    SineTable(x) = SIN(x * (3.141593 / 180))
    Costable(x) = COS(x * (3.141593 / 180))

NEXT x

FOR x = 1 TO MaxDots

    Dots(x).speed = RND
    Dots(x).gravity = RND * 4
    Dots(x).ydir = 1
    Dots(x).startgravity = Dots(x).gravity
    Dots(x).startspeed = Dots(x).speed

    Dots(x).clr = 15'INT(RND * 15) + 15

NEXT x

SCREEN 7

FOR x = 1 TO LEN(titletext)

    LOCATE 3, 10 + x: PRINT MID$(titletext, x, 1)

    IF (DropDown(x, 1) = 0) THEN DropDown(x, 2) = (8 * 2) - 1
    DropDown(x, 1) = 1

    FOR t = 1 TO LEN(titletext)
        IF DropDown(t, 1) = 1 THEN

            IF DropDown(t, 2) < (5 * 8) THEN
           
                GET ((t + 9) * 8, DropDown(t, 2))-((t + 9) * 8 + 8, DropDown(t, 2) + 8), GetBox
                DropDown(t, 2) = DropDown(t, 2) + 1
                PUT ((t + 9) * 8, DropDown(t, 2)), GetBox, PSET

            END IF

        END IF
    NEXT t

    Delay 10

NEXT x

DO

    done = 1

    FOR t = 1 TO LEN(titletext)
        IF DropDown(t, 1) = 1 THEN

            IF DropDown(t, 2) < (5 * 8) THEN
          
                GET ((t + 9) * 8, DropDown(t, 2))-((t + 9) * 8 + 8, DropDown(t, 2) + 8), GetBox
                DropDown(t, 2) = DropDown(t, 2) + 1
                PUT ((t + 9) * 8, DropDown(t, 2)), GetBox, PSET
                done = 0

            END IF

        END IF
    NEXT t

    Delay 10

LOOP UNTIL done

FOR t = 0 TO 320

    PSET (t, 100), 15
    PSET (320 - t, 101), 7
    FOR d = 0 TO 1000: NEXT d
    WAIT &H3DA, 8

NEXT t

Delay 1000

FOR x = 0 TO 360

    LINE (0, 75 * SIN(x * (3.14 / 180)) + 98)-(320, 75 * SIN(x * (3.14 / 180)) + 98), 0
    LINE (0, 75 * SIN(x * (3.14 / 180)) + 99)-(320, 75 * SIN(x * (3.14 / 180)) + 99), 0
    LINE (0, 75 * SIN(x * (3.14 / 180)) + 100)-(320, 75 * SIN(x * (3.14 / 180)) + 100), 15
    LINE (0, 75 * SIN(x * (3.14 / 180)) + 101)-(320, 75 * SIN(x * (3.14 / 180)) + 101), 0
    LINE (0, 75 * SIN(x * (3.14 / 180)) + 102)-(320, 75 * SIN(x * (3.14 / 180)) + 102), 0
    FOR d = 0 TO 1000: NEXT d
    WAIT &H3DA, 8

NEXT x

x1(0) = 5: x1(1) = 5: x1(2) = 15
y1(0) = 15: y1(1) = 5: y1(2) = 5

FOR x = 0 TO 3

    addx(x) = ((RND * 1000) / 100) / 4
    addy(x) = ((RND * 1000) / 100) / 4

    x1(x) = x1(x) * 5
    y1(x) = y1(x) * 5

NEXT x

cycleColor = 1
cycleColorCnt = 0

sine1 = 0
sine2 = 20
sine3 = 40

SCREEN , , 0, 1

div = 0
ScrollPos = 1

Fps = 0

CLS
        GET (38 * 8, 0)-(38 * 8 + 8, 8 * 20), GetBox

DO

    div = div + 1

    IF div > 8 THEN
        div = 0
        ScrollPos = ScrollPos + 1

        FOR x = 20 TO 1 STEP -1
            IF ScrollPos > x THEN

                LOCATE (x), 39: PRINT MID$(ScrollText, x + ScrollPos, 1)

            END IF
        NEXT x

        GET (38 * 8, 0)-(38 * 8 + 8, 8 * 20), GetBox

    END IF

    PUT (38 * 8, (8 - div)), GetBox, PSET

    LOCATE 21, 39: PRINT " "
    LOCATE 1, 39: PRINT " "

    'LOCATE 1, 39: PRINT MID$(scrolltext, scrollpos, 1)

    LINE (291, 0)-(291, 200), 1

    LINE (x1(0), y1(0))-(x1(1), y1(1)), cycleColor
    LINE (x1(1), y1(1))-(x1(2), y1(2)), cycleColor
    LINE (x1(2), y1(2))-(x1(0), y1(0)), cycleColor

    'LOCATE 10, 10: PRINT "Fps: " + STR$(lastfps)

    cycleColorCnt = cycleColorCnt + 1
    IF cycleColorCnt > 20 THEN

        'cycleColor = cycleColor + 1
        IF cycleColor = 15 THEN cycleColor = 7 ELSE cycleColor = 15
        cycleColorCnt = 0

    END IF

    sine1 = sine1 + 1
    IF sine1 > 360 THEN sine1 = 0

    sine2 = sine2 + 1
    IF sine2 > 360 THEN sine2 = 0

    sine3 = sine3 + 1
    IF sine3 > 360 THEN sine3 = 0

    LINE (0, 40 * SineTable(sine1) + 99)-(290, 40 * SineTable(sine1) + 99), 4
    LINE (0, 40 * SineTable(sine1) + 100)-(290, 40 * SineTable(sine1) + 100), 12
    LINE (0, 40 * SineTable(sine1) + 101)-(290, 40 * SineTable(sine1) + 101), 4
   
    LINE (0, 40 * SineTable(sine2) + 99)-(290, 40 * SineTable(sine2) + 99), 1
    LINE (0, 40 * SineTable(sine2) + 100)-(290, 40 * SineTable(sine2) + 100), 9
    LINE (0, 40 * SineTable(sine2) + 101)-(290, 40 * SineTable(sine2) + 101), 1

    LINE (0, 40 * SineTable(sine3) + 99)-(290, 40 * SineTable(sine3) + 99), 2
    LINE (0, 40 * SineTable(sine3) + 100)-(290, 40 * SineTable(sine3) + 100), 10
    LINE (0, 40 * SineTable(sine3) + 101)-(290, 40 * SineTable(sine3) + 101), 2
    
    MoveDots

    FOR x = 0 TO 3

        y1(x) = y1(x) + addy(x)
        x1(x) = x1(x) + addx(x)

        IF (y1(x) > 190) OR (y1(x) < 1) THEN addy(x) = -addy(x)
        IF (x1(x) > 290) OR (x1(x) < 1) THEN addx(x) = -addx(x)

    NEXT x
   
    'Fps = Fps + 1
    'IF TIMER > lastTimer THEN
    '
    '    lastTimer = TIMER + 1
    '    lastfps = Fps
    '    Fps = 0
    '
    'END IF

    PCOPY 0, 1
   
    A$ = INKEY$
    IF A$ = CHR$(27) THEN GOTO EndDemo
    IF ScrollPos > LEN(ScrollText) + 10 THEN GOTO EndDemo
   
    CLS

    WAIT &H3DA, 8

LOOP

EndDemo:
          
SCREEN , , 0, 0

FOR x = 0 TO 100

    LINE (0, x)-(320, x), 0
    LINE (0, (200 - x))-(320, (200 - x)), 0
    FOR d = 0 TO 5000: NEXT d
    WAIT &H3DA, 8

NEXT x

SCREEN 8
SCREEN 0

SUB CheckExit

    A$ = INKEY$

    IF A$ <> "" THEN

        SCREEN 8
        SCREEN 0
        END

    END IF

END SUB

DEFSNG A-Z
SUB Delay (milliseconds AS DOUBLE)

    DIM EndTime AS DOUBLE

    EndTime = TIMER + (milliseconds / 1000)

    WHILE EndTime >= TIMER
    WEND

END SUB

DEFINT A-Z
SUB MoveDots

    FOR x = 0 TO MaxDots

        Dots(x).DnSpd = Dots(x).DnSpd + (Dots(x).gravity / 200)
        Dots(x).y = Dots(x).y + Dots(x).DnSpd

        Dots(x).x = Dots(x).x + Dots(x).speed
        Dots(x).speed = Dots(x).speed - (Dots(x).speed / 100000)

        IF (Dots(x).x > 290) THEN Dots(x).speed = -Dots(x).speed
        IF (Dots(x).x < 0) THEN Dots(x).speed = -Dots(x).speed

        IF (Dots(x).y > 200) THEN

            Dots(x).gravity = Dots(x).gravity + Dots(x).gravity
            Dots(x).DnSpd = -Dots(x).DnSpd

        END IF

        IF (Dots(x).y < 0) THEN
            Dots(x).gravity = Dots(g).gravity + Dots(g).gravity
            Dots(x).DnSpd = -Dots(x).DnSpd
        END IF

        IF (Dots(x).gravity > 3.9) THEN
            Dots(x).gravity = Dots(x).startgravity
           
            Dots(x).speed = Dots(x).speed + Dots(x).startspeed

            'Dots(x).speed = -Dots(x).speed

            Dots(x).LastX = Dots(x).x
            Dots(x).LastY = Dots(x).y

        END IF

        PSET (Dots(x).x, Dots(x).y), Dots(x).clr

    NEXT x

END SUB

