// This program duplicates its input and appends the copies together
// with a given offset. An extra delay may be inserted before the
// first copy. The copies may overlap each other.

// The calculations are done in RAM, and the buffers may be very
// large, up to the full length of the produced work.

// The program operates with stereophonic WAV files. Use REPEATM program
// for monophonic files.

#include <stdio.h>
#include <memory.h>



int main (int argc, char *argv []) {

  FILE   *src,       // Input file
         *tgt;       // Output file
  short  *sbuf,      // Input buffer
         *tbuf;      // Output buffer
  long   i,
         bc,         // Output byte count
         sc,         // Input sample count
         rc,         // Repeat count
         c,          // Output sample count
         offs,       // Interval of the repetitions (sample count)
         silence;    // Number of silent samples in the preamble
  short  zero;       // Zero element stored in memory to create silence
  char   hdr [44];   // WAV file buffer

  if (argc < 6) {
    printf ("Use: repeat <infile> <outfile> <sampleoffset> <silence> "
            "<repeatcount>\n");
    return (1); }

  src = fopen (argv [1], "rb");
  if (src == NULL) {
    printf ("Cannot open input file '%s'\n", argv [1]);
    return (2); }

  tgt = fopen (argv [2], "wb");
  if (tgt == NULL) {
    printf ("Cannot open output file '%s'\n", argv [2]);
    return (3); }

  sscanf (argv [3], "%ld\n", &offs);    offs    *= 2L;   /* Stereo */
  sscanf (argv [4], "%ld\n", &silence); silence *= 2L;   /* Stereo */
  sscanf (argv [5], "%ld\n", &rc);

  zero = 0;

  fread (hdr, 44, 1, src);

  memcpy (&sc, hdr + 40L, sizeof (long));
  sc /= sizeof (short);   /* Stereo */

  sbuf = malloc (sc * sizeof (short));
  tbuf = malloc (((rc - 1L) * offs + sc) * sizeof (short));

  for (i = ((rc - 1L) * offs + sc - 1L) ; i >= 0L ; i--) tbuf [i] = 0;
  for (i = 0 ; i < sc ; i++) {
    fread (sbuf + i, sizeof (short), 1, src);
    sbuf [i] = (short) (4L * (long) (sbuf [i]) / 5L); }

  for (c = 0 ; c < rc ; c++) {
    for (i = 0 ; i < sc ; i++) tbuf [c * offs + i] += sbuf [i]; }

  c = (rc - 1) * offs + sc;

  fwrite (hdr, 1, 4, tgt);
  bc = c * sizeof (short);            /* Stereo included */
  bc += (silence * sizeof (short));   /* Stereo included */
  bc += 36L;
  fwrite (&bc, 1, 4, tgt);
  fwrite (hdr + 8L, 1, 32, tgt);
  bc -= 36L;
  fwrite (&bc, 1, 4, tgt);

  for (i = 0 ; i < silence ; i++) fwrite (&zero, sizeof (short), 1, tgt);

  for (i = 0 ; i < c ; i++) fwrite (tbuf + i, sizeof (short), 1, tgt);

  free (tbuf);
  free (sbuf);

  fclose (tgt);
  fclose (src);

  return (0); }
