#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "textures.inc"
#include "woods.inc"

camera {
 location <22,13,12>
 look_at <4,0,2>
} 

//taivas

sky_sphere {
 pigment {
  bozo
  turbulence 0.5
  pigment_map {
   [0 rgb <0,0,0>]
   [1 rgb <0,0,0.2>]
  }
 }
}

//seint 

#declare puu_text =
 texture {
  pigment {
   wood
   turbulence 0.1
   pigment_map {
    [0 rgb <0.4,0.2,0.2>]
    [0.3 DarkBrown]
    [1 VeryDarkBrown]
   }
  }
  normal {
   wood 0.75
   turbulence 0.1
  }
 }

union {
 difference {
  union {
   #declare korkeus = -9;
   #while (korkeus < 40)
    object {
     Disk_Z
     scale <5,5,100>
     translate <-25,korkeus,0>
    }
    #declare korkeus = korkeus + 9;
   #end
  }
  object { //ikkuna-aukko
   Cube
   scale 10
   translate <-25,10,-2>
  }
  texture {
   puu_text
  }
 }
 #declare korkeus = -4.5;
 #while (korkeus < 40)
  object {
   Disk_X
   scale <50,5,5>
   translate <0,korkeus,-30>
   texture {
    puu_text
    rotate <0,-90,0>
   }
  }
  #declare korkeus = korkeus + 9;
 #end 
}

//ikkuna

#declare lauta_text =
 texture {
  pigment {
   wood
   scale <1,2,1>
   turbulence 0.1
   pigment_map {
    [0 rgb <0.4,0.2,0.2>]
    [0.3 Tan]
    [1 DarkBrown]
   }
  }
  normal {
   wood 0.75
   scale <1,2,1>
   turbulence 0.1
  } 
  finish {
   reflection 0.01
   specular 0.05
   roughness 0.01
  }
 }
 
#declare lauta =
 object {
  Cube
  scale <2,20,0.5>
  translate <-25,0,0>
  texture {
   lauta_text
  }
 }
 
#declare lauta2 =
 object {
  Cube
  scale <1,20,0.5>
  translate <-25,0,0>
  texture {
   lauta_text
  }
 }

object {
 lauta
 translate <0,10,-11.5>
}

object {
 lauta
 translate <0,10,7.5>
}

object {
 lauta
 rotate <90,0,0>
 translate <0,0.5,0>
}

object {
 lauta2
 translate <0,10,-2>
}

object {
 lauta2
 rotate <90,0,0>
 translate <0,10,0>
}
 
object {
 Cube
 scale <0.2,10,10>
 translate <-25,10,-2>
 texture {
  Glass
  normal {
   bozo 0.2
   scale <2,3,2>
   turbulence 0.3
  }
 }
}

//pyt

#declare p_norm1 =
 normal {
  wood 0.1
  turbulence 0.5
  scale <0.5,0.5,8> 
 }

#declare p_norm2 =
 normal {
  wood 0.1
  turbulence 0.1
  scale <3,3,10>
 }
 
object {
 Cube
 scale <17,10,19>
 translate <1,-12,0>
 texture {
  T_Wood4
  scale 10
  normal {
   average
   normal_map {
    [1 p_norm1]
    [0.5 p_norm2]
   }
  }
  finish {
   reflection 0.2
   specular 0.2
   roughness 0.05
  }
 }
}

//vasara

difference { //"ter"
 object {
  Cube
  scale <4,2.2,2>
 }
 union {
  object {
   Disk_Y
   scale 3
   translate <0,0,3>
  }
  difference {
   object {
    Disk_Y
    scale 3
   }
   object {
    Cube
    scale <4,2,2>
   }
  }
  #declare lovetus =
   union {
    object {
     Cube
     scale <2,2,3>
     rotate <0,0,45>
     translate <0,-1,0>
    }
    object {
     Cube
     scale <2,2,3>
     rotate <0,0,45>
    }
    object {
     Cube
     scale <2,2,3>
     rotate <0,0,45>
     translate <0,1,0>
    }
   }
  object {
   lovetus
   translate <6.25,0,0>
  }
  object {
   lovetus
   rotate <90,0,0>
   translate <6.25,0,0>
  }
  object {
   lovetus
   translate <-6.25,0,0>
  }
  object {
   lovetus
   rotate <90,0,0>
   translate <-6.25,0,0>
  }
  union { // H
   object {
    Cube
    scale <0.1,0.3,0.75>
    translate <0.5,2,-1>
   }
   object {
    Cube
    scale <0.1,0.3,0.75>
    translate <-0.5,2,-1>
   }
   object {
    Cube
    scale <0.75,0.3,0.1>
    translate <0,2,-1>
   }
  }
 }
 texture {
  pigment {
   color Copper
  }
  finish {
   reflection 0.3
   specular 0.1
   roughness 0.1
   metallic
  }
  normal {
   bozo
   scale <0.6,0.3,0.3>
   turbulence 0.2
  }
 }
}
  
union { //varsi
 lathe {
  cubic_spline
  17,           
  <1,0>,          
  <1,0>,          
  <1,8>,        
  <0.8,8.5>,        
  <1,9>,        
  <0.8,9.5>,        
  <1,10>         
  <0.8,10.5>,       
  <1,11>,       
  <0.8,11.5>,       
  <1,12>,       
  <0.8,12.5>,       
  <1,13>,       
  <1.5,13.5>,       
  <1.5,14.5>,       
  <0.5,15>,
  <0,15>        
  rotate <90,0,0>
 }
 #declare kahvan_piikki =
  object {
   Cone_X
   scale 0.9
   translate <1.5,0,14>
   pigment { Silver }
   finish {
    metallic
    specular 0.5
    roughness 0.2
    reflection 0.3
   }
  }
 #declare laskuri = 4;
 #while (laskuri > -1)
  object {
   kahvan_piikki
   rotate <0,0,laskuri * 72>
  }
  #declare laskuri = laskuri - 1;
 #end
 #declare liitos =
  #declare pikku_piikki =
   object {
    kahvan_piikki
    scale 0.75
    translate <0,0,-10>
   }
  #declare laskuri = 4;
  #while (laskuri > -1)
   object {
    pikku_piikki
    rotate <0,0,laskuri * 72>
   }
   #declare laskuri = laskuri - 1;
  #end
 liitos
 pigment {
  bozo
  turbulence 0.5
  color_map { 
   [0 color Silver]
   [0.8 color Silver]
   [1 color rgb <0.80,0.81,0.88>]
  }
 }
 finish {
  reflection 0.2
  specular 0.5
  roughness 0.02
  metallic
 }
 normal {
  dents
  scale <0.1,0.1,3>
  turbulence 0.3
 }
} 

//kynttilt

#declare tikku_valo =
 union {
  difference { //itse osuus
   object {
    Disk_Y
    scale <1,3,1>
    translate <0,2,0>
   }
   object {
    Sphere
    scale 2
    translate <0.4,6.5,0>
   }
   pigment {
    bozo
    turbulence 0.1
    color_map {
     [0 color rgbt <0.9,0.9,1,0.05>]
     [1 color rgbt <1,1,0.9,0.05>]
    }
   }
   normal {
    bozo
    turbulence 0.3
    scale <0.3,1,0.3>
   }
  }
  lathe { //jalka
   cubic_spline
   8,
   <2,0>,
   <2,0>,
   <1.8,0.5>,
   <1,1>,
   <1.2,1.2>,
   <1,1.4>,
   <1.5,2>,
   <1.5,2>
   translate <0,-2,0>
   pigment { Gold }
   finish {
    reflection 0.2
    specular 0.5
    roughness 0.02
    metallic
   }
   normal {
    dents
    scale 0.4
    turbulence 0.3
   }
  }
  light_source { //liekki
   <0,5,0>
   color rgb <0.5,0.3,0>
   area_light <0.5,0,0>, <0,0,0.5>, 3, 3
   media_interaction on
   media_attenuation on
   jitter
   fade_distance 20
   fade_power 2
   looks_like {
    lathe { 
     cubic_spline
     5,
     <0,0>,
     <0,0>,
     <0.3,0.5>,
     <0,2>,
     <0,2>
     hollow
     translate <0,-0.2,0>
     pigment {
      color rgbt <1,1,1,1>
     }
     finish {
      ambient 1
     }
     interior {
      media {
       scattering {
        2,
        rgb <1,1,1>
        extinction 0.5
       }
       intervals 30
       samples 1,1
       density {
        bozo
        scale <0.1,0.5,0.1>
        turbulence 0.75
        density_map {
         [0 color Black]
         [0.25 Blue * 1.25]
         [0.5 Orange * 1.75]
         [0.75 Yellow * 1.75]
         [1 White * 2]
        }
       }
      }
     }
    }
   }
  }
  light_source { //liekki
   <0,5.5,0>
   color rgb <1,0.6,0>
   area_light <0.5,0,0>, <0,0,0.5>, 3, 3
   media_interaction on
   media_attenuation on
   jitter
   fade_distance 30
   fade_power 2
  }
 }

object {
 tikku_valo
 translate <-10,0,6>
}                   


object {
 tikku_valo
 rotate <0,-60,0>
 translate <10,0,-6>
}                   

//jalokivet

#declare ikosaedri =
 object {
  Icosahedron
  rotate <14,0,-37>
  translate <0,-1,0>
  pigment {
   color rgbf <0.95,0.1,0.1,0.8>
  }
  finish {
   reflection 0.5
   specular 1
   roughness 0.01
  }
  interior {
   ior 2
   caustics 0.8
  }
 }

#declare dodekaedri =
 object {
  Dodecahedron
  rotate <0,0,0>
  translate <0,-1,0>
  pigment {
   color rgbf <0.5,0.1,1,0.8>
  }
  finish {
   reflection 0.4
   specular 1
   roughness 0.01
  }
  interior {
   ior 1.8
   caustics 0.7
  }
 }

object {
 ikosaedri
 translate <-4,0,-8.5>
}

object {
 ikosaedri
 rotate <0,33,0>
 translate <-10,0,-10>
}

object {
 dodekaedri
 translate <-1,0,-11>
}

object {
 dodekaedri
 rotate <0,68,0>
 translate <-7,0,-7.5>
}

object {
 dodekaedri
 rotate <0,-54,0>
 translate <-5,0,-15>
}

//kolikot

#declare kolikko =
 difference {
  object {
   Disk_Y
   scale <1,0.2,1>
  }
  union {
   object {
    Disk_Y
    scale <0.9,0.2,0.9>
    translate <0,-0.35,0>
   }
   object {
    Disk_Y
    scale <0.9,0.22,0.9>
    translate <0,0.35,0>
   }
  }
  pigment {
   bozo
   scale 0.2
   turbulence 0.1
   color_map {
    [0 color rgb <1,0.7,0.2>]
    [1 color rgb <0.9,0.7,0.3>]
   }
  }
  normal {
   dents
   scale 0.2
   turbulence 0.1
  }
  finish {
   metallic
   reflection 0.35
   specular 0.6
   roughness 0.1
  }
 } 
 
#declare kolikko_kasa =
 union {
  object {
   kolikko
  }
  object {
   kolikko
   translate <2,0,0.5>
  }
  object {
   kolikko
   rotate <-20,0,0>
   translate <2,0.2,-0.5>
  }
  translate <0,-1.9,0>
 }

object {
 kolikko_kasa
 translate <5,0,8>
}
 
object {
 kolikko_kasa
 rotate <0,150,0>
 translate <3.1,0,4.7>
}

object {
 kolikko_kasa
 translate <8,0,5>
 rotate <0,30,0>
}

object {
 kolikko
 translate <6,-1.9,5>
 normal {
  translate 3
 }
}

object {
 kolikko
 translate <9,-1.9,5.3>
 normal {
  translate 2
 }
}                    

object {
 kolikko
 translate <7,-1.9,12>
 normal {
  translate 1
 }
}

//tikari

#declare tik_norm1 =
 normal {
  dents
  scale 0.5
  turbulence 0.5
 }

#declare tik_norm2 =
 normal {
  dents
  scale 0.03
  turbulence 0.1
 }

#declare tikari = 
 union {
  mesh { //ter
   triangle {
    <5,0,0>, <0,0.15,0>, <0,0,0.5>
   }
   triangle {
    <5,0,0>, <0,-0.15,0>, <0,0,0.5>
   }
   triangle {
    <5,0,0>, <0,0.15,0>, <0,0,-0.5>
   }
   triangle {
    <5,0,0>, <0,-0.15,0>, <0,0,-0.5>
   }
   texture {
    pigment { rgb <0.658824, 0.658824, 0.658824> }
    finish {
     metallic
     diffuse 0.7
     reflection 0.2
     brilliance 8
     specular 0.8
     roughness 0.1
    }
    normal {
     dents
     scale <2,0.1,0.1>
     turbulence 0.2
    }
   }
  }
  difference { //kahva
   lathe {
    cubic_spline
    8,
    <0,0>,
    <0,0>,
    <2,0.5>,
    <1,1.5>,
    <1,5.5>,
    <2,6.5>,       
    <0,7>,
    <0,7>
    rotate <0,0,90>
    scale 0.4
    translate <0.4,0,0>
   }
   object {
    Sphere
    scale 0.7
    translate <-2.5,0,0>
   } 
   texture {
    pigment { rgb <0.72, 0.45, 0.20> }
    finish {
     metallic
     diffuse 0.7
     reflection 0.2
     brilliance 8
     specular 0.8
     roughness 0.1
    }
    normal {
     average
     normal_map {
      [2 tik_norm1]
      [1 tik_norm2]
     }
    }
   }            
  } 
  light_source { //"pallo"
   <-2.5,0,0>
   color rgb <0.8,0,0.1>
   media_interaction on
   media_attenuation on
   jitter
   fade_distance 10
   fade_power 2
   looks_like {
    object {
     Sphere
     hollow
     scale 0.7
     texture {
      Glass3
     }
     interior {
      media {
       scattering {
        1,
        rgb <0.8,0,0.1>
       }
       intervals 30
       samples 1,1
       density {
        spherical
        scale 0.5
        turbulence 0.1
       }
      }
     }
    }
   }
  }
 }

object {
 tikari
 scale 2
 rotate <0,-12,-17>
 translate <3.6,0.8,7>
}
           