// taustat.inc
//   -kaupunkiaiheisia objekteja 
//   -ilp0/piAstro 2001
#include "metals.inc"
//------------------------------------------------------//
//                     < LIPUT >                        //
#declare l_detaljit = 1;
#declare l_valot    = 1;
//------------------------------------------------------//
//                    < VAKIOT >                        //
#declare p_aurinko = <-1500, 1560,  -1500>;
#declare meri_Y    = -6.0;
// saaren mitat
#declare saari_X = 200;
#declare saari_Y = 15;
#declare saari_Z = 200;
// sillan holvien mitat 
#declare h_pituus  = 12;
#declare h_leveys  = 5;
#declare h_korkeus = 2.5;
#declare h_vali    = 3;
// sillan mitat
#declare s_pituus  = 20;
#declare s_korkeus = 8;
#declare s_leveys  = 10;
// sillan koristereikien mitat
#declare r_pituus  = 1.3;
#declare r_minY    = 7.2;
#declare r_maxY    = 7.8;
// 1_talon mitat
#declare talo_X1   = 8.0;
#declare talo_Y1   = 3.0;
#declare talo_Z1   = 4.0;
// muita muuttujia
#declare kerroksia1= 10;
#declare riveja1   = 6;
#declare kerroksia2= 7;
#declare riveja2   = 10;
#declare kerroksia3= 14;
#declare riveja3   = 12;
#declare kumpuja   = 50;
#declare reikia    = 10;
#declare lammpuja  = 1;
#declare siltoja   = 7;
#declare laskuri   = 0;
#declare laskuri2  = 0;
//------------------------------------------------------//
//                    < VRIT >                         //    
#declare v_aurinko      = color rgb  <1.0, 2.0, 2.0>;
#declare v_asfaltti     = color rgb  <0.4, 0.4, 0.4>;
#declare v_nurmikko     = color rgb  <0.0, 0.9, 0.2>;
#declare v_hiekka       = color rgb  <0.7, 0.6, 0.1>;
#declare v_lyhtypylvas  = color rgb  <0.6, 0.6, 0.6>;
#declare v_lyhty        = color rgb  <2.0, 2.0, 2.0>;
#declare v_taivas1      = color rgb  <0.4, 0.4, 0.5>;
#declare v_taivas2      = color rgb  <0.2, 0.2, 0.3>;
#declare v_betoni       = color rgb  <0.5, 0.5, 0.5>; 
#declare v_ikkuna       = color rgb  <1.4, 1.0, 0.7>;
#declare v_ruskea_tiili = color rgb  <0.7, 0.6, 0.5>;
#declare v_pilvet       = color rgbt <0.4, 0.2, 0.4, 1.0>;
//------------------------------------------------------//
//                  < TEKSTUURIT >                      //     
#declare t_asfaltti =
  texture { pigment { color v_asfaltti }
            normal { bumps 0.6 scale 0.007 }
            finish { phong 0.2 ambient 0.2 diffuse 0.2 }}

#declare t_lyhtypylvas =
  texture { pigment { color v_lyhtypylvas }
            normal { wrinkles 0.9 scale 0.001 }
            finish { phong 0.4 ambient 0.25 diffuse 0.3 }}

#declare t_ruskea_tiili =
  texture { pigment { color v_ruskea_tiili }
            normal { wrinkles 0.5 scale 0.03 }
            finish { phong 0.16 ambient 0.19 diffuse 0.2}}            

#declare t_nurmikko =
  texture { pigment { color v_nurmikko }
            normal { wrinkles 1 scale <0.001, 1, 0.001> }
            finish { crand 0.4 ambient 0.21 diffuse 0.3 }}

#declare t_hiekka =
  texture { pigment { color v_hiekka }
            normal { wrinkles 1 scale <0.001, 1, 0.001> }
            finish { crand 0.3 ambient 0.15 diffuse 0.4 }}

#declare t_betoni =
  texture { pigment { color v_betoni }
            normal { wrinkles 0.2 scale 0.0001 }
            finish { phong 0.1 crand 0.1
                     ambient 0.12 diffuse 0.2 }}
//------------------------------------------------------//  
//                    < MUODOT >                        // 
// lyhtypylvaan muodot
#declare m_pylvas =
  merge {
    cylinder {
      <0.0, 0.0, 0.0> 
      <0.0, 2.0, 0.0>, 0.10 }
    cone {
      <0.0, 2.0, 0.0>, 0.10 
      <0.0, 2.2, 0.0>, 0.05 }}

#declare m_kaari = 
  intersection {
    torus { 0.3, 0.06 }
    box { <-0.3, -0.3, -0.3>
          < 0.3,  0.3,  0.3> translate <0.2, 0.0, 0.2> }
    rotate <90, 0, 90> 
    translate <-0.3, 6, 0> }

#declare m_lamppu =
  difference { 
    intersection {
      cylinder {
        <0.0, 0.0, 0.0>
        <0.0, 0.1, 0.0>, 0.2 }
      box { 
        <-0.3, 0.02, -0.3>
        < 0.3, 0.12,  0.3>}}
    sphere {
      <0.0, 0.04, 0.0>, 0.05 }
    scale <1.6, 2.3, 1>
    translate <-2.3, 6.15, 0.0> }          

#declare m_lyhty = 
  light_source {
    <0, 0, 0>
    color v_lyhty
    fade_power 2.4
    fade_distance 19
    #if (l_detaljit) 
    looks_like {
      sphere { <0, -0.4, 0>, 0.3 
                scale <1, 0.2, 0.5> 
                pigment { color v_lyhty }
                finish { ambient 2.1 }}}
    #end            
    translate <-2.3, 6.24, 0.0> }

// sillan muoto  
#declare m_siltaXY =
  difference { 
    box { <-s_pituus/2, 0, 0-s_leveys/2> 
          <s_pituus/2, s_korkeus, s_leveys/2>}
    sphere { <0, 0, s_leveys/2>,  h_pituus/2 scale <1.3,1,1> }
    sphere { <0, 0, -s_leveys/2>, h_pituus/2 scale <1.3,1,1> }
    sphere { <0, 0, 0>,  h_leveys/2 
             scale <3,2.5,1.2>
             translate <-s_pituus/2+3, 0, 0> }
    sphere { <0, 0, 0>, h_leveys/2 
             scale <3,2.5,1.2>
             translate <s_pituus/2-3, 0, 0> }
    box { 
      <-s_pituus/2-0.01,s_korkeus-0.9,-s_leveys/2+0.4> 
      <s_pituus/2+0.01,s_korkeus+0.01,s_leveys/2-0.4> }
    #if (l_detaljit)
      #while (laskuri < reikia)
        box { <-s_pituus/2+laskuri*(s_pituus/reikia), 
              r_minY, -s_leveys/2-0.01>
              <-s_pituus/2+laskuri*(s_pituus/reikia)+r_pituus, 
              r_maxY, s_leveys/2>+0.01 }
        #declare laskuri=laskuri+1;      
      #end
      box { 
        <-s_pituus/2-0.01,s_korkeus-1,-s_leveys/2+1.7> 
        <s_pituus/2+0.01,s_korkeus+0.01, -0.1> }
      box { 
        <-s_pituus/2-0.01,s_korkeus-1,+s_leveys/2-1.7> 
        <s_pituus/2+0.01,s_korkeus+0.01, +0.1> }
      box { 
        <s_pituus/4-1.5,s_korkeus-1,-0.3> 
        <s_pituus/4+1.5,s_korkeus+0.01, 0.3> }
      box { 
        <3*(s_pituus/4)-1.5,s_korkeus-1,-0.3> 
        <3*(s_pituus/4)+1.5,s_korkeus+0.01, 0.3> }    
    #end }    

// saaren muoto
#declare m_saari =
  height_field {
    tga "saariHF.tga"
    smooth
    scale <1257, 54, 757>
    translate <-21, -28, -21> }
  
// kerrostalojen muoto
#declare m_talo1_valolla =
  union {
    // runko
    box { <0, 0, 0> 
          <talo_X1, talo_Y1, talo_Z1> 
          texture { t_betoni }}
    #if (l_detaljit)
      // parveke
      box { <-1.5, 0.3, talo_Z1/2-1.4> 
            <1.5, 1.5, talo_Z1/2+1.4> 
            texture { t_betoni }}
      // ikkunat
      box { <-0.1, 1.5, talo_Z1/2-0.9> 
            < 0.1, 2.2, talo_Z1/2-0.1> 
            pigment { v_ikkuna }}
      box { <-0.1, 1.5, talo_Z1/2+1.6> 
            < 0.1, 2.2, talo_Z1/2+0.5> 
            pigment { v_ikkuna }}
    #end }

#declare m_talo1_valotta =
  union {
    // runko
    box { <0, 0, 0> 
          <talo_X1, talo_Y1, talo_Z1> 
          texture { t_betoni }}
    #if (l_detaljit)
      // parveke
      box { <-1.5, 0.3, talo_Z1/2-1.4> 
            <1.5, 1.5, talo_Z1/2+1.4> 
            texture { t_betoni }}
      // ikkunat
      box { <-0.1, 1.5, talo_Z1/2-0.9> 
            < 0.1, 2.2, talo_Z1/2-0.1> 
            pigment { color rgb <0, 0, 0> }
            finish { reflection 0.5 }}
      box { <-0.1, 1.5, talo_Z1/2+1.6> 
            < 0.1, 2.2, talo_Z1/2+0.5> 
            pigment { color rgb <0, 0, 0> }
            finish { reflection 0.5 }}
    #end }

// tehdaspiipun muoto
#declare m_piippu =
  union {
    cone { <0.0, 0.00, 0.0>, 4 
           <0.0, 80.0, 0.0>, 3 
           texture { t_betoni }}
    union { 
      sphere { <3, 45, 3>, 0.6 }
      sphere { <3, 45, -3>, 0.6 }
      sphere { <-3, 45, 3>, 0.6 }
      sphere { <-3, 45, -3>, 0.6 }
      sphere { <3, 75, 3>, 0.5 }
      sphere { <3, 75, -3>, 0.5 }
      sphere { <-3, 75, 3>, 0.5 }
      sphere { <-3, 75, -3>, 0.5 }
      texture { 
        pigment { color rgb <1, 0, 0> }
        finish { ambient 1 }}}}                   

// nostokurjen muodot
#declare m_palkki =
  union {
    cylinder { <0, 0, 0>  <20, 0, 0>, 0.3 }
    cylinder { <20, 0, 0> <20, 0, 2>, 0.3 }
    cylinder { <20, 0, 2> <0, 0, 2>, 0.3 }
    cylinder { <0, 0, 2>  <0, 0, 0>, 0.3 }
    
    cylinder { <0, 2, 0>  <20, 2, 0>, 0.3 }
    cylinder { <20, 2, 0> <20, 2, 2>, 0.3 }
    cylinder { <20, 2, 2> <0, 2, 2>, 0.3 }
    cylinder { <0, 2, 2>  <0, 2, 0>, 0.3 }
    
    cylinder { <0, 0, 0> <0, 2, 0>, 0.3 }
    cylinder { <20, 0, 0> <20, 2, 0>, 0.3 }
    cylinder { <20, 0, 2> <20, 2, 2>, 0.3 }
    cylinder { <0, 0, 2> <0, 2, 2>, 0.3 }
    
    #if (l_detaljit)
      cylinder { <0, 0, 0> <20, 0, 2>, 0.3 }
      cylinder { <20, 0, 0> <0, 0, 2>, 0.3 }
      cylinder { <0, 2, 0> <20, 2, 2>, 0.3 }
      cylinder { <20, 2, 0> <0, 2, 2>, 0.3 }
    
      cylinder { <0, 0, 0> <20, 2, 2>, 0.3 }
      cylinder { <20, 0, 0> <0, 2, 2>, 0.3 }
      cylinder { <0, 2, 0> <20, 0, 2>, 0.3 }
      cylinder { <20, 2, 0> <0, 0, 2>, 0.3 }
    #end
    texture { t_lyhtypylvas }}         
//------------------------------------------------------//  
//                   < OBJEKTIT >                       //
// luonnon objekteja
#declare o_taivas =
  sky_sphere {
      pigment {
        gradient y
        color_map {[0 1 color v_taivas1 color v_taivas2]}
        scale 1.5
        translate -1 }
      #if (l_detaljit)
        pigment {
          bozo
          turbulence 0.65
          octaves 6
          omega 0.7
          lambda 2
          color_map {
              [0.0 0.2 color v_pilvet
                       color v_pilvet*0.7]
              [0.2 1.0 color v_pilvet*0.5
                       color v_pilvet*0.3] }
          scale <0.2, 0.5, 0.2> 
          rotate z*90 }
      #end }

#declare o_aurinko =
  light_source {
    p_aurinko
    color v_aurinko
    fade_distance 10000
    fade_power 1 
    looks_like { 
      union {
        sphere { 
          p_aurinko, 50 
          pigment { color v_aurinko }}
        #if (l_detaljit)
          sphere {
            p_aurinko, 70 
            pigment { color rgbft <1.9, 1.4, 0.6, 0.005, 0.3> }}
          sphere {                                  
            p_aurinko, 90 
            pigment { color rgbft <1.5, 1.1, 0.8, 0.0005, 0.7> }}
          sphere {
            p_aurinko, 140 
            pigment { color rgbft <0.3, 0.8, 1.6, 0.00005, 0.9> }}
        #end }}}

#declare o_asfaltti =
  box {
   <-30, -0.2, -3>
   <0, 0.08, 3> 
   texture { t_asfaltti }} 
  
#declare o_meri =
  plane { y, meri_Y
   texture {
      T_Chrome_2D
      normal {
         waves 0.06
         frequency 7000.0
         scale 3000.0 }}}

#declare o_sumu =
  fog {
    fog_type   2
    distance   220
    color      rgb 0.2 // gray
    fog_offset 0.01
    fog_alt    9.2
    turbulence 0.02 }
      
#declare o_talo11 =
  union {
    #declare laskuri=0;
    #while (laskuri < kerroksia1)
      #declare laskuri2=0;
      #while (laskuri2 < riveja1)        
        #if (mod (laskuri2, 3)) 
          object { m_talo1_valolla 
                   translate <0, laskuri*talo_Y1, laskuri2*talo_Z1>}
        #else 
          object { m_talo1_valotta 
                   translate <0, laskuri*talo_Y1, laskuri2*talo_Z1>}  
        #end  
        #declare laskuri2=laskuri2+1;
      #end
      #declare laskuri=laskuri+1;
    #end }

#declare o_talo12 =
  union {
    #declare laskuri=0;
    #while (laskuri < kerroksia2)
      #declare laskuri2=0;
      #while (laskuri2 < riveja2)        
        #if (mod (laskuri2, 3)) 
          object { m_talo1_valolla 
                   translate <0, laskuri*talo_Y1, laskuri2*talo_Z1>}
        #else 
          object { m_talo1_valotta 
                   translate <0, laskuri*talo_Y1, laskuri2*talo_Z1>}  
        #end  
        #declare laskuri2=laskuri2+1;
      #end
      #declare laskuri=laskuri+1;
    #end }    
    
#declare o_talo13 =
  union {
    #declare laskuri=0;
    #while (laskuri < kerroksia3)
      #declare laskuri2=0;
      #while (laskuri2 < riveja3)        
        #if (mod (laskuri2, 3)) 
          object { m_talo1_valolla 
                   translate <0, laskuri*talo_Y1, laskuri2*talo_Z1>}
        #else 
          object { m_talo1_valotta 
                   translate <0, laskuri*talo_Y1, laskuri2*talo_Z1>}  
        #end  
        #declare laskuri2=laskuri2+1;
      #end
      #declare laskuri=laskuri+1;
    #end }

#declare o_saari =
  union { 
    object { m_saari texture { t_nurmikko }}
    object { o_talo11 
             scale <1, 1, 1>
             rotate y*-45
             translate <92, 0, 44> }
    object { o_talo12 
             scale <1, 1, 1>
             rotate y*45
             translate <70, 0, 0> }
    object { o_talo11 translate <160, 0, 20> }
    object { o_talo13 
             scale <1, 1, 1>
             rotate y*-45
             translate <220, 0, 95> }
    object { o_talo12 
             scale <1, 1, 1>
             rotate y*50
             translate <60, 0, -5> }
    object { o_talo13 
             scale <1, 1, 2>
             rotate y*30
             translate <420, 0, 120> }
    object { o_talo13 
             scale <1, 1, 2>
             rotate y*-30
             translate <380, 0, 220> }
    object { o_talo12 
             scale <1, 1, 1>
             rotate y*-50
             translate <490, 0, 290> }
    object { o_talo11 
             scale <1, 1, 1>
             rotate y*60
             translate <590, 0, 390> }
    object { o_talo12 
             scale <1, 1, 1>
             translate <690, 0, 490> }
    object { o_talo13 
             scale <1, 1, 2>
             rotate y*50
             translate <220, 0, 60> }
    object { o_talo13 
             scale <1, 1, 2>
             rotate y*-130
             translate <480, 0, 80> }
    object { o_talo12 
             scale <1, 1, 1>
             rotate y*-40
             translate <390, 0, 190> }
    object { o_talo11 
             scale <1, 1, 1>
             rotate y*60
             translate <190, 0, -40> }
    object { o_talo12 
             scale <1, 1, 1>
             translate <510, 0, 290> }}

#declare o_ranta =
  union {
    object { m_saari 
             rotate y*84 
             texture { t_nurmikko }}
    object { m_saari 
             rotate y*14 
             texture { t_nurmikko }}
    scale <0.18, 0.18, 0.18>
    translate <-121, meri_Y+0.1 , 0> }
    
// kaupungin objekteja
#declare o_lyhtypylvas =
  union { 
    merge { 
      object { m_pylvas }
      object { m_pylvas 
               scale <0.8, 1.0, 0.8> 
               translate y*2 }
      object { m_pylvas 
               scale <0.6, 1.0, 0.6> 
               translate y*4 }
      object { m_kaari }
      object { m_pylvas 
               rotate z*90
               scale <0.8, 0.6, 0.6> 
               translate <-0.4, 6.3, 0.0> }
      object { m_lamppu }
      texture { t_lyhtypylvas }}
    #if (l_valot) 
      object { m_lyhty }
    #end  
    rotate y*90 }

#declare o_piippu =
  object { m_piippu } 

#declare o_nostokurki =
  union {
    object { m_palkki 
             scale <6, 1, 1>
             rotate y*90 
             translate <0, 70, 30>}
    object { m_palkki 
             scale <4, 1.5, 1.5> 
             rotate <0, 0, 90> 
             translate z*1}}

#declare o_silta =
  union { 
    #declare laskuri = 0;
    #while (laskuri < siltoja)
      object { m_siltaXY translate x*(laskuri*s_pituus) }
      #if (l_detaljit)
        object { o_lyhtypylvas 
                 rotate y*180
                 translate <laskuri*s_pituus, 8,s_leveys/2-0.3> }
        object { o_lyhtypylvas 
                 translate <laskuri*s_pituus, 8,-s_leveys/2+0.3> }
      #end
      #declare laskuri=laskuri+1;
    #end             
    texture { t_ruskea_tiili }}


 





         