/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class FontEngine {
    private int charactersPerLine = 24;
    private boolean shadowEnabled;
    private int currentColor = 0;
    private int numchars = 26;
    private int i;
    private int k;
    private Image[] alphabet;
    private Image[] alphabetShadow;
    private ImageObserver imob;
    private int[] pixels;
    private int[][] letters;
    private Component c;
    private int charWidth;
    private int charHeight;
    private int width;
    private int height;
    private int color;
    int textwidth = 4096;

    public FontEngine(Component component, ImageObserver imageObserver, Image image, int n, int n2) {
        this.charWidth = n;
        this.charHeight = n2;
        this.imob = imageObserver;
        this.c = component;
        this.width = image.getWidth(imageObserver);
        this.height = image.getHeight(imageObserver);
        this.pixels = new int[this.width * this.height];
        this.grabImage(image);
        this.getLetters();
        this.alphabet = this.makeAlphabet(this.letters);
    }

    private void grabImage(Image image) {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void getLetters() {
        this.letters = new int[this.numchars][this.charWidth * this.charHeight];
        int n = 0;
        while (n < this.numchars) {
            int n2 = 0;
            while (n2 < this.charWidth) {
                int n3 = 0;
                while (n3 < this.charHeight) {
                    this.letters[n][n3 + this.charWidth * n2] = this.pixels[(n3 + this.charWidth * n + this.width * n2) % (this.width * this.height)];
                    if (this.letters[n][n3 + this.charWidth * n2] == -16777216) {
                        this.letters[n][n3 + this.charWidth * n2] = 0;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public int getCharIndex(char c) {
        int n = c - 65;
        return n;
    }

    public Image createText(String string, int n) {
        if (string == null) {
            string = "";
        }
        Image image = null;
        int[] nArray = new int[this.textwidth * this.charHeight];
        MemoryImageSource memoryImageSource = new MemoryImageSource(this.textwidth, this.charHeight, nArray, 0, this.textwidth);
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c != ' ') {
                int n3 = this.getCharIndex(c);
                int n4 = 0;
                while (n4 < this.charHeight) {
                    int n5 = 0;
                    while (n5 < this.charHeight) {
                        if (n3 >= 0 && n3 < 34 && this.letters[n3][n5 + this.charWidth * n4] != 0) {
                            nArray[(n5 + n2 * this.charWidth + this.textwidth * n4) % (this.textwidth * this.charHeight)] = n;
                        }
                        ++n5;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        image = this.c.createImage(memoryImageSource);
        return image;
    }

    public Image createText(String string) {
        if (string == null) {
            string = "";
        }
        Image image = null;
        int[] nArray = new int[this.textwidth * this.charHeight];
        MemoryImageSource memoryImageSource = new MemoryImageSource(this.textwidth, this.charHeight, nArray, 0, this.textwidth);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != ' ') {
                int n2 = this.getCharIndex(c);
                int n3 = 0;
                while (n3 < this.charHeight) {
                    int n4 = 0;
                    while (n4 < this.charHeight) {
                        if (n2 >= 0 && n2 < 26 && this.letters[n2][n4 + this.charWidth * n3] != 0) {
                            nArray[(n4 + n * this.charWidth + this.textwidth * n3) % (this.textwidth * this.charHeight)] = this.letters[n2][n4 + this.charWidth * n3];
                        }
                        ++n4;
                    }
                    ++n3;
                }
            }
            ++n;
        }
        image = this.c.createImage(memoryImageSource);
        return image;
    }

    public Image createScaledText(String string, int n) {
        Image image = this.createText(string, n);
        Image image2 = null;
        image2 = image.getScaledInstance(image.getWidth(this.imob) << 1, image.getHeight(this.imob) << 1, 8);
        return image2;
    }

    private Image[] makeAlphabet(int[][] nArray) {
        Image[] imageArray = new Image[this.numchars];
        this.i = 0;
        while (this.i < nArray.length) {
            MemoryImageSource memoryImageSource = new MemoryImageSource(this.charWidth, this.charHeight, nArray[this.i], 0, this.charWidth);
            imageArray[this.i] = this.c.createImage(memoryImageSource);
            ++this.i;
        }
        return imageArray;
    }

    public void setColor(int n) {
        if (this.currentColor == n) {
            return;
        }
        this.currentColor = n;
        int[][] nArray = new int[this.numchars][this.charWidth * this.charHeight];
        this.i = 0;
        while (this.i < this.numchars) {
            this.k = 0;
            while (this.k < this.charWidth * this.charHeight) {
                if (this.letters[this.i][this.k] == -1) {
                    nArray[this.i][this.k] = n;
                }
                ++this.k;
            }
            ++this.i;
        }
        this.alphabet = this.makeAlphabet(nArray);
    }

    public void createShadow() {
        this.currentColor = this.color;
        int[][] nArray = new int[this.numchars][this.charWidth * this.charHeight];
        this.i = 0;
        while (this.i < this.numchars) {
            this.k = 0;
            while (this.k < this.charWidth * this.charHeight) {
                if (this.letters[this.i][this.k] == -1) {
                    nArray[this.i][this.k] = -16777216;
                }
                ++this.k;
            }
            ++this.i;
        }
        this.alphabetShadow = this.makeAlphabet(nArray);
    }

    public void setShadow(boolean bl) {
        this.shadowEnabled = bl;
        if (this.shadowEnabled) {
            this.createShadow();
        }
    }

    public void drawText(Graphics graphics, int n, int n2, String string) {
        if (string == null) {
            return;
        }
        int n3 = 0;
        this.i = 0;
        while (this.i < string.length()) {
            char c = string.charAt(this.i);
            if ((c = Character.toUpperCase(c)) != ' ') {
                int n4 = this.getCharIndex(c);
                if (this.i % this.charactersPerLine == 0) {
                    ++n3;
                }
                if (n4 >= 0 && n4 < this.alphabet.length) {
                    if (this.shadowEnabled) {
                        graphics.drawImage(this.alphabetShadow[n4], n + this.charWidth * (this.i % this.charactersPerLine), n2 + n3 * (this.charHeight + 2), this.imob);
                    }
                    graphics.drawImage(this.alphabet[n4], n + this.charWidth * (this.i % this.charactersPerLine) + 2, n2 + 2 + n3 * (this.charHeight + 2), this.imob);
                }
            }
            ++this.i;
        }
    }
}

