/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDeviceBase;

public class JavaSoundAudioDevice
extends AudioDeviceBase {
    private SourceDataLine lt = null;
    private AudioFormat Lt = null;
    private byte[] lT = new byte[1024];
    static Class Bd;

    protected void setAudioFormat(AudioFormat audioFormat) {
        this.Lt = audioFormat;
    }

    protected AudioFormat getAudioFormat() {
        if (this.Lt == null) {
            Decoder decoder = this.getDecoder();
            this.Lt = new AudioFormat(decoder.getOutputFrequency(), 16, decoder.getOutputChannels(), true, false);
        }
        return this.Lt;
    }

    protected DataLine.Info getSourceLineInfo() {
        AudioFormat audioFormat = this.getAudioFormat();
        DataLine.Info info = new DataLine.Info(Bd == null ? (Bd = JavaSoundAudioDevice.bd("javax.sound.sampled.SourceDataLine")) : Bd, audioFormat, 4000);
        return info;
    }

    public void open(AudioFormat audioFormat) throws JavaLayerException {
        if (!this.isOpen()) {
            this.setAudioFormat(audioFormat);
            this.openImpl();
            this.setOpen(true);
        }
    }

    protected void openImpl() throws JavaLayerException {
    }

    protected void createSource() throws JavaLayerException {
        Throwable throwable = null;
        try {
            Line line = AudioSystem.getLine(this.getSourceLineInfo());
            if (line instanceof SourceDataLine) {
                this.lt = (SourceDataLine)line;
                this.lt.open(this.Lt, this.millisecondsToBytes(this.Lt, 2000));
                this.lt.start();
            }
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        catch (LineUnavailableException lineUnavailableException) {
            throwable = lineUnavailableException;
        }
        if (this.lt == null) {
            throw new JavaLayerException("cannot obtain source audio line", throwable);
        }
    }

    public int millisecondsToBytes(AudioFormat audioFormat, int n) {
        return (int)((double)((float)n * (audioFormat.getSampleRate() * (float)audioFormat.getChannels() * (float)audioFormat.getSampleSizeInBits())) / 8000.0);
    }

    protected void closeImpl() {
        if (this.lt != null) {
            this.lt.close();
        }
    }

    protected void writeImpl(short[] sArray, int n, int n2) throws JavaLayerException {
        if (this.lt == null) {
            this.createSource();
        }
        byte[] byArray = this.toByteArray(sArray, n, n2);
        this.lt.write(byArray, 0, n2 * 2);
    }

    protected byte[] getByteArray(int n) {
        if (this.lT.length < n) {
            this.lT = new byte[n + 1024];
        }
        return this.lT;
    }

    protected byte[] toByteArray(short[] sArray, int n, int n2) {
        byte[] byArray = this.getByteArray(n2 * 2);
        int n3 = 0;
        while (n2-- > 0) {
            short s = sArray[n++];
            byArray[n3++] = (byte)s;
            byArray[n3++] = (byte)(s >>> 8);
        }
        return byArray;
    }

    protected void flushImpl() {
        if (this.lt != null) {
            this.lt.drain();
        }
    }

    public int getPosition() {
        int n = 0;
        if (this.lt != null) {
            n = (int)(this.lt.getMicrosecondPosition() / 1000L);
        }
        return n;
    }

    public void test() throws JavaLayerException {
        try {
            this.open(new AudioFormat(22050.0f, 16, 1, true, false));
            short[] sArray = new short[2205];
            this.write(sArray, 0, sArray.length);
            this.flush();
            this.close();
        }
        catch (RuntimeException runtimeException) {
            throw new JavaLayerException("Device test failed: " + runtimeException);
        }
    }

    static Class bd(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

