/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Crc16;

public final class Header {
    public static final int[][] frequencies = new int[][]{{22050, 24000, 16000, 1}, {44100, 48000, 32000, 1}, {11025, 12000, 8000, 1}};
    public static final int MPEG2_LSF = 0;
    public static final int MPEG25_LSF = 2;
    public static final int MPEG1 = 1;
    public static final int STEREO = 0;
    public static final int JOINT_STEREO = 1;
    public static final int DUAL_CHANNEL = 2;
    public static final int SINGLE_CHANNEL = 3;
    public static final int FOURTYFOUR_POINT_ONE = 0;
    public static final int FOURTYEIGHT = 1;
    public static final int THIRTYTWO = 2;
    private int ltht;
    private int Ltht;
    private int lTht;
    private int LTht;
    private int ltHt;
    private int LtHt;
    private int lTHt;
    private int LTHt;
    private int lthT;
    private int LthT;
    private boolean lThT;
    private boolean LThT;
    private byte ltHT = Bitstream.bdH;
    private Crc16 LtHT;
    public short checksum;
    public int framesize;
    public int nSlots;
    private int lTHT = -1;
    public static final int[][][] bitrates = new int[][][]{new int[][]{{0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}}, new int[][]{{0, 32000, 64000, 96000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000, 0}, {0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 0}, {0, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 0}}, new int[][]{{0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}}};
    public static final String[][][] bitrate_str = new String[][][]{{{"free format", "32 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "176 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}}, {{"free format", "32 kbit/s", "64 kbit/s", "96 kbit/s", "128 kbit/s", "160 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "288 kbit/s", "320 kbit/s", "352 kbit/s", "384 kbit/s", "416 kbit/s", "448 kbit/s", "forbidden"}, {"free format", "32 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "160 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "320 kbit/s", "384 kbit/s", "forbidden"}, {"free format", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "160 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "320 kbit/s", "forbidden"}}, {{"free format", "32 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "176 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}}};

    Header() {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("Layer ");
        stringBuffer.append(this.layer_string());
        stringBuffer.append(" frame ");
        stringBuffer.append(this.mode_string());
        stringBuffer.append(' ');
        stringBuffer.append(this.version_string());
        if (!this.checksums()) {
            stringBuffer.append(" no");
        }
        stringBuffer.append(" checksums");
        stringBuffer.append(' ');
        stringBuffer.append(this.sample_frequency_string());
        stringBuffer.append(',');
        stringBuffer.append(' ');
        stringBuffer.append(this.bitrate_string());
        String string = stringBuffer.toString();
        return string;
    }

    void b(Bitstream bitstream, Crc16[] crc16Array) throws BitstreamException {
        int n;
        boolean bl = false;
        do {
            this.lTHT = n = bitstream.bdh(this.ltHT);
            if (this.ltHT == Bitstream.bdH) {
                this.LtHt = n >>> 19 & 1;
                if ((n >>> 20 & 1) == 0) {
                    if (this.LtHt == 0) {
                        this.LtHt = 2;
                    } else {
                        throw bitstream.newBitstreamException(256);
                    }
                }
                if ((this.LTHt = n >>> 10 & 3) == 3) {
                    throw bitstream.newBitstreamException(256);
                }
            }
            this.ltht = 4 - (n >>> 17) & 3;
            this.Ltht = n >>> 16 & 1;
            this.lTht = n >>> 12 & 0xF;
            this.LTht = n >>> 9 & 1;
            this.lTHt = n >>> 6 & 3;
            this.ltHt = n >>> 4 & 3;
            this.LthT = this.lTHt == 1 ? (this.ltHt << 2) + 4 : 0;
            if ((n >>> 3 & 1) == 1) {
                this.lThT = true;
            }
            if ((n >>> 2 & 1) == 1) {
                this.LThT = true;
            }
            if (this.ltht == 1) {
                this.lthT = 32;
            } else {
                int n2 = this.lTht;
                if (this.lTHt != 3) {
                    n2 = n2 == 4 ? 1 : (n2 -= 4);
                }
                this.lthT = n2 == 1 || n2 == 2 ? (this.LTHt == 2 ? 12 : 8) : (this.LTHt == 1 || n2 >= 3 && n2 <= 5 ? 27 : 30);
            }
            if (this.LthT > this.lthT) {
                this.LthT = this.lthT;
            }
            this.calculate_framesize();
            bitstream.Bdh(this.framesize);
            if (bitstream.isSyncCurrentPosition(this.ltHT)) {
                if (this.ltHT == Bitstream.bdH) {
                    this.ltHT = Bitstream.BdH;
                    bitstream.BDh(n & 0xFFF80CC0);
                }
                bl = true;
                continue;
            }
            bitstream.unreadFrame();
        } while (!bl);
        bitstream.bDh();
        if (this.Ltht == 0) {
            this.checksum = (short)bitstream.get_bits(16);
            if (this.LtHT == null) {
                this.LtHT = new Crc16();
            }
            this.LtHT.add_bits(n, 16);
            crc16Array[0] = this.LtHT;
        } else {
            crc16Array[0] = null;
        }
        if (this.LTHt == 0) {
            // empty if block
        }
    }

    public int version() {
        return this.LtHt;
    }

    public int layer() {
        return this.ltht;
    }

    public int bitrate_index() {
        return this.lTht;
    }

    public int sample_frequency() {
        return this.LTHt;
    }

    public int frequency() {
        return frequencies[this.LtHt][this.LTHt];
    }

    public int mode() {
        return this.lTHt;
    }

    public boolean checksums() {
        return this.Ltht == 0;
    }

    public boolean copyright() {
        return this.lThT;
    }

    public boolean original() {
        return this.LThT;
    }

    public boolean checksum_ok() {
        return this.checksum == this.LtHT.checksum();
    }

    public boolean padding() {
        return this.LTht != 0;
    }

    public int slots() {
        return this.nSlots;
    }

    public int mode_extension() {
        return this.ltHt;
    }

    public int calculate_framesize() {
        if (this.ltht == 1) {
            this.framesize = 12 * bitrates[this.LtHt][0][this.lTht] / frequencies[this.LtHt][this.LTHt];
            if (this.LTht != 0) {
                ++this.framesize;
            }
            this.framesize <<= 2;
            this.nSlots = 0;
        } else {
            this.framesize = 144 * bitrates[this.LtHt][this.ltht - 1][this.lTht] / frequencies[this.LtHt][this.LTHt];
            if (this.LtHt == 0 || this.LtHt == 2) {
                this.framesize >>= 1;
            }
            if (this.LTht != 0) {
                ++this.framesize;
            }
            this.nSlots = this.ltht == 3 ? (this.LtHt == 1 ? this.framesize - (this.lTHt == 3 ? 17 : 32) - (this.Ltht != 0 ? 0 : 2) - 4 : this.framesize - (this.lTHt == 3 ? 9 : 17) - (this.Ltht != 0 ? 0 : 2) - 4) : 0;
        }
        this.framesize -= 4;
        return this.framesize;
    }

    public int max_number_of_frames(int n) {
        if (this.framesize + 4 - this.LTht == 0) {
            return 0;
        }
        return n / (this.framesize + 4 - this.LTht);
    }

    public int min_number_of_frames(int n) {
        if (this.framesize + 5 - this.LTht == 0) {
            return 0;
        }
        return n / (this.framesize + 5 - this.LTht);
    }

    public float ms_per_frame() {
        float[][] fArrayArray = new float[][]{{8.707483f, 8.0f, 12.0f}, {26.12245f, 24.0f, 36.0f}, {26.12245f, 24.0f, 36.0f}};
        return fArrayArray[this.ltht - 1][this.LTHt];
    }

    public float total_ms(int n) {
        return (float)this.max_number_of_frames(n) * this.ms_per_frame();
    }

    public int getSyncHeader() {
        return this.lTHT;
    }

    public String layer_string() {
        switch (this.ltht) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
        }
        return null;
    }

    public String bitrate_string() {
        return bitrate_str[this.LtHt][this.ltht - 1][this.lTht];
    }

    public String sample_frequency_string() {
        switch (this.LTHt) {
            case 2: {
                if (this.LtHt == 1) {
                    return "32 kHz";
                }
                if (this.LtHt == 0) {
                    return "16 kHz";
                }
                return "8 kHz";
            }
            case 0: {
                if (this.LtHt == 1) {
                    return "44.1 kHz";
                }
                if (this.LtHt == 0) {
                    return "22.05 kHz";
                }
                return "11.025 kHz";
            }
            case 1: {
                if (this.LtHt == 1) {
                    return "48 kHz";
                }
                if (this.LtHt == 0) {
                    return "24 kHz";
                }
                return "12 kHz";
            }
        }
        return null;
    }

    public String mode_string() {
        switch (this.lTHt) {
            case 0: {
                return "Stereo";
            }
            case 1: {
                return "Joint stereo";
            }
            case 2: {
                return "Dual channel";
            }
            case 3: {
                return "Single channel";
            }
        }
        return null;
    }

    public String version_string() {
        switch (this.LtHt) {
            case 1: {
                return "MPEG-1";
            }
            case 0: {
                return "MPEG-2 LSF";
            }
            case 2: {
                return "MPEG-2.5 LSF";
            }
        }
        return null;
    }

    public int number_of_subbands() {
        return this.lthT;
    }

    public int intensity_stereo_bound() {
        return this.LthT;
    }
}

