/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Equalizer$EQFunction;

public final class Equalizer {
    public static final float BAND_NOT_PRESENT = Float.NEGATIVE_INFINITY;
    public static final Equalizer PASS_THRU_EQ = new Equalizer();
    private static final int Lt = 32;
    private final float[] lT = new float[32];

    public Equalizer() {
    }

    public Equalizer(float[] fArray) {
        this.setFrom(fArray);
    }

    public Equalizer(Equalizer$EQFunction equalizer$EQFunction) {
        this.setFrom(equalizer$EQFunction);
    }

    public void setFrom(float[] fArray) {
        this.reset();
        int n = fArray.length > 32 ? 32 : fArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.lT[n2] = this.lt(fArray[n2]);
            ++n2;
        }
    }

    public void setFrom(Equalizer$EQFunction equalizer$EQFunction) {
        this.reset();
        int n = 32;
        int n2 = 0;
        while (n2 < n) {
            this.lT[n2] = this.lt(equalizer$EQFunction.getBand(n2));
            ++n2;
        }
    }

    public void setFrom(Equalizer equalizer) {
        if (equalizer != this) {
            this.setFrom(equalizer.lT);
        }
    }

    public void reset() {
        int n = 0;
        while (n < 32) {
            this.lT[n] = 0.0f;
            ++n;
        }
    }

    public int getBandCount() {
        return this.lT.length;
    }

    public float setBand(int n, float f) {
        float f2 = 0.0f;
        if (n >= 0 && n < 32) {
            f2 = this.lT[n];
            this.lT[n] = this.lt(f);
        }
        return f2;
    }

    public float getBand(int n) {
        float f = 0.0f;
        if (n >= 0 && n < 32) {
            f = this.lT[n];
        }
        return f;
    }

    private float lt(float f) {
        if (f == Float.NEGATIVE_INFINITY) {
            return f;
        }
        if (f > 1.0f) {
            return 1.0f;
        }
        if (f < -1.0f) {
            return -1.0f;
        }
        return f;
    }

    float[] bd() {
        float[] fArray = new float[32];
        int n = 0;
        int n2 = 32;
        while (n < n2) {
            fArray[n] = this.Bd(this.lT[n]);
            ++n;
        }
        return fArray;
    }

    float Bd(float f) {
        if (f == Float.NEGATIVE_INFINITY) {
            return 0.0f;
        }
        float f2 = (float)Math.pow(2.0, f);
        return f2;
    }
}

