/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.DLkhlH;
import javazoom.jl.decoder.Decoder$Params;
import javazoom.jl.decoder.DecoderErrors;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.DlkHlH;
import javazoom.jl.decoder.Equalizer;
import javazoom.jl.decoder.FrameDecoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.Obuffer;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.decoder.dlKHLh;
import javazoom.jl.decoder.dlkHLh;

public class Decoder
implements DecoderErrors {
    private static final Decoder$Params Ltht = new Decoder$Params();
    private Obuffer lTht;
    private DlkHlH LTht;
    private DlkHlH ltHt;
    private DLkhlH LtHt;
    private dlKHLh lTHt;
    private dlkHLh LTHt;
    private int lthT;
    private int LthT;
    private Equalizer lThT = new Equalizer();
    private Decoder$Params LThT;
    private boolean ltHT;

    public Decoder() {
        this(null);
    }

    public Decoder(Decoder$Params decoder$Params) {
        if (decoder$Params == null) {
            decoder$Params = Ltht;
        }
        this.LThT = decoder$Params;
        Equalizer equalizer = this.LThT.getInitialEqualizerSettings();
        if (equalizer != null) {
            this.lThT.setFrom(equalizer);
        }
    }

    public static Decoder$Params getDefaultParams() {
        return (Decoder$Params)Ltht.clone();
    }

    public void setEqualizer(Equalizer equalizer) {
        if (equalizer == null) {
            equalizer = Equalizer.PASS_THRU_EQ;
        }
        this.lThT.setFrom(equalizer);
        float[] fArray = this.lThT.bd();
        if (this.LTht != null) {
            this.LTht.setEQ(fArray);
        }
        if (this.ltHt != null) {
            this.ltHt.setEQ(fArray);
        }
    }

    public Obuffer decodeFrame(Header header, Bitstream bitstream) throws DecoderException {
        if (!this.ltHT) {
            this.ltht(header);
        }
        int n = header.layer();
        this.lTht.clear_buffer();
        FrameDecoder frameDecoder = this.retrieveDecoder(header, bitstream, n);
        frameDecoder.decodeFrame();
        this.lTht.write_buffer(1);
        return this.lTht;
    }

    public void setOutputBuffer(Obuffer obuffer) {
        this.lTht = obuffer;
    }

    public int getOutputFrequency() {
        return this.lthT;
    }

    public int getOutputChannels() {
        return this.LthT;
    }

    public int getOutputBlockSize() {
        return 2304;
    }

    protected DecoderException newDecoderException(int n) {
        return new DecoderException(n, null);
    }

    protected DecoderException newDecoderException(int n, Throwable throwable) {
        return new DecoderException(n, throwable);
    }

    protected FrameDecoder retrieveDecoder(Header header, Bitstream bitstream, int n) throws DecoderException {
        FrameDecoder frameDecoder = null;
        switch (n) {
            case 3: {
                if (this.LtHt == null) {
                    this.LtHt = new DLkhlH(bitstream, header, this.LTht, this.ltHt, this.lTht, 0);
                }
                frameDecoder = this.LtHt;
                break;
            }
            case 2: {
                if (this.lTHt == null) {
                    this.lTHt = new dlKHLh();
                    this.lTHt.create(bitstream, header, this.LTht, this.ltHt, this.lTht, 0);
                }
                frameDecoder = this.lTHt;
                break;
            }
            case 1: {
                if (this.LTHt == null) {
                    this.LTHt = new dlkHLh();
                    this.LTHt.create(bitstream, header, this.LTht, this.ltHt, this.lTht, 0);
                }
                frameDecoder = this.LTHt;
            }
        }
        if (frameDecoder == null) {
            throw this.newDecoderException(513, null);
        }
        return frameDecoder;
    }

    private void ltht(Header header) throws DecoderException {
        int n;
        float f = 32700.0f;
        int n2 = header.mode();
        int n3 = header.layer();
        int n4 = n = n2 == 3 ? 1 : 2;
        if (this.lTht == null) {
            this.lTht = new SampleBuffer(header.frequency(), n);
        }
        float[] fArray = this.lThT.bd();
        this.LTht = new DlkHlH(0, f, fArray);
        if (n == 2) {
            this.ltHt = new DlkHlH(1, f, fArray);
        }
        this.LthT = n;
        this.lthT = header.frequency();
        this.ltHT = true;
    }
}

