/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Crc16;
import javazoom.jl.decoder.DlKhLh;
import javazoom.jl.decoder.DlkHlH;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.dlKhLh;

class DLKhLh
extends DlKhLh {
    protected int channel2_allocation;
    protected float channel2_scalefactor;
    protected int channel2_samplelength;
    protected float channel2_sample;
    protected float channel2_factor;
    protected float channel2_offset;

    public DLKhLh(int n) {
        super(n);
    }

    public void read_allocation(Bitstream bitstream, Header header, Crc16 crc16) {
        this.allocation = bitstream.get_bits(4);
        this.channel2_allocation = bitstream.get_bits(4);
        if (crc16 != null) {
            crc16.add_bits(this.allocation, 4);
            crc16.add_bits(this.channel2_allocation, 4);
        }
        if (this.allocation != 0) {
            this.samplelength = this.allocation + 1;
            this.factor = DlKhLh.table_factor[this.allocation];
            this.offset = DlKhLh.table_offset[this.allocation];
        }
        if (this.channel2_allocation != 0) {
            this.channel2_samplelength = this.channel2_allocation + 1;
            this.channel2_factor = DlKhLh.table_factor[this.channel2_allocation];
            this.channel2_offset = DlKhLh.table_offset[this.channel2_allocation];
        }
    }

    public void read_scalefactor(Bitstream bitstream, Header header) {
        if (this.allocation != 0) {
            this.scalefactor = dlKhLh.scalefactors[bitstream.get_bits(6)];
        }
        if (this.channel2_allocation != 0) {
            this.channel2_scalefactor = dlKhLh.scalefactors[bitstream.get_bits(6)];
        }
    }

    public boolean read_sampledata(Bitstream bitstream) {
        boolean bl = super.read_sampledata(bitstream);
        if (this.channel2_allocation != 0) {
            this.channel2_sample = bitstream.get_bits(this.channel2_samplelength);
        }
        return bl;
    }

    public boolean put_next_sample(int n, DlkHlH dlkHlH, DlkHlH dlkHlH2) {
        super.put_next_sample(n, dlkHlH, dlkHlH2);
        if (this.channel2_allocation != 0 && n != 1) {
            float f = (this.channel2_sample * this.channel2_factor + this.channel2_offset) * this.channel2_scalefactor;
            if (n == 0) {
                dlkHlH2.input_sample(f, this.subbandnumber);
            } else {
                dlkHlH.input_sample(f, this.subbandnumber);
            }
        }
        return true;
    }
}

