/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import javazoom.jl.decoder.BitstreamErrors;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Crc16;
import javazoom.jl.decoder.Header;

public final class Bitstream
implements BitstreamErrors {
    static byte bdH = 0;
    static byte BdH = 1;
    private static final int ltHtl = 433;
    private final int[] LtHtl = new int[433];
    private int lTHtl;
    private byte[] LTHtl = new byte[1732];
    private int lthTl;
    private int LthTl;
    private int lThTl;
    private boolean LThTl;
    private final int[] ltHTl = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071};
    private final PushbackInputStream LtHTl;
    private final Header lTHTl = new Header();
    private final byte[] LTHTl = new byte[4];
    private Crc16[] lthtL = new Crc16[1];

    public Bitstream(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("in");
        }
        this.LtHTl = new PushbackInputStream(inputStream, 1024);
        this.closeFrame();
    }

    public void close() throws BitstreamException {
        try {
            this.LtHTl.close();
        }
        catch (IOException iOException) {
            throw this.newBitstreamException(258, iOException);
        }
    }

    public Header readFrame() throws BitstreamException {
        Header header;
        block2: {
            header = null;
            try {
                header = this.lthtl();
            }
            catch (BitstreamException bitstreamException) {
                if (bitstreamException.getErrorCode() == 260) break block2;
                throw this.newBitstreamException(bitstreamException.getErrorCode(), bitstreamException);
            }
        }
        return header;
    }

    private Header lthtl() throws BitstreamException {
        if (this.lTHtl == -1) {
            this.Lthtl();
        }
        return this.lTHTl;
    }

    private void Lthtl() throws BitstreamException {
        this.lTHTl.b(this, this.lthtL);
    }

    public void unreadFrame() throws BitstreamException {
        if (this.lthTl == -1 && this.LthTl == -1 && this.lTHtl > 0) {
            try {
                this.LtHTl.unread(this.LTHtl, 0, this.lTHtl);
            }
            catch (IOException iOException) {
                throw this.newBitstreamException(258);
            }
        }
    }

    public void closeFrame() {
        this.lTHtl = -1;
        this.lthTl = -1;
        this.LthTl = -1;
    }

    public boolean isSyncCurrentPosition(int n) throws BitstreamException {
        int n2 = this.LThtl(this.LTHTl, 0, 4);
        int n3 = this.LTHTl[0] << 24 & 0xFF000000 | this.LTHTl[1] << 16 & 0xFF0000 | this.LTHTl[2] << 8 & 0xFF00 | this.LTHTl[3] << 0 & 0xFF;
        try {
            this.LtHTl.unread(this.LTHTl, 0, n2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = false;
        switch (n2) {
            case 0: {
                bl = true;
                break;
            }
            case 4: {
                bl = this.isSyncMark(n3, n, this.lThTl);
            }
        }
        return bl;
    }

    public int readBits(int n) {
        return this.get_bits(n);
    }

    public int readCheckedBits(int n) {
        return this.get_bits(n);
    }

    protected BitstreamException newBitstreamException(int n) {
        return new BitstreamException(n, null);
    }

    protected BitstreamException newBitstreamException(int n, Throwable throwable) {
        return new BitstreamException(n, throwable);
    }

    int bdh(byte by) throws BitstreamException {
        boolean bl;
        int n = this.LThtl(this.LTHTl, 0, 3);
        if (n != 3) {
            throw this.newBitstreamException(260, null);
        }
        int n2 = this.LTHTl[0] << 16 & 0xFF0000 | this.LTHTl[1] << 8 & 0xFF00 | this.LTHTl[2] << 0 & 0xFF;
        do {
            n2 <<= 8;
            if (this.LThtl(this.LTHTl, 3, 1) == 1) continue;
            throw this.newBitstreamException(260, null);
        } while (!(bl = this.isSyncMark(n2 |= this.LTHTl[3] & 0xFF, by, this.lThTl)));
        return n2;
    }

    public boolean isSyncMark(int n, int n2, int n3) {
        boolean bl = false;
        if (n2 == bdH) {
            bl = (n & 0xFFE00000) == -2097152;
        } else {
            boolean bl2 = (n & 0xFFF80C00) == n3 && (n & 0xC0) == 192 == this.LThTl ? true : (bl = false);
        }
        if (bl) {
            boolean bl3 = bl = (n >>> 10 & 3) != 3;
        }
        if (bl) {
            boolean bl4 = bl = (n >>> 17 & 3) != 0;
        }
        if (bl) {
            bl = (n >>> 19 & 3) != 1;
        }
        return bl;
    }

    void Bdh(int n) throws BitstreamException {
        boolean bl = false;
        this.lThtl(this.LTHtl, 0, n);
        this.lTHtl = n;
        this.lthTl = -1;
        this.LthTl = -1;
    }

    void bDh() throws BitstreamException {
        int n = 0;
        byte[] byArray = this.LTHtl;
        int n2 = this.lTHtl;
        int n3 = 0;
        while (n3 < n2) {
            boolean bl = false;
            byte by = 0;
            byte by2 = 0;
            byte by3 = 0;
            byte by4 = 0;
            by = byArray[n3];
            if (n3 + 1 < n2) {
                by2 = byArray[n3 + 1];
            }
            if (n3 + 2 < n2) {
                by3 = byArray[n3 + 2];
            }
            if (n3 + 3 < n2) {
                by4 = byArray[n3 + 3];
            }
            this.LtHtl[n++] = by << 24 & 0xFF000000 | by2 << 16 & 0xFF0000 | by3 << 8 & 0xFF00 | by4 & 0xFF;
            n3 += 4;
        }
        this.lthTl = 0;
        this.LthTl = 0;
    }

    public int get_bits(int n) {
        int n2 = 0;
        int n3 = this.LthTl + n;
        if (this.lthTl < 0) {
            this.lthTl = 0;
        }
        if (n3 <= 32) {
            n2 = this.LtHtl[this.lthTl] >>> 32 - n3 & this.ltHTl[n];
            if ((this.LthTl += n) == 32) {
                this.LthTl = 0;
                ++this.lthTl;
            }
            return n2;
        }
        int n4 = this.LtHtl[this.lthTl] & 0xFFFF;
        ++this.lthTl;
        int n5 = this.LtHtl[this.lthTl] & 0xFFFF0000;
        n2 = n4 << 16 & 0xFFFF0000 | n5 >>> 16 & 0xFFFF;
        n2 >>>= 48 - n3;
        this.LthTl = n3 - 32;
        return n2 &= this.ltHTl[n];
    }

    void BDh(int n) {
        this.lThTl = n & 0xFFFFFF3F;
        this.LThTl = (n & 0xC0) == 192;
    }

    private void lThtl(byte[] byArray, int n, int n2) throws BitstreamException {
        try {
            while (n2 > 0) {
                int n3 = this.LtHTl.read(byArray, n, n2);
                if (n3 == -1) {
                    while (n2-- > 0) {
                        byArray[n++] = 0;
                    }
                    break;
                }
                n += n3;
                n2 -= n3;
            }
        }
        catch (IOException iOException) {
            throw this.newBitstreamException(258, iOException);
        }
    }

    private int LThtl(byte[] byArray, int n, int n2) throws BitstreamException {
        int n3 = 0;
        try {
            while (n2 > 0) {
                int n4 = this.LtHTl.read(byArray, n, n2);
                if (n4 != -1) {
                    n3 += n4;
                    n += n4;
                    n2 -= n4;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw this.newBitstreamException(258, iOException);
        }
        return n3;
    }
}

