/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.converter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javazoom.jl.converter.Converter$PrintWriterProgressListener;
import javazoom.jl.converter.Converter$ProgressListener;
import javazoom.jl.converter.WaveFileObuffer;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.Obuffer;

public class Converter {
    public synchronized void convert(String string, String string2) throws JavaLayerException {
        this.convert(string, string2, null, null);
    }

    public synchronized void convert(String string, String string2, Converter$ProgressListener converter$ProgressListener) throws JavaLayerException {
        this.convert(string, string2, converter$ProgressListener, null);
    }

    public void convert(String string, String string2, Converter$ProgressListener converter$ProgressListener, Decoder.Params params) throws JavaLayerException {
        if (string2.length() == 0) {
            string2 = null;
        }
        try {
            InputStream inputStream = this.openInput(string);
            this.convert(inputStream, string2, converter$ProgressListener, params);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new JavaLayerException(iOException.getLocalizedMessage(), iOException);
        }
    }

    public synchronized void convert(InputStream inputStream, String string, Converter$ProgressListener converter$ProgressListener, Decoder.Params params) throws JavaLayerException {
        if (converter$ProgressListener == null) {
            converter$ProgressListener = Converter$PrintWriterProgressListener.newStdOut(0);
        }
        try {
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            int n = -1;
            if (inputStream.markSupported()) {
                inputStream.mark(-1);
                n = this.countFrames(inputStream);
                inputStream.reset();
            }
            converter$ProgressListener.converterUpdate(1, n, 0);
            Obuffer obuffer = null;
            Decoder decoder = new Decoder(params);
            Bitstream bitstream = new Bitstream(inputStream);
            if (n == -1) {
                n = Integer.MAX_VALUE;
            }
            int n2 = 0;
            long l = System.currentTimeMillis();
            try {
                while (n2 < n) {
                    block15: {
                        try {
                            Obuffer obuffer2;
                            Header header = bitstream.readFrame();
                            if (header == null) break;
                            converter$ProgressListener.readFrame(n2, header);
                            if (obuffer == null) {
                                int n3 = header.mode() == 3 ? 1 : 2;
                                int n4 = header.frequency();
                                obuffer = new WaveFileObuffer(n3, n4, string);
                                decoder.setOutputBuffer(obuffer);
                            }
                            if ((obuffer2 = decoder.decodeFrame(header, bitstream)) != obuffer) {
                                throw new InternalError("Output buffers are different.");
                            }
                            converter$ProgressListener.decodedFrame(n2, header, obuffer);
                            bitstream.closeFrame();
                        }
                        catch (Exception exception) {
                            boolean bl;
                            boolean bl2 = bl = !converter$ProgressListener.converterException(exception);
                            if (!bl) break block15;
                            throw new JavaLayerException(exception.getLocalizedMessage(), exception);
                        }
                    }
                    ++n2;
                }
                Object var16_19 = null;
                if (obuffer != null) {
                    obuffer.close();
                }
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                if (obuffer != null) {
                    obuffer.close();
                }
                throw throwable;
            }
            int n5 = (int)(System.currentTimeMillis() - l);
            converter$ProgressListener.converterUpdate(2, n5, n2);
        }
        catch (IOException iOException) {
            throw new JavaLayerException(iOException.getLocalizedMessage(), iOException);
        }
    }

    protected int countFrames(InputStream inputStream) {
        return -1;
    }

    protected InputStream openInput(String string) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        return bufferedInputStream;
    }
}

